/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.vesoft.nebula.driver.graph.data.BaseDataObject;
import com.vesoft.nebula.driver.graph.data.ValueWrapper;
import com.vesoft.nebula.driver.graph.decode.struct.ResultGraphSchemas;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Edge
extends BaseDataObject {
    private final int graphId;
    private final String graphName;
    private final int edgeTypeId;
    private final String edgeTypeName;
    private final List<String> labels;
    private final long rank;
    private final long srcId;
    private final long dstId;
    private final Direction direction;
    private final Map<String, ValueWrapper> properties;

    public Edge(int graphId, int edgeTypeId, long rank, long srcId, long dstId, Map<String, ValueWrapper> properties, ResultGraphSchemas graphSchemas) {
        this.graphId = graphId;
        this.graphName = graphSchemas.getGraphSchema(graphId).getGraphName();
        this.edgeTypeId = edgeTypeId;
        int noDirectedTypeId = edgeTypeId & 0x3FFFFFFF;
        this.edgeTypeName = graphSchemas.getGraphSchema(graphId).getEdgeSchema(noDirectedTypeId).getEdgeTypeName();
        this.labels = graphSchemas.getGraphSchema(graphId).getEdgeSchema(noDirectedTypeId).getEdgeLabels();
        this.rank = rank;
        this.properties = properties;
        int edgeTypeMoveBits = 30;
        int directionBits = edgeTypeId >> edgeTypeMoveBits & 3;
        switch (directionBits) {
            case 0: {
                this.direction = Direction.OUTGOING;
                break;
            }
            case 1: {
                this.direction = Direction.INCOMING;
                break;
            }
            case 2: 
            case 3: {
                this.direction = Direction.UNDIRECTED;
                break;
            }
            default: {
                this.direction = Direction.KNOWN;
            }
        }
        if (this.direction == Direction.INCOMING) {
            this.srcId = dstId;
            this.dstId = srcId;
        } else {
            this.srcId = srcId;
            this.dstId = dstId;
        }
    }

    public String getGraph() {
        return this.graphName;
    }

    public String getType() {
        return this.edgeTypeName;
    }

    public int getEdgeTypeId() {
        return this.edgeTypeId;
    }

    public boolean isDirected() {
        return this.direction == Direction.OUTGOING || this.direction == Direction.INCOMING;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public long getSrcId() {
        return this.srcId;
    }

    public long getDstId() {
        return this.dstId;
    }

    public long getRank() {
        return this.rank;
    }

    public List<String> getColumnNames() {
        return new ArrayList<String>(this.properties.keySet());
    }

    public List<ValueWrapper> getPropertyValues() {
        ArrayList<ValueWrapper> values = new ArrayList<ValueWrapper>();
        for (Map.Entry<String, ValueWrapper> kv : this.properties.entrySet()) {
            values.add(kv.getValue());
        }
        return values;
    }

    public Map<String, ValueWrapper> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Edge that = (Edge)o;
        return this.getRank() == that.getRank() && (this.getSrcId() == that.getSrcId() && this.getDstId() == that.getDstId() || this.getSrcId() == that.getDstId() && this.getDstId() == that.getSrcId()) && Objects.equals(this.getType(), that.getType());
    }

    public int hashCode() {
        return Objects.hash(this.graphId, this.edgeTypeId, this.rank, this.srcId, this.dstId, this.getDecodeType());
    }

    public String toString() {
        ArrayList<String> propStrs = new ArrayList<String>();
        Map<String, ValueWrapper> props = this.getProperties();
        for (String key : props.keySet()) {
            propStrs.add(key + ":" + props.get(key).toString());
        }
        if (this.direction != Direction.UNDIRECTED) {
            return String.format("(%d)-[%d@%s:%s{%s}]->(%d)", this.getSrcId(), this.getRank(), this.getType(), String.join((CharSequence)"&", this.getLabels()), String.join((CharSequence)",", propStrs), this.getDstId());
        }
        return String.format("(%d)~[%d@%s:%s{%s}]~(%d)", this.getSrcId(), this.getRank(), this.getType(), String.join((CharSequence)"&", this.getLabels()), String.join((CharSequence)",", propStrs), this.getDstId());
    }

    static enum Direction {
        OUTGOING,
        INCOMING,
        UNDIRECTED,
        KNOWN;

    }
}

