/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode;

import com.vesoft.nebula.driver.graph.decode.VectorWrapper;
import com.vesoft.nebula.proto.graph.NestedVector;
import com.vesoft.nebula.proto.graph.VectorBatch;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class Batch {
    private final VectorBatch batch;
    private final List<VectorWrapper> vectors = new ArrayList<VectorWrapper>();

    public Batch(VectorBatch batch, ByteOrder byteOrder) {
        this.batch = batch;
        for (NestedVector vector : batch.getVectorsList()) {
            this.vectors.add(new VectorWrapper(vector, byteOrder));
        }
    }

    public int getVectorsCount() {
        return this.batch.getVectorsCount();
    }

    public VectorWrapper getVectors(int index) {
        return this.vectors.get(index);
    }

    public int getBatchRowSize() {
        if (this.getVectorsCount() > 0) {
            return this.batch.getVectors(0).getCommonMetaData().getNumRecords();
        }
        return 0;
    }
}

