/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode.struct;

import com.google.protobuf.ByteString;
import com.vesoft.nebula.driver.graph.decode.BytesReader;
import com.vesoft.nebula.driver.graph.decode.DecodeUtils;
import com.vesoft.nebula.driver.graph.decode.VectorWrapper;
import com.vesoft.nebula.driver.graph.decode.struct.PathVectorPair;
import com.vesoft.nebula.proto.graph.NestedVector;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;

public class PathSpecialMetaData {
    private final Map<Integer, Map<Integer, Integer>> graphIdAndNodeTypes = new HashMap<Integer, Map<Integer, Integer>>();
    private final Map<Integer, Map<Integer, Integer>> graphIdAndEdgeTypes = new HashMap<Integer, Map<Integer, Integer>>();
    private final Map<Integer, PathVectorPair> indexAndNodes = new HashMap<Integer, PathVectorPair>();
    private final Map<Integer, PathVectorPair> indexAndEdges = new HashMap<Integer, PathVectorPair>();

    public PathSpecialMetaData(NestedVector vector, ByteOrder byteOrder) {
        ByteString metaData = vector.getSpecialMetaData();
        BytesReader reader = new BytesReader(metaData);
        int nestedVectorIndex = 0;
        int nodeTypeNum = DecodeUtils.bytesToInt32(reader.read(4), byteOrder);
        for (int i = 0; i < nodeTypeNum; ++i) {
            int graphId = DecodeUtils.bytesToInt32(reader.read(4), byteOrder);
            short nodeTypeId = DecodeUtils.bytesToInt16(reader.read(2), byteOrder);
            short nodeTypePairIndex = DecodeUtils.bytesToInt16(reader.read(2), byteOrder);
            if (!this.graphIdAndNodeTypes.containsKey(graphId)) {
                this.graphIdAndNodeTypes.put(graphId, new HashMap());
            }
            this.graphIdAndNodeTypes.get(graphId).put(Integer.valueOf(nodeTypeId), Integer.valueOf(nodeTypePairIndex));
            PathVectorPair pair = new PathVectorPair(new VectorWrapper(vector.getNestedVectors(nestedVectorIndex++), byteOrder), new VectorWrapper(vector.getNestedVectors(nestedVectorIndex++), byteOrder));
            this.indexAndNodes.put(Integer.valueOf(nodeTypePairIndex), pair);
        }
        int edgeTypeNum = DecodeUtils.bytesToInt32(reader.read(4), byteOrder);
        for (int i = 0; i < edgeTypeNum; ++i) {
            int graphId = DecodeUtils.bytesToInt32(reader.read(4), byteOrder);
            int edgeTypeId = DecodeUtils.bytesToInt32(reader.read(4), byteOrder);
            short edgeTypePairIndex = DecodeUtils.bytesToInt16(reader.read(2), byteOrder);
            if (!this.graphIdAndEdgeTypes.containsKey(graphId)) {
                this.graphIdAndEdgeTypes.put(graphId, new HashMap());
            }
            this.graphIdAndEdgeTypes.get(graphId).put(edgeTypeId, Integer.valueOf(edgeTypePairIndex));
            PathVectorPair pair = new PathVectorPair(new VectorWrapper(vector.getNestedVectors(nestedVectorIndex++), byteOrder), new VectorWrapper(vector.getNestedVectors(nestedVectorIndex++), byteOrder));
            this.indexAndEdges.put(Integer.valueOf(edgeTypePairIndex), pair);
        }
    }

    public Map<Integer, Map<Integer, Integer>> getGraphIdAndNodeTypes() {
        return this.graphIdAndNodeTypes;
    }

    public Map<Integer, Map<Integer, Integer>> getGraphIdAndEdgeTypes() {
        return this.graphIdAndEdgeTypes;
    }

    public Map<Integer, PathVectorPair> getIndexAndNodes() {
        return this.indexAndNodes;
    }

    public Map<Integer, PathVectorPair> getIndexAndEdges() {
        return this.indexAndEdges;
    }
}

