/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Envelope;

public abstract class PackedCoordinateSequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = -3151899011275603L;
    protected int dimension;
    protected int measures;
    protected transient SoftReference<Coordinate[]> coordRef;

    protected PackedCoordinateSequence(int dimension, int measures) {
        if (dimension - measures < 2) {
            throw new IllegalArgumentException("Must have at least 2 spatial dimensions");
        }
        this.dimension = dimension;
        this.measures = measures;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public int getMeasures() {
        return this.measures;
    }

    @Override
    public Coordinate getCoordinate(int i) {
        Coordinate[] coords = this.getCachedCoords();
        if (coords != null) {
            return coords[i];
        }
        return this.getCoordinateInternal(i);
    }

    @Override
    public Coordinate getCoordinateCopy(int i) {
        return this.getCoordinateInternal(i);
    }

    @Override
    public void getCoordinate(int i, Coordinate coord) {
        coord.x = this.getOrdinate(i, 0);
        coord.y = this.getOrdinate(i, 1);
        if (this.hasZ()) {
            coord.setZ(this.getZ(i));
        }
        if (this.hasM()) {
            coord.setM(this.getM(i));
        }
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        Coordinate[] coords = this.getCachedCoords();
        if (coords != null) {
            return coords;
        }
        coords = new Coordinate[this.size()];
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = this.getCoordinateInternal(i);
        }
        this.coordRef = new SoftReference<Coordinate[]>(coords);
        return coords;
    }

    private Coordinate[] getCachedCoords() {
        if (this.coordRef != null) {
            Coordinate[] coords = this.coordRef.get();
            if (coords != null) {
                return coords;
            }
            this.coordRef = null;
            return null;
        }
        return null;
    }

    @Override
    public double getX(int index) {
        return this.getOrdinate(index, 0);
    }

    @Override
    public double getY(int index) {
        return this.getOrdinate(index, 1);
    }

    @Override
    public abstract double getOrdinate(int var1, int var2);

    public void setX(int index, double value) {
        this.coordRef = null;
        this.setOrdinate(index, 0, value);
    }

    public void setY(int index, double value) {
        this.coordRef = null;
        this.setOrdinate(index, 1, value);
    }

    public String toString() {
        return CoordinateSequences.toString(this);
    }

    protected Object readResolve() throws ObjectStreamException {
        this.coordRef = null;
        return this;
    }

    protected abstract Coordinate getCoordinateInternal(int var1);

    @Override
    public abstract Object clone();

    @Override
    public abstract PackedCoordinateSequence copy();

    @Override
    public abstract void setOrdinate(int var1, int var2, double var3);

    public static class Float
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = -2902252401427938986L;
        float[] coords;

        public Float(float[] coords, int dimension, int measures) {
            super(dimension, measures);
            if (coords.length % dimension != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.coords = coords;
        }

        public Float(double[] coordinates, int dimension, int measures) {
            super(dimension, measures);
            this.coords = new float[coordinates.length];
            for (int i = 0; i < coordinates.length; ++i) {
                this.coords[i] = (float)coordinates[i];
            }
        }

        public Float(Coordinate[] coordinates, int dimension) {
            this(coordinates, dimension, 0);
        }

        public Float(Coordinate[] coordinates, int dimension, int measures) {
            super(dimension, measures);
            if (coordinates == null) {
                coordinates = new Coordinate[]{};
            }
            this.coords = new float[coordinates.length * this.dimension];
            for (int i = 0; i < coordinates.length; ++i) {
                this.coords[i * this.dimension] = (float)coordinates[i].x;
                if (this.dimension >= 2) {
                    this.coords[i * this.dimension + 1] = (float)coordinates[i].y;
                }
                if (this.dimension < 3) continue;
                this.coords[i * this.dimension + 2] = (float)coordinates[i].getZ();
            }
        }

        public Float(int size, int dimension, int measures) {
            super(dimension, measures);
            this.coords = new float[size * this.dimension];
        }

        @Override
        public Coordinate getCoordinateInternal(int i) {
            double x = this.coords[i * this.dimension];
            double y = this.coords[i * this.dimension + 1];
            if (this.dimension == 2 && this.measures == 0) {
                return new CoordinateXY(x, y);
            }
            if (this.dimension == 3 && this.measures == 0) {
                double z = this.coords[i * this.dimension + 2];
                return new Coordinate(x, y, z);
            }
            if (this.dimension == 3 && this.measures == 1) {
                double m4 = this.coords[i * this.dimension + 2];
                return new CoordinateXYM(x, y, m4);
            }
            if (this.dimension == 4 && this.measures == 1) {
                double z = this.coords[i * this.dimension + 2];
                double m5 = this.coords[i * this.dimension + 3];
                return new CoordinateXYZM(x, y, z, m5);
            }
            return new Coordinate(x, y);
        }

        public float[] getRawCoordinates() {
            return this.coords;
        }

        @Override
        public int size() {
            return this.coords.length / this.dimension;
        }

        @Override
        public Object clone() {
            return this.copy();
        }

        @Override
        public Float copy() {
            float[] clone = Arrays.copyOf(this.coords, this.coords.length);
            return new Float(clone, this.dimension, this.measures);
        }

        @Override
        public double getOrdinate(int index, int ordinate) {
            return this.coords[index * this.dimension + ordinate];
        }

        @Override
        public void setOrdinate(int index, int ordinate, double value) {
            this.coordRef = null;
            this.coords[index * this.dimension + ordinate] = (float)value;
        }

        @Override
        public Envelope expandEnvelope(Envelope env) {
            for (int i = 0; i < this.coords.length; i += this.dimension) {
                env.expandToInclude(this.coords[i], this.coords[i + 1]);
            }
            return env;
        }
    }

    public static class Double
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = 5777450686367912719L;
        double[] coords;

        public Double(double[] coords, int dimension, int measures) {
            super(dimension, measures);
            if (coords.length % dimension != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.coords = coords;
        }

        public Double(float[] coordinates, int dimension, int measures) {
            super(dimension, measures);
            this.coords = new double[coordinates.length];
            for (int i = 0; i < coordinates.length; ++i) {
                this.coords[i] = coordinates[i];
            }
        }

        public Double(Coordinate[] coordinates, int dimension) {
            this(coordinates, dimension, 0);
        }

        public Double(Coordinate[] coordinates, int dimension, int measures) {
            super(dimension, measures);
            if (coordinates == null) {
                coordinates = new Coordinate[]{};
            }
            this.coords = new double[coordinates.length * this.dimension];
            for (int i = 0; i < coordinates.length; ++i) {
                this.coords[i * this.dimension] = coordinates[i].x;
                if (this.dimension >= 2) {
                    this.coords[i * this.dimension + 1] = coordinates[i].y;
                }
                if (this.dimension >= 3) {
                    this.coords[i * this.dimension + 2] = coordinates[i].getOrdinate(2);
                }
                if (this.dimension < 4) continue;
                this.coords[i * this.dimension + 3] = coordinates[i].getOrdinate(3);
            }
        }

        public Double(Coordinate[] coordinates) {
            this(coordinates, 3, 0);
        }

        public Double(int size, int dimension, int measures) {
            super(dimension, measures);
            this.coords = new double[size * this.dimension];
        }

        @Override
        public Coordinate getCoordinateInternal(int i) {
            double x = this.coords[i * this.dimension];
            double y = this.coords[i * this.dimension + 1];
            if (this.dimension == 2 && this.measures == 0) {
                return new CoordinateXY(x, y);
            }
            if (this.dimension == 3 && this.measures == 0) {
                double z = this.coords[i * this.dimension + 2];
                return new Coordinate(x, y, z);
            }
            if (this.dimension == 3 && this.measures == 1) {
                double m4 = this.coords[i * this.dimension + 2];
                return new CoordinateXYM(x, y, m4);
            }
            if (this.dimension == 4 && this.measures == 1) {
                double z = this.coords[i * this.dimension + 2];
                double m5 = this.coords[i * this.dimension + 3];
                return new CoordinateXYZM(x, y, z, m5);
            }
            return new Coordinate(x, y);
        }

        public double[] getRawCoordinates() {
            return this.coords;
        }

        @Override
        public int size() {
            return this.coords.length / this.dimension;
        }

        @Override
        public Object clone() {
            return this.copy();
        }

        @Override
        public Double copy() {
            double[] clone = Arrays.copyOf(this.coords, this.coords.length);
            return new Double(clone, this.dimension, this.measures);
        }

        @Override
        public double getOrdinate(int index, int ordinate) {
            return this.coords[index * this.dimension + ordinate];
        }

        @Override
        public void setOrdinate(int index, int ordinate, double value) {
            this.coordRef = null;
            this.coords[index * this.dimension + ordinate] = value;
        }

        @Override
        public Envelope expandEnvelope(Envelope env) {
            for (int i = 0; i < this.coords.length; i += this.dimension) {
                env.expandToInclude(this.coords[i], this.coords[i + 1]);
            }
            return env;
        }
    }
}

