/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.ClientPoolFactory;
import com.vesoft.nebula.client.graph.net.LoadBalancer;
import com.vesoft.nebula.client.graph.net.NebulaClient;
import com.vesoft.nebula.client.graph.net.RoundRobinLoadBalancer;
import com.vesoft.nebula.client.graph.utils.AddressUtil;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NebulaPool
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private GenericObjectPool<NebulaClient> pool;
    private LoadBalancer loadBalancer;
    private final AtomicBoolean hasInit = new AtomicBoolean(false);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private long maxWaitMills;

    public static Builder builder(String addresses, String userName) {
        return NebulaPool.builder(addresses, userName, null);
    }

    public static Builder builder(String addresses, String userName, String password) {
        return new Builder(addresses, userName, password);
    }

    private NebulaPool(Builder builder) throws IOErrorException {
        if (this.hasInit.get()) {
            return;
        }
        this.maxWaitMills = builder.maxWaitMills;
        this.loadBalancer = new RoundRobinLoadBalancer(builder.address, builder.userName, builder.authOptions, builder.strictlyServerHealthy, builder.healthCheckTimeMills);
        if (!this.loadBalancer.isServersOK()) {
            this.loadBalancer.close();
            this.logger.error("servers status is not ok, please check the server status or network.");
            throw new IOErrorException(3, "Servers status is not ok.");
        }
        GenericObjectPoolConfig objConfig = new GenericObjectPoolConfig();
        objConfig.setMaxIdle(builder.maxClientSize);
        objConfig.setMinIdle(builder.minClientSize);
        objConfig.setMaxTotal(builder.maxClientSize);
        objConfig.setBlockWhenExhausted(builder.blockWhenExhausted);
        objConfig.setMaxWaitMillis(builder.maxWaitMills);
        objConfig.setTimeBetweenEvictionRunsMillis(builder.idleEvictScheduleMills);
        objConfig.setMinEvictableIdleTimeMillis(builder.minEvictableIdleTimeMillis);
        if (builder.healthCheckTimeMills > 0L) {
            objConfig.setTestWhileIdle(true);
            objConfig.setTimeBetweenEvictionRunsMillis(builder.healthCheckTimeMills);
        }
        ClientPoolFactory factory = new ClientPoolFactory(this.loadBalancer, builder.userName, builder.authOptions, builder.connectTimeoutMills, builder.requestTimeoutMills, builder.scanParallel, builder.workingGraph, builder.timeZone, builder.schemaName, builder.parameters);
        this.pool = new GenericObjectPool<NebulaClient>(factory, objConfig);
        this.hasInit.compareAndSet(false, true);
    }

    public NebulaClient getClient() throws Exception {
        return this.pool.borrowObject(this.maxWaitMills);
    }

    public void returnClient(NebulaClient client) {
        if (client.isClosed()) {
            try {
                this.pool.invalidateObject(client);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.pool.returnObject(client);
        }
    }

    public void close() {
        this.loadBalancer.close();
        this.pool.close();
    }

    public int getActiveSessions() {
        return this.pool.getNumActive();
    }

    public int getIdleSessions() {
        return this.pool.getNumIdle();
    }

    public int getWaiters() {
        return this.pool.getNumWaiters();
    }

    public static class Builder {
        private final List<HostAddress> address;
        private final String userName;
        private final String password;
        private Map<String, Object> authOptions = new HashMap<String, Object>();
        private int maxClientSize = 10;
        private int minClientSize = 1;
        private long connectTimeoutMills = 3000L;
        private long requestTimeoutMills = 60000L;
        private long healthCheckTimeMills = 300000L;
        private boolean blockWhenExhausted = false;
        private long maxWaitMills = Long.MAX_VALUE;
        private long idleEvictScheduleMills = -1L;
        private long minEvictableIdleTimeMillis = 1800000L;
        private boolean strictlyServerHealthy = false;
        private String workingGraph = null;
        private ZoneId timeZone = null;
        private String schemaName = null;
        private Map<String, String> parameters = new HashMap<String, String>();
        private int scanParallel = 10;

        public Builder(String addresses, String userName, String password) {
            try {
                this.address = AddressUtil.validateAddress(addresses);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            this.userName = userName;
            this.password = password;
        }

        public Builder withAuthOptions(Map<String, Object> authOptions) {
            if (authOptions != null) {
                this.authOptions.putAll(authOptions);
            }
            return this;
        }

        public Builder withMaxClientSize(int maxClientSize) {
            if (maxClientSize < 1) {
                throw new IllegalArgumentException("maxClientSize cannot be less than 1.");
            }
            this.maxClientSize = maxClientSize;
            return this;
        }

        public Builder withMinClientSize(int minClientSize) {
            if (minClientSize < 0) {
                throw new IllegalArgumentException("minClientSize cannot be less than 0.");
            }
            this.minClientSize = minClientSize;
            return this;
        }

        public Builder withConnectTimeoutMills(long connectTimeoutMills) {
            this.connectTimeoutMills = connectTimeoutMills <= 0L || connectTimeoutMills > Integer.MAX_VALUE ? Integer.MAX_VALUE : connectTimeoutMills;
            return this;
        }

        public Builder withRequestTimeoutMills(long requestTimeoutMills) {
            if (requestTimeoutMills <= 0L || requestTimeoutMills > Integer.MAX_VALUE) {
                this.requestTimeoutMills = Integer.MAX_VALUE;
            } else {
                this.connectTimeoutMills = requestTimeoutMills;
            }
            return this;
        }

        public Builder withHealthCheckTimeMills(long healthCheckTimeMills) {
            this.healthCheckTimeMills = Math.max(healthCheckTimeMills, 0L);
            return this;
        }

        public Builder withBlockWhenExhausted(boolean blockWhenExhausted) {
            this.blockWhenExhausted = blockWhenExhausted;
            return this;
        }

        public Builder withMaxWaitMills(long maxWaitMills) {
            this.maxWaitMills = maxWaitMills <= 0L ? Long.MAX_VALUE : maxWaitMills;
            return this;
        }

        public Builder withIdleEvictScheduleMills(long idleEvictScheduleMills) {
            this.idleEvictScheduleMills = idleEvictScheduleMills;
            return this;
        }

        public Builder withMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
            this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
            return this;
        }

        public Builder withStrictlyServerHealthy(boolean strictlyServerHealthy) {
            this.strictlyServerHealthy = strictlyServerHealthy;
            return this;
        }

        public Builder withWorkingGraph(String workingGraph) {
            this.workingGraph = workingGraph;
            return this;
        }

        public Builder withTimeZone(ZoneId zoneId) {
            this.timeZone = zoneId;
            return this;
        }

        public Builder withSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder withParameters(Map<String, String> parameters) {
            if (parameters != null) {
                this.parameters = parameters;
            }
            return this;
        }

        public Builder addParameter(String paramName, String value) {
            if (paramName != null) {
                this.parameters.put(paramName, value);
            }
            return this;
        }

        public Builder withScanParallel(int scanParallel) {
            this.scanParallel = scanParallel;
            return this;
        }

        public void check() {
            if (this.address == null) {
                throw new IllegalArgumentException("Graph addresses cannot be empty.");
            }
            if (this.userName == null || this.userName.trim().isEmpty()) {
                throw new IllegalArgumentException("user name cannot be empty.");
            }
            if (this.authOptions.isEmpty() && (this.password == null || this.password.trim().isEmpty())) {
                throw new IllegalArgumentException("auth options and password cannot be empty at the same time.");
            }
        }

        public NebulaPool build() throws IOErrorException {
            this.check();
            if (this.password != null) {
                this.authOptions.put("password", this.password);
            }
            return new NebulaPool(this);
        }
    }
}

