/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.client.graph.utils.ZoneOffsetUtil;
import com.vesoft.nebula.proto.common.ZonedDatetime;
import java.util.Objects;

public class NZonedDateTime {
    private final ZonedDatetime zonedDateTime;

    public NZonedDateTime(ZonedDatetime zonedDateTime) {
        this.zonedDateTime = zonedDateTime;
    }

    public int getYear() {
        return this.zonedDateTime.getYear();
    }

    public int getMonth() {
        return this.zonedDateTime.getMonth();
    }

    public int getDay() {
        return this.zonedDateTime.getDay();
    }

    public int getHour() {
        return this.zonedDateTime.getHour();
    }

    public int getMinute() {
        return this.zonedDateTime.getMinute();
    }

    public int getSecond() {
        return this.zonedDateTime.getSec();
    }

    public int getMicrosec() {
        return this.zonedDateTime.getMicrosec();
    }

    public int getOffset() {
        return this.zonedDateTime.getOffset();
    }

    public String toString() {
        return String.format("%d-%02d-%02dT%02d:%02d:%02d.%06d%s", this.zonedDateTime.getYear(), this.zonedDateTime.getMonth(), this.zonedDateTime.getDay(), this.zonedDateTime.getHour(), this.zonedDateTime.getMinute(), this.zonedDateTime.getSec(), this.zonedDateTime.getMicrosec(), ZoneOffsetUtil.buildOffset(this.zonedDateTime.getOffset()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NZonedDateTime that = (NZonedDateTime)o;
        return this.zonedDateTime.getYear() == that.getYear() && this.zonedDateTime.getMonth() == that.getMonth() && this.zonedDateTime.getDay() == that.getDay() && this.zonedDateTime.getHour() == that.getHour() && this.zonedDateTime.getMinute() == that.getMinute() && this.zonedDateTime.getSec() == that.getSecond() && this.zonedDateTime.getMicrosec() == that.getMicrosec();
    }

    public int hashCode() {
        return Objects.hash(this.zonedDateTime, this.getOffset());
    }
}

