/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.QueryDesc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UpdateSessionsResp
implements TBase,
Serializable,
Cloneable,
Comparable<UpdateSessionsResp> {
    private static final TStruct STRUCT_DESC = new TStruct("UpdateSessionsResp");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 2);
    private static final TField KILLED_QUERIES_FIELD_DESC = new TField("killed_queries", 13, 3);
    private static final TField KILLED_SESSIONS_FIELD_DESC = new TField("killed_sessions", 15, 4);
    public ErrorCode code;
    public HostAddr leader;
    public Map<Long, Map<Long, QueryDesc>> killed_queries;
    public List<Long> killed_sessions;
    public static final int CODE = 1;
    public static final int LEADER = 2;
    public static final int KILLED_QUERIES = 3;
    public static final int KILLED_SESSIONS = 4;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public UpdateSessionsResp() {
    }

    public UpdateSessionsResp(ErrorCode code, HostAddr leader, Map<Long, Map<Long, QueryDesc>> killed_queries, List<Long> killed_sessions) {
        this();
        this.code = code;
        this.leader = leader;
        this.killed_queries = killed_queries;
        this.killed_sessions = killed_sessions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateSessionsResp(UpdateSessionsResp other) {
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
        if (other.isSetKilled_queries()) {
            this.killed_queries = TBaseHelper.deepCopy(other.killed_queries);
        }
        if (other.isSetKilled_sessions()) {
            this.killed_sessions = TBaseHelper.deepCopy(other.killed_sessions);
        }
    }

    @Override
    public UpdateSessionsResp deepCopy() {
        return new UpdateSessionsResp(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public UpdateSessionsResp setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public UpdateSessionsResp setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public Map<Long, Map<Long, QueryDesc>> getKilled_queries() {
        return this.killed_queries;
    }

    public UpdateSessionsResp setKilled_queries(Map<Long, Map<Long, QueryDesc>> killed_queries) {
        this.killed_queries = killed_queries;
        return this;
    }

    public void unsetKilled_queries() {
        this.killed_queries = null;
    }

    public boolean isSetKilled_queries() {
        return this.killed_queries != null;
    }

    public void setKilled_queriesIsSet(boolean __value) {
        if (!__value) {
            this.killed_queries = null;
        }
    }

    public List<Long> getKilled_sessions() {
        return this.killed_sessions;
    }

    public UpdateSessionsResp setKilled_sessions(List<Long> killed_sessions) {
        this.killed_sessions = killed_sessions;
        return this;
    }

    public void unsetKilled_sessions() {
        this.killed_sessions = null;
    }

    public boolean isSetKilled_sessions() {
        return this.killed_sessions != null;
    }

    public void setKilled_sessionsIsSet(boolean __value) {
        if (!__value) {
            this.killed_sessions = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetKilled_queries();
                    break;
                }
                this.setKilled_queries((Map)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetKilled_sessions();
                    break;
                }
                this.setKilled_sessions((List)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return this.getLeader();
            }
            case 3: {
                return this.getKilled_queries();
            }
            case 4: {
                return this.getKilled_sessions();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof UpdateSessionsResp)) {
            return false;
        }
        UpdateSessionsResp that = (UpdateSessionsResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetKilled_queries(), that.isSetKilled_queries(), this.killed_queries, that.killed_queries)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetKilled_sessions(), that.isSetKilled_sessions(), this.killed_sessions, that.killed_sessions);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.leader, this.killed_queries, this.killed_sessions});
    }

    @Override
    public int compareTo(UpdateSessionsResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKilled_queries()).compareTo(other.isSetKilled_queries());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.killed_queries, other.killed_queries);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKilled_sessions()).compareTo(other.isSetKilled_sessions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.killed_sessions, other.killed_sessions);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 13) {
                        TMap _map388 = iprot.readMapBegin();
                        this.killed_queries = new HashMap<Long, Map<Long, QueryDesc>>(Math.max(0, 2 * _map388.size));
                        int _i389 = 0;
                        while (_map388.size < 0 ? iprot.peekMap() : _i389 < _map388.size) {
                            long _key390 = iprot.readI64();
                            TMap _map392 = iprot.readMapBegin();
                            HashMap<Long, QueryDesc> _val391 = new HashMap<Long, QueryDesc>(Math.max(0, 2 * _map392.size));
                            int _i393 = 0;
                            while (_map392.size < 0 ? iprot.peekMap() : _i393 < _map392.size) {
                                long _key394 = iprot.readI64();
                                QueryDesc _val395 = new QueryDesc();
                                _val395.read(iprot);
                                _val391.put(_key394, _val395);
                                ++_i393;
                            }
                            iprot.readMapEnd();
                            this.killed_queries.put(_key390, _val391);
                            ++_i389;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 15) {
                        TList _list396 = iprot.readListBegin();
                        this.killed_sessions = new ArrayList<Long>(Math.max(0, _list396.size));
                        int _i397 = 0;
                        while (_list396.size < 0 ? iprot.peekList() : _i397 < _list396.size) {
                            long _elem398 = iprot.readI64();
                            this.killed_sessions.add(_elem398);
                            ++_i397;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader != null) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.killed_queries != null) {
            oprot.writeFieldBegin(KILLED_QUERIES_FIELD_DESC);
            oprot.writeMapBegin(new TMap(10, 13, this.killed_queries.size()));
            for (Map.Entry entry : this.killed_queries.entrySet()) {
                oprot.writeI64((Long)entry.getKey());
                oprot.writeMapBegin(new TMap(10, 12, ((Map)entry.getValue()).size()));
                for (Map.Entry _iter400 : ((Map)entry.getValue()).entrySet()) {
                    oprot.writeI64((Long)_iter400.getKey());
                    ((QueryDesc)_iter400.getValue()).write(oprot);
                }
                oprot.writeMapEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.killed_sessions != null) {
            oprot.writeFieldBegin(KILLED_SESSIONS_FIELD_DESC);
            oprot.writeListBegin(new TList(10, this.killed_sessions.size()));
            Iterator<Object> iterator = this.killed_sessions.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                oprot.writeI64(l);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("UpdateSessionsResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("killed_queries");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getKilled_queries() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getKilled_queries(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("killed_sessions");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getKilled_sessions() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getKilled_sessions(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("leader", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("killed_queries", 3, new MapMetaData(13, new FieldValueMetaData(10), new MapMetaData(13, new FieldValueMetaData(10), new StructMetaData(12, QueryDesc.class)))));
        tmpMetaDataMap.put(4, new FieldMetaData("killed_sessions", 3, new ListMetaData(15, new FieldValueMetaData(10))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(UpdateSessionsResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private HostAddr leader;
        private Map<Long, Map<Long, QueryDesc>> killed_queries;
        private List<Long> killed_sessions;

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public Builder setKilled_queries(Map<Long, Map<Long, QueryDesc>> killed_queries) {
            this.killed_queries = killed_queries;
            return this;
        }

        public Builder setKilled_sessions(List<Long> killed_sessions) {
            this.killed_sessions = killed_sessions;
            return this;
        }

        public UpdateSessionsResp build() {
            UpdateSessionsResp result = new UpdateSessionsResp();
            result.setCode(this.code);
            result.setLeader(this.leader);
            result.setKilled_queries(this.killed_queries);
            result.setKilled_sessions(this.killed_sessions);
            return result;
        }
    }
}

