/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.IndexSpec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LookupIndexRequest
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("LookupIndexRequest");
    private static final TField SPACE_ID_FIELD_DESC = new TField("space_id", 8, 1);
    private static final TField PARTS_FIELD_DESC = new TField("parts", 15, 2);
    private static final TField INDICES_FIELD_DESC = new TField("indices", 12, 3);
    private static final TField RETURN_COLUMNS_FIELD_DESC = new TField("return_columns", 15, 4);
    public int space_id;
    public List<Integer> parts;
    public IndexSpec indices;
    public List<byte[]> return_columns;
    public static final int SPACE_ID = 1;
    public static final int PARTS = 2;
    public static final int INDICES = 3;
    public static final int RETURN_COLUMNS = 4;
    private static final int __SPACE_ID_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public LookupIndexRequest() {
    }

    public LookupIndexRequest(int space_id, List<Integer> parts) {
        this();
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        this.parts = parts;
    }

    public LookupIndexRequest(int space_id, List<Integer> parts, IndexSpec indices) {
        this();
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        this.parts = parts;
        this.indices = indices;
    }

    public LookupIndexRequest(int space_id, List<Integer> parts, IndexSpec indices, List<byte[]> return_columns) {
        this();
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        this.parts = parts;
        this.indices = indices;
        this.return_columns = return_columns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LookupIndexRequest(LookupIndexRequest other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.space_id = TBaseHelper.deepCopy(other.space_id);
        if (other.isSetParts()) {
            this.parts = TBaseHelper.deepCopy(other.parts);
        }
        if (other.isSetIndices()) {
            this.indices = TBaseHelper.deepCopy(other.indices);
        }
        if (other.isSetReturn_columns()) {
            this.return_columns = TBaseHelper.deepCopy(other.return_columns);
        }
    }

    @Override
    public LookupIndexRequest deepCopy() {
        return new LookupIndexRequest(this);
    }

    public int getSpace_id() {
        return this.space_id;
    }

    public LookupIndexRequest setSpace_id(int space_id) {
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        return this;
    }

    public void unsetSpace_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetSpace_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setSpace_idIsSet(boolean __value) {
        this.__isset_bit_vector.set(0, __value);
    }

    public List<Integer> getParts() {
        return this.parts;
    }

    public LookupIndexRequest setParts(List<Integer> parts) {
        this.parts = parts;
        return this;
    }

    public void unsetParts() {
        this.parts = null;
    }

    public boolean isSetParts() {
        return this.parts != null;
    }

    public void setPartsIsSet(boolean __value) {
        if (!__value) {
            this.parts = null;
        }
    }

    public IndexSpec getIndices() {
        return this.indices;
    }

    public LookupIndexRequest setIndices(IndexSpec indices) {
        this.indices = indices;
        return this;
    }

    public void unsetIndices() {
        this.indices = null;
    }

    public boolean isSetIndices() {
        return this.indices != null;
    }

    public void setIndicesIsSet(boolean __value) {
        if (!__value) {
            this.indices = null;
        }
    }

    public List<byte[]> getReturn_columns() {
        return this.return_columns;
    }

    public LookupIndexRequest setReturn_columns(List<byte[]> return_columns) {
        this.return_columns = return_columns;
        return this;
    }

    public void unsetReturn_columns() {
        this.return_columns = null;
    }

    public boolean isSetReturn_columns() {
        return this.return_columns != null;
    }

    public void setReturn_columnsIsSet(boolean __value) {
        if (!__value) {
            this.return_columns = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetSpace_id();
                    break;
                }
                this.setSpace_id((Integer)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetParts();
                    break;
                }
                this.setParts((List)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetIndices();
                    break;
                }
                this.setIndices((IndexSpec)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetReturn_columns();
                    break;
                }
                this.setReturn_columns((List)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Integer(this.getSpace_id());
            }
            case 2: {
                return this.getParts();
            }
            case 3: {
                return this.getIndices();
            }
            case 4: {
                return this.getReturn_columns();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof LookupIndexRequest)) {
            return false;
        }
        LookupIndexRequest that = (LookupIndexRequest)_that;
        if (!TBaseHelper.equalsNobinary(this.space_id, that.space_id)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetParts(), that.isSetParts(), this.parts, that.parts)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetIndices(), that.isSetIndices(), this.indices, that.indices)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetReturn_columns(), that.isSetReturn_columns(), this.return_columns, that.return_columns);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.space_id, this.parts, this.indices, this.return_columns});
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.space_id = iprot.readI32();
                        this.setSpace_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 15) {
                        TList _list159 = iprot.readListBegin();
                        this.parts = new ArrayList<Integer>(Math.max(0, _list159.size));
                        int _i160 = 0;
                        while (_list159.size < 0 ? iprot.peekList() : _i160 < _list159.size) {
                            int _elem161 = iprot.readI32();
                            this.parts.add(_elem161);
                            ++_i160;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 12) {
                        this.indices = new IndexSpec();
                        this.indices.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 15) {
                        TList _list162 = iprot.readListBegin();
                        this.return_columns = new ArrayList<byte[]>(Math.max(0, _list162.size));
                        int _i163 = 0;
                        while (_list162.size < 0 ? iprot.peekList() : _i163 < _list162.size) {
                            byte[] _elem164 = iprot.readBinary();
                            this.return_columns.add(_elem164);
                            ++_i163;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        if (!this.isSetSpace_id()) {
            throw new TProtocolException("Required field 'space_id' was not found in serialized data! Struct: " + this.toString());
        }
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SPACE_ID_FIELD_DESC);
        oprot.writeI32(this.space_id);
        oprot.writeFieldEnd();
        if (this.parts != null) {
            oprot.writeFieldBegin(PARTS_FIELD_DESC);
            oprot.writeListBegin(new TList(8, this.parts.size()));
            for (int _iter165 : this.parts) {
                oprot.writeI32(_iter165);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.indices != null) {
            oprot.writeFieldBegin(INDICES_FIELD_DESC);
            this.indices.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.return_columns != null && this.isSetReturn_columns()) {
            oprot.writeFieldBegin(RETURN_COLUMNS_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.return_columns.size()));
            for (byte[] _iter166 : this.return_columns) {
                oprot.writeBinary(_iter166);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("LookupIndexRequest");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("space_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getSpace_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("parts");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getParts() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getParts(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("indices");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getIndices() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getIndices(), indent + 1, prettyPrint));
        }
        first = false;
        if (this.isSetReturn_columns()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("return_columns");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getReturn_columns() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getReturn_columns(), indent + 1, prettyPrint));
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.parts == null) {
            throw new TProtocolException(6, "Required field 'parts' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("space_id", 1, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("parts", 1, new ListMetaData(15, new FieldValueMetaData(8))));
        tmpMetaDataMap.put(3, new FieldMetaData("indices", 3, new StructMetaData(12, IndexSpec.class)));
        tmpMetaDataMap.put(4, new FieldMetaData("return_columns", 2, new ListMetaData(15, new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(LookupIndexRequest.class, metaDataMap);
    }

    public static class Builder {
        private int space_id;
        private List<Integer> parts;
        private IndexSpec indices;
        private List<byte[]> return_columns;
        BitSet __optional_isset = new BitSet(1);

        public Builder setSpace_id(int space_id) {
            this.space_id = space_id;
            this.__optional_isset.set(0, true);
            return this;
        }

        public Builder setParts(List<Integer> parts) {
            this.parts = parts;
            return this;
        }

        public Builder setIndices(IndexSpec indices) {
            this.indices = indices;
            return this;
        }

        public Builder setReturn_columns(List<byte[]> return_columns) {
            this.return_columns = return_columns;
            return this;
        }

        public LookupIndexRequest build() {
            LookupIndexRequest result = new LookupIndexRequest();
            if (this.__optional_isset.get(0)) {
                result.setSpace_id(this.space_id);
            }
            result.setParts(this.parts);
            result.setIndices(this.indices);
            result.setReturn_columns(this.return_columns);
            return result;
        }
    }
}

