/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.IndexColumnHint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexQueryContext
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("IndexQueryContext");
    private static final TField INDEX_ID_FIELD_DESC = new TField("index_id", 8, 1);
    private static final TField FILTER_FIELD_DESC = new TField("filter", 11, 2);
    private static final TField COLUMN_HINTS_FIELD_DESC = new TField("column_hints", 15, 3);
    public int index_id;
    public byte[] filter;
    public List<IndexColumnHint> column_hints;
    public static final int INDEX_ID = 1;
    public static final int FILTER = 2;
    public static final int COLUMN_HINTS = 3;
    private static final int __INDEX_ID_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public IndexQueryContext() {
    }

    public IndexQueryContext(int index_id, byte[] filter, List<IndexColumnHint> column_hints) {
        this();
        this.index_id = index_id;
        this.setIndex_idIsSet(true);
        this.filter = filter;
        this.column_hints = column_hints;
    }

    public static Builder builder() {
        return new Builder();
    }

    public IndexQueryContext(IndexQueryContext other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.index_id = TBaseHelper.deepCopy(other.index_id);
        if (other.isSetFilter()) {
            this.filter = TBaseHelper.deepCopy(other.filter);
        }
        if (other.isSetColumn_hints()) {
            this.column_hints = TBaseHelper.deepCopy(other.column_hints);
        }
    }

    @Override
    public IndexQueryContext deepCopy() {
        return new IndexQueryContext(this);
    }

    public int getIndex_id() {
        return this.index_id;
    }

    public IndexQueryContext setIndex_id(int index_id) {
        this.index_id = index_id;
        this.setIndex_idIsSet(true);
        return this;
    }

    public void unsetIndex_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetIndex_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setIndex_idIsSet(boolean __value) {
        this.__isset_bit_vector.set(0, __value);
    }

    public byte[] getFilter() {
        return this.filter;
    }

    public IndexQueryContext setFilter(byte[] filter) {
        this.filter = filter;
        return this;
    }

    public void unsetFilter() {
        this.filter = null;
    }

    public boolean isSetFilter() {
        return this.filter != null;
    }

    public void setFilterIsSet(boolean __value) {
        if (!__value) {
            this.filter = null;
        }
    }

    public List<IndexColumnHint> getColumn_hints() {
        return this.column_hints;
    }

    public IndexQueryContext setColumn_hints(List<IndexColumnHint> column_hints) {
        this.column_hints = column_hints;
        return this;
    }

    public void unsetColumn_hints() {
        this.column_hints = null;
    }

    public boolean isSetColumn_hints() {
        return this.column_hints != null;
    }

    public void setColumn_hintsIsSet(boolean __value) {
        if (!__value) {
            this.column_hints = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetIndex_id();
                    break;
                }
                this.setIndex_id((Integer)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetFilter();
                    break;
                }
                this.setFilter((byte[])__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetColumn_hints();
                    break;
                }
                this.setColumn_hints((List)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Integer(this.getIndex_id());
            }
            case 2: {
                return this.getFilter();
            }
            case 3: {
                return this.getColumn_hints();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof IndexQueryContext)) {
            return false;
        }
        IndexQueryContext that = (IndexQueryContext)_that;
        if (!TBaseHelper.equalsNobinary(this.index_id, that.index_id)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetFilter(), that.isSetFilter(), this.filter, that.filter)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetColumn_hints(), that.isSetColumn_hints(), this.column_hints, that.column_hints);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.index_id, this.filter, this.column_hints});
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.index_id = iprot.readI32();
                        this.setIndex_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 11) {
                        this.filter = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 15) {
                        TList _list151 = iprot.readListBegin();
                        this.column_hints = new ArrayList<IndexColumnHint>(Math.max(0, _list151.size));
                        int _i152 = 0;
                        while (_list151.size < 0 ? iprot.peekList() : _i152 < _list151.size) {
                            IndexColumnHint _elem153 = new IndexColumnHint();
                            _elem153.read(iprot);
                            this.column_hints.add(_elem153);
                            ++_i152;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(INDEX_ID_FIELD_DESC);
        oprot.writeI32(this.index_id);
        oprot.writeFieldEnd();
        if (this.filter != null) {
            oprot.writeFieldBegin(FILTER_FIELD_DESC);
            oprot.writeBinary(this.filter);
            oprot.writeFieldEnd();
        }
        if (this.column_hints != null) {
            oprot.writeFieldBegin(COLUMN_HINTS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.column_hints.size()));
            for (IndexColumnHint _iter154 : this.column_hints) {
                _iter154.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("IndexQueryContext");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("index_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getIndex_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("filter");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getFilter() == null) {
            sb.append("null");
        } else {
            int __filter_size = Math.min(this.getFilter().length, 128);
            for (int i = 0; i < __filter_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getFilter()[i]).length() > 1 ? Integer.toHexString(this.getFilter()[i]).substring(Integer.toHexString(this.getFilter()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getFilter()[i]).toUpperCase());
            }
            if (this.getFilter().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("column_hints");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getColumn_hints() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getColumn_hints(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("index_id", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("filter", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(3, new FieldMetaData("column_hints", 3, new ListMetaData(15, new StructMetaData(12, IndexColumnHint.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(IndexQueryContext.class, metaDataMap);
    }

    public static class Builder {
        private int index_id;
        private byte[] filter;
        private List<IndexColumnHint> column_hints;
        BitSet __optional_isset = new BitSet(1);

        public Builder setIndex_id(int index_id) {
            this.index_id = index_id;
            this.__optional_isset.set(0, true);
            return this;
        }

        public Builder setFilter(byte[] filter) {
            this.filter = filter;
            return this;
        }

        public Builder setColumn_hints(List<IndexColumnHint> column_hints) {
            this.column_hints = column_hints;
            return this;
        }

        public IndexQueryContext build() {
            IndexQueryContext result = new IndexQueryContext();
            if (this.__optional_isset.get(0)) {
                result.setIndex_id(this.index_id);
            }
            result.setFilter(this.filter);
            result.setColumn_hints(this.column_hints);
            return result;
        }
    }
}

