/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.NebulaPool;
import com.vesoft.nebula.client.graph.net.SyncConnection;
import com.vesoft.nebula.graph.ExecutionResponse;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private final long sessionID;
    private SyncConnection connection;
    private final NebulaPool pool;
    private final Boolean retryConnect;
    private final AtomicBoolean connectionIsBroken = new AtomicBoolean(false);
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Session(SyncConnection connection, long sessionID, NebulaPool connPool, Boolean retryConnect) {
        this.connection = connection;
        this.sessionID = sessionID;
        this.pool = connPool;
        this.retryConnect = retryConnect;
    }

    public synchronized ResultSet execute(String stmt) throws IOErrorException {
        if (this.connection == null) {
            throw new IOErrorException(2, "The session was released, couldn't use again.");
        }
        if (this.connectionIsBroken.get() && this.retryConnect.booleanValue()) {
            if (this.retryConnect()) {
                ExecutionResponse resp = this.connection.execute(this.sessionID, stmt);
                return new ResultSet(resp);
            }
            throw new IOErrorException(1, "All servers are broken.");
        }
        try {
            if (this.connection == null) {
                throw new IOErrorException(2, "Connection is null");
            }
            ExecutionResponse resp = this.connection.execute(this.sessionID, stmt);
            return new ResultSet(resp);
        }
        catch (IOErrorException ie) {
            if (ie.getType() == 2) {
                this.connectionIsBroken.set(true);
                this.pool.updateServerStatus();
                if (this.retryConnect.booleanValue()) {
                    if (this.retryConnect()) {
                        this.connectionIsBroken.set(false);
                        ExecutionResponse resp = this.connection.execute(this.sessionID, stmt);
                        return new ResultSet(resp);
                    }
                    this.connectionIsBroken.set(true);
                    throw new IOErrorException(1, "All servers are broken.");
                }
            }
            throw ie;
        }
    }

    private boolean retryConnect() {
        try {
            this.pool.setInvalidateConnection(this.connection);
            SyncConnection newConn = this.pool.getConnection();
            if (newConn == null) {
                this.log.error("Get connection object failed.");
                return false;
            }
            this.connection = newConn;
            return true;
        }
        catch (Exception e) {
            this.log.error("Reconnected failed: " + e);
            return false;
        }
    }

    public synchronized boolean ping() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.ping();
    }

    public synchronized void release() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.signout(this.sessionID);
            this.pool.returnConnection(this.connection);
        }
        catch (Exception e) {
            this.log.warn("Signout out failed or return object to pool failed:" + e.getMessage());
        }
        this.connection = null;
    }

    public synchronized HostAddress getGraphHost() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getServerAddress();
    }
}

