/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class MultiGetReq
implements TBase,
Serializable,
Cloneable,
Comparable<MultiGetReq> {
    private static final TStruct STRUCT_DESC = new TStruct("MultiGetReq");
    private static final TField SEGMENT_FIELD_DESC = new TField("segment", 11, 1);
    private static final TField KEYS_FIELD_DESC = new TField("keys", 15, 2);
    public byte[] segment;
    public List<byte[]> keys;
    public static final int SEGMENT = 1;
    public static final int KEYS = 2;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public MultiGetReq() {
    }

    public MultiGetReq(byte[] segment, List<byte[]> keys) {
        this();
        this.segment = segment;
        this.keys = keys;
    }

    public MultiGetReq(MultiGetReq other) {
        if (other.isSetSegment()) {
            this.segment = TBaseHelper.deepCopy(other.segment);
        }
        if (other.isSetKeys()) {
            this.keys = TBaseHelper.deepCopy(other.keys);
        }
    }

    @Override
    public MultiGetReq deepCopy() {
        return new MultiGetReq(this);
    }

    @Deprecated
    public MultiGetReq clone() {
        return new MultiGetReq(this);
    }

    public byte[] getSegment() {
        return this.segment;
    }

    public MultiGetReq setSegment(byte[] segment) {
        this.segment = segment;
        return this;
    }

    public void unsetSegment() {
        this.segment = null;
    }

    public boolean isSetSegment() {
        return this.segment != null;
    }

    public void setSegmentIsSet(boolean value) {
        if (!value) {
            this.segment = null;
        }
    }

    public List<byte[]> getKeys() {
        return this.keys;
    }

    public MultiGetReq setKeys(List<byte[]> keys) {
        this.keys = keys;
        return this;
    }

    public void unsetKeys() {
        this.keys = null;
    }

    public boolean isSetKeys() {
        return this.keys != null;
    }

    public void setKeysIsSet(boolean value) {
        if (!value) {
            this.keys = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetSegment();
                    break;
                }
                this.setSegment((byte[])value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetKeys();
                    break;
                }
                this.setKeys((List)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getSegment();
            }
            case 2: {
                return this.getKeys();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetSegment();
            }
            case 2: {
                return this.isSetKeys();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof MultiGetReq) {
            return this.equals((MultiGetReq)that);
        }
        return false;
    }

    public boolean equals(MultiGetReq that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_segment = this.isSetSegment();
        boolean that_present_segment = that.isSetSegment();
        if (this_present_segment || that_present_segment) {
            if (!this_present_segment || !that_present_segment) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.segment, that.segment)) {
                return false;
            }
        }
        boolean this_present_keys = this.isSetKeys();
        boolean that_present_keys = that.isSetKeys();
        if (this_present_keys || that_present_keys) {
            if (!this_present_keys || !that_present_keys) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.keys, that.keys)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_segment = this.isSetSegment();
        builder.append(present_segment);
        if (present_segment) {
            builder.append(this.segment);
        }
        boolean present_keys = this.isSetKeys();
        builder.append(present_keys);
        if (present_keys) {
            builder.append(this.keys);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(MultiGetReq other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetSegment()).compareTo(other.isSetSegment());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.segment, other.segment);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKeys()).compareTo(other.isSetKeys());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.keys, other.keys);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.segment = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list114 = iprot.readListBegin();
                        this.keys = new ArrayList<byte[]>(Math.max(0, _list114.size));
                        int _i115 = 0;
                        while (_list114.size < 0 ? iprot.peekList() : _i115 < _list114.size) {
                            byte[] _elem116 = iprot.readBinary();
                            this.keys.add(_elem116);
                            ++_i115;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.segment != null) {
            oprot.writeFieldBegin(SEGMENT_FIELD_DESC);
            oprot.writeBinary(this.segment);
            oprot.writeFieldEnd();
        }
        if (this.keys != null) {
            oprot.writeFieldBegin(KEYS_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.keys.size()));
            for (byte[] _iter117 : this.keys) {
                oprot.writeBinary(_iter117);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("MultiGetReq");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("segment");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getSegment() == null) {
            sb.append("null");
        } else {
            int __segment_size = Math.min(this.getSegment().length, 128);
            for (int i = 0; i < __segment_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getSegment()[i]).length() > 1 ? Integer.toHexString(this.getSegment()[i]).substring(Integer.toHexString(this.getSegment()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getSegment()[i]).toUpperCase());
            }
            if (this.getSegment().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("keys");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getKeys() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getKeys(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("segment", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("keys", 3, new ListMetaData(15, new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(MultiGetReq.class, metaDataMap);
    }
}

