/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.encoder;

import com.vesoft.nebula.encoder.NebulaCodec;
import com.vesoft.nebula.encoder.RowWriterImpl;
import com.vesoft.nebula.encoder.SchemaProviderImpl;
import com.vesoft.nebula.meta.ColumnDef;
import com.vesoft.nebula.meta.ColumnTypeDef;
import com.vesoft.nebula.meta.EdgeItem;
import com.vesoft.nebula.meta.Schema;
import com.vesoft.nebula.meta.TagItem;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public class NebulaCodecImpl
implements NebulaCodec {
    private static final int PARTITION_ID_SIZE = 4;
    private static final int TAG_ID_SIZE = 4;
    private static final int EDGE_TYPE_SIZE = 4;
    private static final int EDGE_RANKING_SIZE = 8;
    private static final int EDGE_VER_PLACE_HOLDER_SIZE = 1;
    private static final int VERTEX_SIZE = 8;
    private static final int EDGE_SIZE = 17;
    private static final int VERTEX_KEY_TYPE = 1;
    private static final int EDGE_KEY_TYPE = 2;
    private static final int SEEK = -955291385;
    private final ByteOrder byteOrder = ByteOrder.nativeOrder();

    @Override
    public byte[] vertexKey(int vidLen, int partitionId, byte[] vertexId, int tagId) {
        if (vertexId.length > vidLen) {
            throw new RuntimeException("The length of vid size is out of the range, expected vidLen less then " + vidLen);
        }
        ByteBuffer buffer = ByteBuffer.allocate(8 + vidLen);
        buffer.order(this.byteOrder);
        partitionId = partitionId << 8 | 1;
        buffer.putInt(partitionId).put(vertexId);
        if (vertexId.length < vidLen) {
            ByteBuffer complementVid = ByteBuffer.allocate(vidLen - vertexId.length);
            Arrays.fill(complementVid.array(), (byte)0);
            buffer.put(complementVid);
        }
        buffer.putInt(tagId);
        return buffer.array();
    }

    @Override
    public byte[] edgeKeyByDefaultVer(int vidLen, int partitionId, byte[] srcId, int edgeType, long edgeRank, byte[] dstId) {
        return this.edgeKey(vidLen, partitionId, srcId, edgeType, edgeRank, dstId, (byte)1);
    }

    @Override
    public byte[] edgeKey(int vidLen, int partitionId, byte[] srcId, int edgeType, long edgeRank, byte[] dstId, byte edgeVerHolder) {
        ByteBuffer complementVid;
        if (srcId.length > vidLen || dstId.length > vidLen) {
            throw new RuntimeException("The length of vid size is out of the range, expected vidLen less then " + vidLen);
        }
        ByteBuffer buffer = ByteBuffer.allocate(17 + (vidLen << 1));
        buffer.order(this.byteOrder);
        partitionId = partitionId << 8 | 2;
        buffer.putInt(partitionId);
        buffer.put(srcId);
        if (srcId.length < vidLen) {
            complementVid = ByteBuffer.allocate(vidLen - srcId.length);
            Arrays.fill(complementVid.array(), (byte)0);
            buffer.put(complementVid);
        }
        buffer.putInt(edgeType);
        buffer.put(this.encodeRank(edgeRank));
        buffer.put(dstId);
        if (dstId.length < vidLen) {
            complementVid = ByteBuffer.allocate(vidLen - dstId.length);
            Arrays.fill(complementVid.array(), (byte)0);
            buffer.put(complementVid);
        }
        buffer.put(edgeVerHolder);
        return buffer.array();
    }

    @Override
    public byte[] encodeTag(TagItem tag, List<String> names, List<Object> values) throws RuntimeException {
        if (tag == null) {
            throw new RuntimeException("TagItem is null");
        }
        Schema schema = tag.getSchema();
        return this.encode(schema, tag.getVersion(), names, values);
    }

    @Override
    public byte[] encodeEdge(EdgeItem edge, List<String> names, List<Object> values) throws RuntimeException {
        if (edge == null) {
            throw new RuntimeException("EdgeItem is null");
        }
        Schema schema = edge.getSchema();
        return this.encode(schema, edge.getVersion(), names, values);
    }

    private byte[] encode(Schema schema, long ver, List<String> names, List<Object> values) throws RuntimeException {
        if (names.size() != values.size()) {
            throw new RuntimeException(String.format("The names' size no equal with values' size, [%d] != [%d]", names.size(), values.size()));
        }
        RowWriterImpl writer = new RowWriterImpl(this.genSchemaProvider(ver, schema), this.byteOrder);
        for (int i = 0; i < names.size(); ++i) {
            writer.setValue(names.get(i), values.get(i));
        }
        writer.finish();
        return writer.encodeStr();
    }

    private SchemaProviderImpl genSchemaProvider(long ver, Schema schema) {
        SchemaProviderImpl schemaProvider = new SchemaProviderImpl(ver);
        for (ColumnDef col : schema.getColumns()) {
            ColumnTypeDef type = col.getType();
            boolean nullable = col.isSetNullable();
            boolean hasDefault = col.isSetDefault_value();
            short len = type.isSetType_length() ? type.getType_length() : (short)0;
            schemaProvider.addField(new String(col.getName()), type.type, len, nullable, hasDefault ? col.getDefault_value() : null);
        }
        return schemaProvider;
    }

    private byte[] encodeRank(long rank) {
        long newRank = rank ^ Long.MIN_VALUE;
        ByteBuffer rankBuf = ByteBuffer.allocate(8);
        rankBuf.order(ByteOrder.BIG_ENDIAN);
        rankBuf.putLong(newRank);
        return rankBuf.array();
    }
}

