/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage.scan;

import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.meta.MetaManager;
import com.vesoft.nebula.client.meta.exception.ExecuteFailedException;
import com.vesoft.nebula.client.storage.StorageConnPool;
import com.vesoft.nebula.client.storage.scan.PartScanInfo;
import com.vesoft.nebula.client.storage.scan.PartScanQueue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanResultIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanResultIterator.class);
    protected boolean hasNext = true;
    protected final Map<Integer, byte[]> partCursor;
    protected final ExecutorService threadPool;
    protected final MetaManager metaManager;
    protected final StorageConnPool pool;
    protected final PartScanQueue partScanQueue;
    protected final List<HostAddress> addresses;
    protected final String spaceName;
    protected final String labelName;
    protected final boolean partSuccess;

    protected ScanResultIterator(MetaManager metaManager, StorageConnPool pool, PartScanQueue partScanQueue, List<HostAddress> addresses, String spaceName, String labelName, boolean partSuccess) {
        this.metaManager = metaManager;
        this.pool = pool;
        this.partScanQueue = partScanQueue;
        this.addresses = addresses;
        this.spaceName = spaceName;
        this.labelName = labelName;
        this.partSuccess = partSuccess;
        this.threadPool = Executors.newFixedThreadPool(addresses.size());
        this.partCursor = new HashMap<Integer, byte[]>(partScanQueue.size());
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    protected void freshLeader(String spaceName, int part, HostAddr leader) {
        this.metaManager.updateLeader(spaceName, part, leader);
    }

    protected HostAddress getLeader(HostAddr leader) {
        return new HostAddress(leader.getHost(), leader.getPort());
    }

    protected void handleNullResponse(PartScanInfo partInfo, List<Exception> exceptions) {
        LOGGER.error("part scan failed, response is null");
        this.partScanQueue.dropPart(partInfo);
        exceptions.add(new Exception("null scan response"));
    }

    protected void handleNullResult(PartScanInfo partInfo, List<Exception> exceptions) {
        LOGGER.error("part scan failed, response result is null");
        this.partScanQueue.dropPart(partInfo);
        exceptions.add(new Exception("null scan response result"));
    }

    protected void throwExceptions(List<Exception> exceptions) throws ExecuteFailedException {
        StringBuilder errorMsg = new StringBuilder();
        for (int i = 0; i < exceptions.size(); ++i) {
            if (i != 0) {
                errorMsg.append(",");
            }
            errorMsg.append(exceptions.get(i).getMessage());
        }
        throw new ExecuteFailedException("no parts succeed, error message: " + errorMsg.toString());
    }
}

