/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.encoder;

import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.client.meta.MetaCache;
import com.vesoft.nebula.encoder.NebulaCodec;
import com.vesoft.nebula.encoder.RowWriterImpl;
import com.vesoft.nebula.encoder.SchemaProviderImpl;
import com.vesoft.nebula.meta.ColumnDef;
import com.vesoft.nebula.meta.ColumnTypeDef;
import com.vesoft.nebula.meta.EdgeItem;
import com.vesoft.nebula.meta.Schema;
import com.vesoft.nebula.meta.SpaceItem;
import com.vesoft.nebula.meta.TagItem;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.MurmurHash2;

public class NebulaCodecImpl
implements NebulaCodec {
    private static final int PARTITION_ID_SIZE = 4;
    private static final int TAG_ID_SIZE = 4;
    private static final int TAG_VERSION_SIZE = 8;
    private static final int EDGE_TYPE_SIZE = 4;
    private static final int EDGE_RANKING_SIZE = 8;
    private static final int EDGE_VERSION_SIZE = 8;
    private static final int VERTEX_SIZE = 16;
    private static final int EDGE_SIZE = 24;
    private static final int DATA_KEY_TYPE = 1;
    private static final int TAG_MASK = -1073741825;
    private static final int EDGE_MASK = 0x40000000;
    private static final int SEEK = -955291385;
    private final MetaCache metaCache;
    private final ByteOrder byteOrder = ByteOrder.nativeOrder();

    public NebulaCodecImpl(MetaCache metaCache) {
        this.metaCache = metaCache;
    }

    private int getSpaceVidLen(String spaceName) throws RuntimeException {
        SpaceItem spaceItem = this.metaCache.getSpace(spaceName);
        if (spaceItem == null) {
            throw new RuntimeException("SpaceName: " + spaceName + "is not existed");
        }
        if (spaceItem.properties.vid_type.type != 7) {
            throw new RuntimeException("Only supported fixed string vid type.");
        }
        return spaceItem.properties.vid_type.type_length;
    }

    private int getPartSize(String spaceName) throws RuntimeException {
        Map<Integer, List<HostAddr>> partsAlloc = this.metaCache.getPartsAlloc(spaceName);
        if (partsAlloc == null) {
            throw new RuntimeException("SpaceName: " + spaceName + " is not existed");
        }
        return partsAlloc.size();
    }

    @Override
    public byte[] vertexKey(String spaceName, String vertexId, String tagName) throws RuntimeException {
        int vidLen = this.getSpaceVidLen(spaceName);
        long hash = MurmurHash2.hash64((byte[])vertexId.getBytes(), (int)vertexId.length(), (int)-955291385);
        int partitionId = (int)(hash % (long)this.getPartSize(spaceName) + 1L);
        TagItem tagItem = this.metaCache.getTag(spaceName, tagName);
        return this.genVertexKey(vidLen, partitionId, vertexId.getBytes(), tagItem.tag_id, tagItem.version);
    }

    @Override
    public byte[] edgeKey(String spaceName, String srcId, String edgeName, long edgeRank, String dstId) throws RuntimeException {
        int vidLen = this.getSpaceVidLen(spaceName);
        long hash = MurmurHash2.hash64((byte[])srcId.getBytes(), (int)srcId.length(), (int)-955291385);
        int partitionId = (int)(hash % (long)this.getPartSize(spaceName) + 1L);
        EdgeItem edgeItem = this.metaCache.getEdge(spaceName, edgeName);
        return this.genEdgeKey(vidLen, partitionId, srcId.getBytes(), edgeItem.edge_type, edgeRank, dstId.getBytes(), edgeItem.version);
    }

    public byte[] genVertexKey(int vidLen, int partitionId, byte[] vertexId, int tagId, long tagVersion) {
        if (vertexId.length > vidLen) {
            throw new RuntimeException("The length of vid size is out of the range, expected vidLen less then " + vidLen);
        }
        ByteBuffer buffer = ByteBuffer.allocate(16 + vidLen);
        buffer.order(this.byteOrder);
        partitionId = partitionId << 8 | 1;
        tagId &= 0xBFFFFFFF;
        buffer.putInt(partitionId).put(vertexId);
        if (vertexId.length < vidLen) {
            ByteBuffer complementVid = ByteBuffer.allocate(vidLen - vertexId.length);
            Arrays.fill(complementVid.array(), (byte)0);
            buffer.put(complementVid);
        }
        buffer.putInt(tagId);
        buffer.putLong(tagVersion);
        return buffer.array();
    }

    public byte[] genEdgeKey(int vidLen, int partitionId, byte[] srcId, int edgeType, long edgeRank, byte[] dstId, long edgeVersion) {
        ByteBuffer complementVid;
        if (srcId.length > vidLen || dstId.length > vidLen) {
            throw new RuntimeException("The length of vid size is out of the range, expected vidLen less then " + vidLen);
        }
        ByteBuffer buffer = ByteBuffer.allocate(24 + (vidLen << 1));
        buffer.order(this.byteOrder);
        partitionId = partitionId << 8 | 1;
        buffer.putInt(partitionId);
        buffer.put(srcId);
        if (srcId.length < vidLen) {
            complementVid = ByteBuffer.allocate(vidLen - srcId.length);
            Arrays.fill(complementVid.array(), (byte)0);
            buffer.put(complementVid);
        }
        buffer.putInt(edgeType |= 0x40000000);
        buffer.putLong(edgeRank);
        buffer.put(dstId);
        if (dstId.length < vidLen) {
            complementVid = ByteBuffer.allocate(vidLen - dstId.length);
            Arrays.fill(complementVid.array(), (byte)0);
            buffer.put(complementVid);
        }
        buffer.putLong(edgeVersion);
        return buffer.array();
    }

    public SchemaProviderImpl genSchemaProvider(long ver, Schema schema) {
        SchemaProviderImpl schemaProvider = new SchemaProviderImpl(ver);
        for (ColumnDef col : schema.getColumns()) {
            ColumnTypeDef type = col.getType();
            boolean nullable = col.isSetNullable();
            boolean hasDefault = col.isSetDefault_value();
            short len = type.isSetType_length() ? type.getType_length() : (short)0;
            schemaProvider.addField(new String(col.getName()), type.type, len, nullable, hasDefault ? null : null);
        }
        return schemaProvider;
    }

    @Override
    public byte[] encode(String spaceName, String schemaName, List<String> names, List<Object> values) throws RuntimeException {
        long ver;
        Schema schema;
        if (names == null || values == null || names.size() != values.size()) {
            throw new RuntimeException("NebulaCodeImpl input wrong value");
        }
        try {
            TagItem tag = this.metaCache.getTag(spaceName, schemaName);
            schema = tag.getSchema();
            ver = tag.getVersion();
        }
        catch (IllegalArgumentException e) {
            EdgeItem edge;
            try {
                edge = this.metaCache.getEdge(spaceName, schemaName);
            }
            catch (IllegalArgumentException exception) {
                throw new IllegalArgumentException(String.format("schemaName %s does not exist in space %s.", schemaName, spaceName));
            }
            schema = edge.getSchema();
            ver = edge.getVersion();
        }
        RowWriterImpl writer = new RowWriterImpl(this.genSchemaProvider(ver, schema), this.byteOrder);
        for (int i = 0; i < names.size(); ++i) {
            writer.setValue(names.get(i), values.get(i));
        }
        writer.finish();
        return writer.encodeStr();
    }
}

