/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.client.graph.NebulaPoolConfig;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.exception.AuthFailedException;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.exception.InvalidConfigException;
import com.vesoft.nebula.client.graph.exception.NotValidConnectionException;
import com.vesoft.nebula.client.graph.net.ConnObjectPool;
import com.vesoft.nebula.client.graph.net.LoadBalancer;
import com.vesoft.nebula.client.graph.net.RoundRobinLoadBalancer;
import com.vesoft.nebula.client.graph.net.Session;
import com.vesoft.nebula.client.graph.net.SyncConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NebulaPool {
    private GenericObjectPool<SyncConnection> objectPool = null;
    private LoadBalancer loadBalancer;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int waitTime = 60000;

    private List<HostAddress> hostToIp(List<HostAddress> addresses) throws UnknownHostException {
        ArrayList<HostAddress> newAddrs = new ArrayList<HostAddress>();
        for (HostAddress addr : addresses) {
            String ip = InetAddress.getByName(addr.getHost()).getHostAddress();
            newAddrs.add(new HostAddress(ip, addr.getPort()));
        }
        return newAddrs;
    }

    private void checkConfig(NebulaPoolConfig config) {
        if (config.getIdleTime() < 0) {
            throw new InvalidConfigException("Config idleTime:" + config.getIdleTime() + " is illegal");
        }
        if (config.getMaxConnSize() <= 0) {
            throw new InvalidConfigException("Config maxConnSize:" + config.getMaxConnSize() + " is illegal");
        }
        if (config.getMinConnSize() < 0 || config.getMinConnSize() > config.getMaxConnSize()) {
            throw new InvalidConfigException("Config minConnSize:" + config.getMinConnSize() + " is illegal");
        }
        if (config.getTimeout() < 0) {
            throw new InvalidConfigException("Config timeout:" + config.getTimeout() + " is illegal");
        }
    }

    public boolean init(List<HostAddress> addresses, NebulaPoolConfig config) throws UnknownHostException, InvalidConfigException {
        this.checkConfig(config);
        List<HostAddress> newAddrs = this.hostToIp(addresses);
        this.loadBalancer = new RoundRobinLoadBalancer(newAddrs, config.getTimeout());
        ConnObjectPool objectPool = new ConnObjectPool(this.loadBalancer, config);
        this.objectPool = new GenericObjectPool((PooledObjectFactory)objectPool);
        GenericObjectPoolConfig objConfig = new GenericObjectPoolConfig();
        objConfig.setMinIdle(config.getMinConnSize());
        objConfig.setMaxTotal(config.getMaxConnSize());
        objConfig.setMinEvictableIdleTimeMillis(config.getIdleTime() <= 0 ? Long.MAX_VALUE : (long)config.getIdleTime());
        this.objectPool.setConfig(objConfig);
        AbandonedConfig abandonedConfig = new AbandonedConfig();
        abandonedConfig.setRemoveAbandonedOnBorrow(true);
        this.objectPool.setAbandonedConfig(abandonedConfig);
        return objectPool.init();
    }

    public void close() {
        this.loadBalancer.close();
        this.objectPool.close();
    }

    public Session getSession(String userName, String password, boolean reconnect) throws NotValidConnectionException, IOErrorException, AuthFailedException {
        try {
            int retry = this.getIdleConnNum() == 0 ? 1 : this.getIdleConnNum();
            SyncConnection connection = null;
            while (!(retry-- <= 0 || (connection = (SyncConnection)this.objectPool.borrowObject(60000L)) != null && connection.ping())) {
            }
            if (connection == null) {
                throw new NotValidConnectionException("Get connection object failed.");
            }
            this.log.info(String.format("Get connection to %s:%d", connection.getServerAddress().getHost(), connection.getServerAddress().getPort()));
            long sessionID = connection.authenticate(userName, password);
            return new Session(connection, sessionID, this.objectPool, reconnect);
        }
        catch (AuthFailedException | IOErrorException | NotValidConnectionException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw new NotValidConnectionException(e.getMessage());
        }
        catch (Exception e) {
            throw new IOErrorException(0, e.getMessage());
        }
    }

    public int getActiveConnNum() {
        return this.objectPool.getNumActive();
    }

    public int getIdleConnNum() {
        return this.objectPool.getNumIdle();
    }

    public int getWaitersNum() {
        return this.objectPool.getNumWaiters();
    }

    public void updateServerStatus() {
        if (this.objectPool.getFactory() instanceof ConnObjectPool) {
            ((ConnObjectPool)this.objectPool.getFactory()).updateServerStatus();
        }
    }
}

