/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.EdgeDirection;
import com.vesoft.nebula.storage.EdgeProp;
import com.vesoft.nebula.storage.Expr;
import com.vesoft.nebula.storage.OrderBy;
import com.vesoft.nebula.storage.StatProp;
import com.vesoft.nebula.storage.VertexProp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class TraverseSpec
implements TBase,
Serializable,
Cloneable,
Comparable<TraverseSpec> {
    private static final TStruct STRUCT_DESC = new TStruct("TraverseSpec");
    private static final TField EDGE_TYPES_FIELD_DESC = new TField("edge_types", 15, 1);
    private static final TField EDGE_DIRECTION_FIELD_DESC = new TField("edge_direction", 8, 2);
    private static final TField DEDUP_FIELD_DESC = new TField("dedup", 2, 3);
    private static final TField STAT_PROPS_FIELD_DESC = new TField("stat_props", 15, 4);
    private static final TField VERTEX_PROPS_FIELD_DESC = new TField("vertex_props", 15, 5);
    private static final TField EDGE_PROPS_FIELD_DESC = new TField("edge_props", 15, 6);
    private static final TField EXPRESSIONS_FIELD_DESC = new TField("expressions", 15, 7);
    private static final TField ORDER_BY_FIELD_DESC = new TField("order_by", 15, 8);
    private static final TField RANDOM_FIELD_DESC = new TField("random", 2, 9);
    private static final TField LIMIT_FIELD_DESC = new TField("limit", 10, 10);
    private static final TField FILTER_FIELD_DESC = new TField("filter", 11, 11);
    public List<Integer> edge_types;
    public int edge_direction;
    public boolean dedup;
    public List<StatProp> stat_props;
    public List<VertexProp> vertex_props;
    public List<EdgeProp> edge_props;
    public List<Expr> expressions;
    public List<OrderBy> order_by;
    public boolean random;
    public long limit;
    public byte[] filter;
    public static final int EDGE_TYPES = 1;
    public static final int EDGE_DIRECTION = 2;
    public static final int DEDUP = 3;
    public static final int STAT_PROPS = 4;
    public static final int VERTEX_PROPS = 5;
    public static final int EDGE_PROPS = 6;
    public static final int EXPRESSIONS = 7;
    public static final int ORDER_BY = 8;
    public static final int RANDOM = 9;
    public static final int LIMIT = 10;
    public static final int FILTER = 11;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __EDGE_DIRECTION_ISSET_ID = 0;
    private static final int __DEDUP_ISSET_ID = 1;
    private static final int __RANDOM_ISSET_ID = 2;
    private static final int __LIMIT_ISSET_ID = 3;
    private BitSet __isset_bit_vector = new BitSet(4);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public TraverseSpec() {
        this.edge_direction = 1;
        this.dedup = false;
    }

    public TraverseSpec(List<Integer> edge_types, int edge_direction, boolean dedup) {
        this();
        this.edge_types = edge_types;
        this.edge_direction = edge_direction;
        this.setEdge_directionIsSet(true);
        this.dedup = dedup;
        this.setDedupIsSet(true);
    }

    public TraverseSpec(List<Integer> edge_types, int edge_direction, boolean dedup, List<StatProp> stat_props, List<VertexProp> vertex_props, List<EdgeProp> edge_props, List<Expr> expressions, List<OrderBy> order_by, boolean random, long limit, byte[] filter) {
        this();
        this.edge_types = edge_types;
        this.edge_direction = edge_direction;
        this.setEdge_directionIsSet(true);
        this.dedup = dedup;
        this.setDedupIsSet(true);
        this.stat_props = stat_props;
        this.vertex_props = vertex_props;
        this.edge_props = edge_props;
        this.expressions = expressions;
        this.order_by = order_by;
        this.random = random;
        this.setRandomIsSet(true);
        this.limit = limit;
        this.setLimitIsSet(true);
        this.filter = filter;
    }

    public TraverseSpec(TraverseSpec other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetEdge_types()) {
            this.edge_types = TBaseHelper.deepCopy(other.edge_types);
        }
        this.edge_direction = TBaseHelper.deepCopy(other.edge_direction);
        this.dedup = TBaseHelper.deepCopy(other.dedup);
        if (other.isSetStat_props()) {
            this.stat_props = TBaseHelper.deepCopy(other.stat_props);
        }
        if (other.isSetVertex_props()) {
            this.vertex_props = TBaseHelper.deepCopy(other.vertex_props);
        }
        if (other.isSetEdge_props()) {
            this.edge_props = TBaseHelper.deepCopy(other.edge_props);
        }
        if (other.isSetExpressions()) {
            this.expressions = TBaseHelper.deepCopy(other.expressions);
        }
        if (other.isSetOrder_by()) {
            this.order_by = TBaseHelper.deepCopy(other.order_by);
        }
        this.random = TBaseHelper.deepCopy(other.random);
        this.limit = TBaseHelper.deepCopy(other.limit);
        if (other.isSetFilter()) {
            this.filter = TBaseHelper.deepCopy(other.filter);
        }
    }

    @Override
    public TraverseSpec deepCopy() {
        return new TraverseSpec(this);
    }

    @Deprecated
    public TraverseSpec clone() {
        return new TraverseSpec(this);
    }

    public List<Integer> getEdge_types() {
        return this.edge_types;
    }

    public TraverseSpec setEdge_types(List<Integer> edge_types) {
        this.edge_types = edge_types;
        return this;
    }

    public void unsetEdge_types() {
        this.edge_types = null;
    }

    public boolean isSetEdge_types() {
        return this.edge_types != null;
    }

    public void setEdge_typesIsSet(boolean value) {
        if (!value) {
            this.edge_types = null;
        }
    }

    public int getEdge_direction() {
        return this.edge_direction;
    }

    public TraverseSpec setEdge_direction(int edge_direction) {
        this.edge_direction = edge_direction;
        this.setEdge_directionIsSet(true);
        return this;
    }

    public void unsetEdge_direction() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetEdge_direction() {
        return this.__isset_bit_vector.get(0);
    }

    public void setEdge_directionIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public boolean isDedup() {
        return this.dedup;
    }

    public TraverseSpec setDedup(boolean dedup) {
        this.dedup = dedup;
        this.setDedupIsSet(true);
        return this;
    }

    public void unsetDedup() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetDedup() {
        return this.__isset_bit_vector.get(1);
    }

    public void setDedupIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public List<StatProp> getStat_props() {
        return this.stat_props;
    }

    public TraverseSpec setStat_props(List<StatProp> stat_props) {
        this.stat_props = stat_props;
        return this;
    }

    public void unsetStat_props() {
        this.stat_props = null;
    }

    public boolean isSetStat_props() {
        return this.stat_props != null;
    }

    public void setStat_propsIsSet(boolean value) {
        if (!value) {
            this.stat_props = null;
        }
    }

    public List<VertexProp> getVertex_props() {
        return this.vertex_props;
    }

    public TraverseSpec setVertex_props(List<VertexProp> vertex_props) {
        this.vertex_props = vertex_props;
        return this;
    }

    public void unsetVertex_props() {
        this.vertex_props = null;
    }

    public boolean isSetVertex_props() {
        return this.vertex_props != null;
    }

    public void setVertex_propsIsSet(boolean value) {
        if (!value) {
            this.vertex_props = null;
        }
    }

    public List<EdgeProp> getEdge_props() {
        return this.edge_props;
    }

    public TraverseSpec setEdge_props(List<EdgeProp> edge_props) {
        this.edge_props = edge_props;
        return this;
    }

    public void unsetEdge_props() {
        this.edge_props = null;
    }

    public boolean isSetEdge_props() {
        return this.edge_props != null;
    }

    public void setEdge_propsIsSet(boolean value) {
        if (!value) {
            this.edge_props = null;
        }
    }

    public List<Expr> getExpressions() {
        return this.expressions;
    }

    public TraverseSpec setExpressions(List<Expr> expressions) {
        this.expressions = expressions;
        return this;
    }

    public void unsetExpressions() {
        this.expressions = null;
    }

    public boolean isSetExpressions() {
        return this.expressions != null;
    }

    public void setExpressionsIsSet(boolean value) {
        if (!value) {
            this.expressions = null;
        }
    }

    public List<OrderBy> getOrder_by() {
        return this.order_by;
    }

    public TraverseSpec setOrder_by(List<OrderBy> order_by) {
        this.order_by = order_by;
        return this;
    }

    public void unsetOrder_by() {
        this.order_by = null;
    }

    public boolean isSetOrder_by() {
        return this.order_by != null;
    }

    public void setOrder_byIsSet(boolean value) {
        if (!value) {
            this.order_by = null;
        }
    }

    public boolean isRandom() {
        return this.random;
    }

    public TraverseSpec setRandom(boolean random) {
        this.random = random;
        this.setRandomIsSet(true);
        return this;
    }

    public void unsetRandom() {
        this.__isset_bit_vector.clear(2);
    }

    public boolean isSetRandom() {
        return this.__isset_bit_vector.get(2);
    }

    public void setRandomIsSet(boolean value) {
        this.__isset_bit_vector.set(2, value);
    }

    public long getLimit() {
        return this.limit;
    }

    public TraverseSpec setLimit(long limit) {
        this.limit = limit;
        this.setLimitIsSet(true);
        return this;
    }

    public void unsetLimit() {
        this.__isset_bit_vector.clear(3);
    }

    public boolean isSetLimit() {
        return this.__isset_bit_vector.get(3);
    }

    public void setLimitIsSet(boolean value) {
        this.__isset_bit_vector.set(3, value);
    }

    public byte[] getFilter() {
        return this.filter;
    }

    public TraverseSpec setFilter(byte[] filter) {
        this.filter = filter;
        return this;
    }

    public void unsetFilter() {
        this.filter = null;
    }

    public boolean isSetFilter() {
        return this.filter != null;
    }

    public void setFilterIsSet(boolean value) {
        if (!value) {
            this.filter = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetEdge_types();
                    break;
                }
                this.setEdge_types((List)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetEdge_direction();
                    break;
                }
                this.setEdge_direction((Integer)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetDedup();
                    break;
                }
                this.setDedup((Boolean)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetStat_props();
                    break;
                }
                this.setStat_props((List)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetVertex_props();
                    break;
                }
                this.setVertex_props((List)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetEdge_props();
                    break;
                }
                this.setEdge_props((List)value);
                break;
            }
            case 7: {
                if (value == null) {
                    this.unsetExpressions();
                    break;
                }
                this.setExpressions((List)value);
                break;
            }
            case 8: {
                if (value == null) {
                    this.unsetOrder_by();
                    break;
                }
                this.setOrder_by((List)value);
                break;
            }
            case 9: {
                if (value == null) {
                    this.unsetRandom();
                    break;
                }
                this.setRandom((Boolean)value);
                break;
            }
            case 10: {
                if (value == null) {
                    this.unsetLimit();
                    break;
                }
                this.setLimit((Long)value);
                break;
            }
            case 11: {
                if (value == null) {
                    this.unsetFilter();
                    break;
                }
                this.setFilter((byte[])value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getEdge_types();
            }
            case 2: {
                return this.getEdge_direction();
            }
            case 3: {
                return new Boolean(this.isDedup());
            }
            case 4: {
                return this.getStat_props();
            }
            case 5: {
                return this.getVertex_props();
            }
            case 6: {
                return this.getEdge_props();
            }
            case 7: {
                return this.getExpressions();
            }
            case 8: {
                return this.getOrder_by();
            }
            case 9: {
                return new Boolean(this.isRandom());
            }
            case 10: {
                return new Long(this.getLimit());
            }
            case 11: {
                return this.getFilter();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetEdge_types();
            }
            case 2: {
                return this.isSetEdge_direction();
            }
            case 3: {
                return this.isSetDedup();
            }
            case 4: {
                return this.isSetStat_props();
            }
            case 5: {
                return this.isSetVertex_props();
            }
            case 6: {
                return this.isSetEdge_props();
            }
            case 7: {
                return this.isSetExpressions();
            }
            case 8: {
                return this.isSetOrder_by();
            }
            case 9: {
                return this.isSetRandom();
            }
            case 10: {
                return this.isSetLimit();
            }
            case 11: {
                return this.isSetFilter();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TraverseSpec) {
            return this.equals((TraverseSpec)that);
        }
        return false;
    }

    public boolean equals(TraverseSpec that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_edge_types = this.isSetEdge_types();
        boolean that_present_edge_types = that.isSetEdge_types();
        if (this_present_edge_types || that_present_edge_types) {
            if (!this_present_edge_types || !that_present_edge_types) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.edge_types, that.edge_types)) {
                return false;
            }
        }
        boolean this_present_edge_direction = true;
        boolean that_present_edge_direction = true;
        if (this_present_edge_direction || that_present_edge_direction) {
            if (!this_present_edge_direction || !that_present_edge_direction) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.edge_direction, that.edge_direction)) {
                return false;
            }
        }
        boolean this_present_dedup = true;
        boolean that_present_dedup = true;
        if (this_present_dedup || that_present_dedup) {
            if (!this_present_dedup || !that_present_dedup) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.dedup, that.dedup)) {
                return false;
            }
        }
        boolean this_present_stat_props = this.isSetStat_props();
        boolean that_present_stat_props = that.isSetStat_props();
        if (this_present_stat_props || that_present_stat_props) {
            if (!this_present_stat_props || !that_present_stat_props) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.stat_props, that.stat_props)) {
                return false;
            }
        }
        boolean this_present_vertex_props = this.isSetVertex_props();
        boolean that_present_vertex_props = that.isSetVertex_props();
        if (this_present_vertex_props || that_present_vertex_props) {
            if (!this_present_vertex_props || !that_present_vertex_props) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.vertex_props, that.vertex_props)) {
                return false;
            }
        }
        boolean this_present_edge_props = this.isSetEdge_props();
        boolean that_present_edge_props = that.isSetEdge_props();
        if (this_present_edge_props || that_present_edge_props) {
            if (!this_present_edge_props || !that_present_edge_props) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.edge_props, that.edge_props)) {
                return false;
            }
        }
        boolean this_present_expressions = this.isSetExpressions();
        boolean that_present_expressions = that.isSetExpressions();
        if (this_present_expressions || that_present_expressions) {
            if (!this_present_expressions || !that_present_expressions) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.expressions, that.expressions)) {
                return false;
            }
        }
        boolean this_present_order_by = this.isSetOrder_by();
        boolean that_present_order_by = that.isSetOrder_by();
        if (this_present_order_by || that_present_order_by) {
            if (!this_present_order_by || !that_present_order_by) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.order_by, that.order_by)) {
                return false;
            }
        }
        boolean this_present_random = this.isSetRandom();
        boolean that_present_random = that.isSetRandom();
        if (this_present_random || that_present_random) {
            if (!this_present_random || !that_present_random) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.random, that.random)) {
                return false;
            }
        }
        boolean this_present_limit = this.isSetLimit();
        boolean that_present_limit = that.isSetLimit();
        if (this_present_limit || that_present_limit) {
            if (!this_present_limit || !that_present_limit) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.limit, that.limit)) {
                return false;
            }
        }
        boolean this_present_filter = this.isSetFilter();
        boolean that_present_filter = that.isSetFilter();
        if (this_present_filter || that_present_filter) {
            if (!this_present_filter || !that_present_filter) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.filter, that.filter)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_edge_types = this.isSetEdge_types();
        builder.append(present_edge_types);
        if (present_edge_types) {
            builder.append(this.edge_types);
        }
        boolean present_edge_direction = true;
        builder.append(present_edge_direction);
        if (present_edge_direction) {
            builder.append(this.edge_direction);
        }
        boolean present_dedup = true;
        builder.append(present_dedup);
        if (present_dedup) {
            builder.append(this.dedup);
        }
        boolean present_stat_props = this.isSetStat_props();
        builder.append(present_stat_props);
        if (present_stat_props) {
            builder.append(this.stat_props);
        }
        boolean present_vertex_props = this.isSetVertex_props();
        builder.append(present_vertex_props);
        if (present_vertex_props) {
            builder.append(this.vertex_props);
        }
        boolean present_edge_props = this.isSetEdge_props();
        builder.append(present_edge_props);
        if (present_edge_props) {
            builder.append(this.edge_props);
        }
        boolean present_expressions = this.isSetExpressions();
        builder.append(present_expressions);
        if (present_expressions) {
            builder.append(this.expressions);
        }
        boolean present_order_by = this.isSetOrder_by();
        builder.append(present_order_by);
        if (present_order_by) {
            builder.append(this.order_by);
        }
        boolean present_random = this.isSetRandom();
        builder.append(present_random);
        if (present_random) {
            builder.append(this.random);
        }
        boolean present_limit = this.isSetLimit();
        builder.append(present_limit);
        if (present_limit) {
            builder.append(this.limit);
        }
        boolean present_filter = this.isSetFilter();
        builder.append(present_filter);
        if (present_filter) {
            builder.append(this.filter);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(TraverseSpec other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetEdge_types()).compareTo(other.isSetEdge_types());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.edge_types, other.edge_types);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEdge_direction()).compareTo(other.isSetEdge_direction());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.edge_direction, other.edge_direction);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDedup()).compareTo(other.isSetDedup());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.dedup, other.dedup);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStat_props()).compareTo(other.isSetStat_props());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.stat_props, other.stat_props);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetVertex_props()).compareTo(other.isSetVertex_props());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.vertex_props, other.vertex_props);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEdge_props()).compareTo(other.isSetEdge_props());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.edge_props, other.edge_props);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetExpressions()).compareTo(other.isSetExpressions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.expressions, other.expressions);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOrder_by()).compareTo(other.isSetOrder_by());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.order_by, other.order_by);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRandom()).compareTo(other.isSetRandom());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.random, other.random);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLimit()).compareTo(other.isSetLimit());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.limit, other.limit);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFilter()).compareTo(other.isSetFilter());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.filter, other.filter);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 15) {
                        TList _list12 = iprot.readListBegin();
                        this.edge_types = new ArrayList<Integer>(Math.max(0, _list12.size));
                        int _i13 = 0;
                        while (_list12.size < 0 ? iprot.peekList() : _i13 < _list12.size) {
                            int _elem14 = iprot.readI32();
                            this.edge_types.add(_elem14);
                            ++_i13;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 8) {
                        this.edge_direction = iprot.readI32();
                        this.setEdge_directionIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 2) {
                        this.dedup = iprot.readBool();
                        this.setDedupIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 15) {
                        TList _list15 = iprot.readListBegin();
                        this.stat_props = new ArrayList<StatProp>(Math.max(0, _list15.size));
                        int _i16 = 0;
                        while (_list15.size < 0 ? iprot.peekList() : _i16 < _list15.size) {
                            StatProp _elem17 = new StatProp();
                            _elem17.read(iprot);
                            this.stat_props.add(_elem17);
                            ++_i16;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 5: {
                    if (field.type == 15) {
                        TList _list18 = iprot.readListBegin();
                        this.vertex_props = new ArrayList<VertexProp>(Math.max(0, _list18.size));
                        int _i19 = 0;
                        while (_list18.size < 0 ? iprot.peekList() : _i19 < _list18.size) {
                            VertexProp _elem20 = new VertexProp();
                            _elem20.read(iprot);
                            this.vertex_props.add(_elem20);
                            ++_i19;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 6: {
                    if (field.type == 15) {
                        TList _list21 = iprot.readListBegin();
                        this.edge_props = new ArrayList<EdgeProp>(Math.max(0, _list21.size));
                        int _i22 = 0;
                        while (_list21.size < 0 ? iprot.peekList() : _i22 < _list21.size) {
                            EdgeProp _elem23 = new EdgeProp();
                            _elem23.read(iprot);
                            this.edge_props.add(_elem23);
                            ++_i22;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 7: {
                    if (field.type == 15) {
                        TList _list24 = iprot.readListBegin();
                        this.expressions = new ArrayList<Expr>(Math.max(0, _list24.size));
                        int _i25 = 0;
                        while (_list24.size < 0 ? iprot.peekList() : _i25 < _list24.size) {
                            Expr _elem26 = new Expr();
                            _elem26.read(iprot);
                            this.expressions.add(_elem26);
                            ++_i25;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 8: {
                    if (field.type == 15) {
                        TList _list27 = iprot.readListBegin();
                        this.order_by = new ArrayList<OrderBy>(Math.max(0, _list27.size));
                        int _i28 = 0;
                        while (_list27.size < 0 ? iprot.peekList() : _i28 < _list27.size) {
                            OrderBy _elem29 = new OrderBy();
                            _elem29.read(iprot);
                            this.order_by.add(_elem29);
                            ++_i28;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 9: {
                    if (field.type == 2) {
                        this.random = iprot.readBool();
                        this.setRandomIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 10: {
                    if (field.type == 10) {
                        this.limit = iprot.readI64();
                        this.setLimitIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 11: {
                    if (field.type == 11) {
                        this.filter = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.edge_types != null) {
            oprot.writeFieldBegin(EDGE_TYPES_FIELD_DESC);
            oprot.writeListBegin(new TList(8, this.edge_types.size()));
            Iterator<Comparable<Integer>> iterator = this.edge_types.iterator();
            while (iterator.hasNext()) {
                int _iter30 = iterator.next();
                oprot.writeI32(_iter30);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(EDGE_DIRECTION_FIELD_DESC);
        oprot.writeI32(this.edge_direction);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(DEDUP_FIELD_DESC);
        oprot.writeBool(this.dedup);
        oprot.writeFieldEnd();
        if (this.stat_props != null && this.isSetStat_props()) {
            oprot.writeFieldBegin(STAT_PROPS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.stat_props.size()));
            for (StatProp _iter31 : this.stat_props) {
                _iter31.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.vertex_props != null && this.isSetVertex_props()) {
            oprot.writeFieldBegin(VERTEX_PROPS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.vertex_props.size()));
            for (VertexProp _iter32 : this.vertex_props) {
                _iter32.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.edge_props != null && this.isSetEdge_props()) {
            oprot.writeFieldBegin(EDGE_PROPS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.edge_props.size()));
            for (EdgeProp _iter33 : this.edge_props) {
                _iter33.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.expressions != null && this.isSetExpressions()) {
            oprot.writeFieldBegin(EXPRESSIONS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.expressions.size()));
            for (Expr _iter34 : this.expressions) {
                _iter34.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.order_by != null && this.isSetOrder_by()) {
            oprot.writeFieldBegin(ORDER_BY_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.order_by.size()));
            for (OrderBy _iter35 : this.order_by) {
                _iter35.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.isSetRandom()) {
            oprot.writeFieldBegin(RANDOM_FIELD_DESC);
            oprot.writeBool(this.random);
            oprot.writeFieldEnd();
        }
        if (this.isSetLimit()) {
            oprot.writeFieldBegin(LIMIT_FIELD_DESC);
            oprot.writeI64(this.limit);
            oprot.writeFieldEnd();
        }
        if (this.filter != null && this.isSetFilter()) {
            oprot.writeFieldBegin(FILTER_FIELD_DESC);
            oprot.writeBinary(this.filter);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("TraverseSpec");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("edge_types");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getEdge_types() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getEdge_types(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("edge_direction");
        sb.append(space);
        sb.append(":").append(space);
        String edge_direction_name = EdgeDirection.VALUES_TO_NAMES.get(this.getEdge_direction());
        if (edge_direction_name != null) {
            sb.append(edge_direction_name);
            sb.append(" (");
        }
        sb.append(this.getEdge_direction());
        if (edge_direction_name != null) {
            sb.append(")");
        }
        if (!(first = false)) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("dedup");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.isDedup(), indent + 1, prettyPrint));
        first = false;
        if (this.isSetStat_props()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("stat_props");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getStat_props() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getStat_props(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetVertex_props()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("vertex_props");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getVertex_props() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getVertex_props(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetEdge_props()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("edge_props");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getEdge_props() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getEdge_props(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetExpressions()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("expressions");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getExpressions() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getExpressions(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetOrder_by()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("order_by");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getOrder_by() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getOrder_by(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetRandom()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("random");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.isRandom(), indent + 1, prettyPrint));
            first = false;
        }
        if (this.isSetLimit()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("limit");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.getLimit(), indent + 1, prettyPrint));
            first = false;
        }
        if (this.isSetFilter()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("filter");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getFilter() == null) {
                sb.append("null");
            } else {
                int __filter_size = Math.min(this.getFilter().length, 128);
                for (int i = 0; i < __filter_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getFilter()[i]).length() > 1 ? Integer.toHexString(this.getFilter()[i]).substring(Integer.toHexString(this.getFilter()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getFilter()[i]).toUpperCase());
                }
                if (this.getFilter().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.isSetEdge_direction() && !EdgeDirection.VALID_VALUES.contains(this.edge_direction)) {
            throw new TProtocolException("The field 'edge_direction' has been assigned the invalid value " + this.edge_direction);
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("edge_types", 3, new ListMetaData(15, new FieldValueMetaData(8))));
        tmpMetaDataMap.put(2, new FieldMetaData("edge_direction", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(3, new FieldMetaData("dedup", 3, new FieldValueMetaData(2)));
        tmpMetaDataMap.put(4, new FieldMetaData("stat_props", 2, new ListMetaData(15, new StructMetaData(12, StatProp.class))));
        tmpMetaDataMap.put(5, new FieldMetaData("vertex_props", 2, new ListMetaData(15, new StructMetaData(12, VertexProp.class))));
        tmpMetaDataMap.put(6, new FieldMetaData("edge_props", 2, new ListMetaData(15, new StructMetaData(12, EdgeProp.class))));
        tmpMetaDataMap.put(7, new FieldMetaData("expressions", 2, new ListMetaData(15, new StructMetaData(12, Expr.class))));
        tmpMetaDataMap.put(8, new FieldMetaData("order_by", 2, new ListMetaData(15, new StructMetaData(12, OrderBy.class))));
        tmpMetaDataMap.put(9, new FieldMetaData("random", 2, new FieldValueMetaData(2)));
        tmpMetaDataMap.put(10, new FieldMetaData("limit", 2, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(11, new FieldMetaData("filter", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(TraverseSpec.class, metaDataMap);
    }
}

