/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.HostRole;
import com.vesoft.nebula.meta.HostStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class HostItem
implements TBase,
Serializable,
Cloneable,
Comparable<HostItem> {
    private static final TStruct STRUCT_DESC = new TStruct("HostItem");
    private static final TField HOST_ADDR_FIELD_DESC = new TField("hostAddr", 12, 1);
    private static final TField STATUS_FIELD_DESC = new TField("status", 8, 2);
    private static final TField LEADER_PARTS_FIELD_DESC = new TField("leader_parts", 13, 3);
    private static final TField ALL_PARTS_FIELD_DESC = new TField("all_parts", 13, 4);
    private static final TField ROLE_FIELD_DESC = new TField("role", 8, 5);
    private static final TField GIT_INFO_SHA_FIELD_DESC = new TField("git_info_sha", 11, 6);
    private static final TField ZONE_NAME_FIELD_DESC = new TField("zone_name", 11, 7);
    public HostAddr hostAddr;
    public int status;
    public Map<byte[], List<Integer>> leader_parts;
    public Map<byte[], List<Integer>> all_parts;
    public int role;
    public byte[] git_info_sha;
    public byte[] zone_name;
    public static final int HOSTADDR = 1;
    public static final int STATUS = 2;
    public static final int LEADER_PARTS = 3;
    public static final int ALL_PARTS = 4;
    public static final int ROLE = 5;
    public static final int GIT_INFO_SHA = 6;
    public static final int ZONE_NAME = 7;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __STATUS_ISSET_ID = 0;
    private static final int __ROLE_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public HostItem() {
    }

    public HostItem(HostAddr hostAddr, int status, Map<byte[], List<Integer>> leader_parts, Map<byte[], List<Integer>> all_parts, int role, byte[] git_info_sha) {
        this();
        this.hostAddr = hostAddr;
        this.status = status;
        this.setStatusIsSet(true);
        this.leader_parts = leader_parts;
        this.all_parts = all_parts;
        this.role = role;
        this.setRoleIsSet(true);
        this.git_info_sha = git_info_sha;
    }

    public HostItem(HostAddr hostAddr, int status, Map<byte[], List<Integer>> leader_parts, Map<byte[], List<Integer>> all_parts, int role, byte[] git_info_sha, byte[] zone_name) {
        this();
        this.hostAddr = hostAddr;
        this.status = status;
        this.setStatusIsSet(true);
        this.leader_parts = leader_parts;
        this.all_parts = all_parts;
        this.role = role;
        this.setRoleIsSet(true);
        this.git_info_sha = git_info_sha;
        this.zone_name = zone_name;
    }

    public HostItem(HostItem other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetHostAddr()) {
            this.hostAddr = TBaseHelper.deepCopy(other.hostAddr);
        }
        this.status = TBaseHelper.deepCopy(other.status);
        if (other.isSetLeader_parts()) {
            this.leader_parts = TBaseHelper.deepCopy(other.leader_parts);
        }
        if (other.isSetAll_parts()) {
            this.all_parts = TBaseHelper.deepCopy(other.all_parts);
        }
        this.role = TBaseHelper.deepCopy(other.role);
        if (other.isSetGit_info_sha()) {
            this.git_info_sha = TBaseHelper.deepCopy(other.git_info_sha);
        }
        if (other.isSetZone_name()) {
            this.zone_name = TBaseHelper.deepCopy(other.zone_name);
        }
    }

    @Override
    public HostItem deepCopy() {
        return new HostItem(this);
    }

    @Deprecated
    public HostItem clone() {
        return new HostItem(this);
    }

    public HostAddr getHostAddr() {
        return this.hostAddr;
    }

    public HostItem setHostAddr(HostAddr hostAddr) {
        this.hostAddr = hostAddr;
        return this;
    }

    public void unsetHostAddr() {
        this.hostAddr = null;
    }

    public boolean isSetHostAddr() {
        return this.hostAddr != null;
    }

    public void setHostAddrIsSet(boolean value) {
        if (!value) {
            this.hostAddr = null;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public HostItem setStatus(int status) {
        this.status = status;
        this.setStatusIsSet(true);
        return this;
    }

    public void unsetStatus() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetStatus() {
        return this.__isset_bit_vector.get(0);
    }

    public void setStatusIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public Map<byte[], List<Integer>> getLeader_parts() {
        return this.leader_parts;
    }

    public HostItem setLeader_parts(Map<byte[], List<Integer>> leader_parts) {
        this.leader_parts = leader_parts;
        return this;
    }

    public void unsetLeader_parts() {
        this.leader_parts = null;
    }

    public boolean isSetLeader_parts() {
        return this.leader_parts != null;
    }

    public void setLeader_partsIsSet(boolean value) {
        if (!value) {
            this.leader_parts = null;
        }
    }

    public Map<byte[], List<Integer>> getAll_parts() {
        return this.all_parts;
    }

    public HostItem setAll_parts(Map<byte[], List<Integer>> all_parts) {
        this.all_parts = all_parts;
        return this;
    }

    public void unsetAll_parts() {
        this.all_parts = null;
    }

    public boolean isSetAll_parts() {
        return this.all_parts != null;
    }

    public void setAll_partsIsSet(boolean value) {
        if (!value) {
            this.all_parts = null;
        }
    }

    public int getRole() {
        return this.role;
    }

    public HostItem setRole(int role) {
        this.role = role;
        this.setRoleIsSet(true);
        return this;
    }

    public void unsetRole() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetRole() {
        return this.__isset_bit_vector.get(1);
    }

    public void setRoleIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public byte[] getGit_info_sha() {
        return this.git_info_sha;
    }

    public HostItem setGit_info_sha(byte[] git_info_sha) {
        this.git_info_sha = git_info_sha;
        return this;
    }

    public void unsetGit_info_sha() {
        this.git_info_sha = null;
    }

    public boolean isSetGit_info_sha() {
        return this.git_info_sha != null;
    }

    public void setGit_info_shaIsSet(boolean value) {
        if (!value) {
            this.git_info_sha = null;
        }
    }

    public byte[] getZone_name() {
        return this.zone_name;
    }

    public HostItem setZone_name(byte[] zone_name) {
        this.zone_name = zone_name;
        return this;
    }

    public void unsetZone_name() {
        this.zone_name = null;
    }

    public boolean isSetZone_name() {
        return this.zone_name != null;
    }

    public void setZone_nameIsSet(boolean value) {
        if (!value) {
            this.zone_name = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetHostAddr();
                    break;
                }
                this.setHostAddr((HostAddr)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetStatus();
                    break;
                }
                this.setStatus((Integer)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetLeader_parts();
                    break;
                }
                this.setLeader_parts((Map)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetAll_parts();
                    break;
                }
                this.setAll_parts((Map)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetRole();
                    break;
                }
                this.setRole((Integer)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetGit_info_sha();
                    break;
                }
                this.setGit_info_sha((byte[])value);
                break;
            }
            case 7: {
                if (value == null) {
                    this.unsetZone_name();
                    break;
                }
                this.setZone_name((byte[])value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getHostAddr();
            }
            case 2: {
                return this.getStatus();
            }
            case 3: {
                return this.getLeader_parts();
            }
            case 4: {
                return this.getAll_parts();
            }
            case 5: {
                return this.getRole();
            }
            case 6: {
                return this.getGit_info_sha();
            }
            case 7: {
                return this.getZone_name();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetHostAddr();
            }
            case 2: {
                return this.isSetStatus();
            }
            case 3: {
                return this.isSetLeader_parts();
            }
            case 4: {
                return this.isSetAll_parts();
            }
            case 5: {
                return this.isSetRole();
            }
            case 6: {
                return this.isSetGit_info_sha();
            }
            case 7: {
                return this.isSetZone_name();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof HostItem) {
            return this.equals((HostItem)that);
        }
        return false;
    }

    public boolean equals(HostItem that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_hostAddr = this.isSetHostAddr();
        boolean that_present_hostAddr = that.isSetHostAddr();
        if (this_present_hostAddr || that_present_hostAddr) {
            if (!this_present_hostAddr || !that_present_hostAddr) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.hostAddr, that.hostAddr)) {
                return false;
            }
        }
        boolean this_present_status = true;
        boolean that_present_status = true;
        if (this_present_status || that_present_status) {
            if (!this_present_status || !that_present_status) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.status, that.status)) {
                return false;
            }
        }
        boolean this_present_leader_parts = this.isSetLeader_parts();
        boolean that_present_leader_parts = that.isSetLeader_parts();
        if (this_present_leader_parts || that_present_leader_parts) {
            if (!this_present_leader_parts || !that_present_leader_parts) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.leader_parts, that.leader_parts)) {
                return false;
            }
        }
        boolean this_present_all_parts = this.isSetAll_parts();
        boolean that_present_all_parts = that.isSetAll_parts();
        if (this_present_all_parts || that_present_all_parts) {
            if (!this_present_all_parts || !that_present_all_parts) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.all_parts, that.all_parts)) {
                return false;
            }
        }
        boolean this_present_role = true;
        boolean that_present_role = true;
        if (this_present_role || that_present_role) {
            if (!this_present_role || !that_present_role) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.role, that.role)) {
                return false;
            }
        }
        boolean this_present_git_info_sha = this.isSetGit_info_sha();
        boolean that_present_git_info_sha = that.isSetGit_info_sha();
        if (this_present_git_info_sha || that_present_git_info_sha) {
            if (!this_present_git_info_sha || !that_present_git_info_sha) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.git_info_sha, that.git_info_sha)) {
                return false;
            }
        }
        boolean this_present_zone_name = this.isSetZone_name();
        boolean that_present_zone_name = that.isSetZone_name();
        if (this_present_zone_name || that_present_zone_name) {
            if (!this_present_zone_name || !that_present_zone_name) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.zone_name, that.zone_name)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_hostAddr = this.isSetHostAddr();
        builder.append(present_hostAddr);
        if (present_hostAddr) {
            builder.append((Object)this.hostAddr);
        }
        boolean present_status = true;
        builder.append(present_status);
        if (present_status) {
            builder.append(this.status);
        }
        boolean present_leader_parts = this.isSetLeader_parts();
        builder.append(present_leader_parts);
        if (present_leader_parts) {
            builder.append(this.leader_parts);
        }
        boolean present_all_parts = this.isSetAll_parts();
        builder.append(present_all_parts);
        if (present_all_parts) {
            builder.append(this.all_parts);
        }
        boolean present_role = true;
        builder.append(present_role);
        if (present_role) {
            builder.append(this.role);
        }
        boolean present_git_info_sha = this.isSetGit_info_sha();
        builder.append(present_git_info_sha);
        if (present_git_info_sha) {
            builder.append(this.git_info_sha);
        }
        boolean present_zone_name = this.isSetZone_name();
        builder.append(present_zone_name);
        if (present_zone_name) {
            builder.append(this.zone_name);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(HostItem other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetHostAddr()).compareTo(other.isSetHostAddr());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.hostAddr, other.hostAddr);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStatus()).compareTo(other.isSetStatus());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.status, other.status);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader_parts()).compareTo(other.isSetLeader_parts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader_parts, other.leader_parts);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAll_parts()).compareTo(other.isSetAll_parts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.all_parts, other.all_parts);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRole()).compareTo(other.isSetRole());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.role, other.role);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGit_info_sha()).compareTo(other.isSetGit_info_sha());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.git_info_sha, other.git_info_sha);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetZone_name()).compareTo(other.isSetZone_name());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.zone_name, other.zone_name);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 12) {
                        this.hostAddr = new HostAddr();
                        this.hostAddr.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 8) {
                        this.status = iprot.readI32();
                        this.setStatusIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 13) {
                        TMap _map8 = iprot.readMapBegin();
                        this.leader_parts = new HashMap<byte[], List<Integer>>(Math.max(0, 2 * _map8.size));
                        int _i9 = 0;
                        while (_map8.size < 0 ? iprot.peekMap() : _i9 < _map8.size) {
                            byte[] _key10 = iprot.readBinary();
                            TList _list12 = iprot.readListBegin();
                            ArrayList<Integer> _val11 = new ArrayList<Integer>(Math.max(0, _list12.size));
                            int _i13 = 0;
                            while (_list12.size < 0 ? iprot.peekList() : _i13 < _list12.size) {
                                int _elem14 = iprot.readI32();
                                _val11.add(_elem14);
                                ++_i13;
                            }
                            iprot.readListEnd();
                            this.leader_parts.put(_key10, _val11);
                            ++_i9;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 13) {
                        TMap _map15 = iprot.readMapBegin();
                        this.all_parts = new HashMap<byte[], List<Integer>>(Math.max(0, 2 * _map15.size));
                        int _i16 = 0;
                        while (_map15.size < 0 ? iprot.peekMap() : _i16 < _map15.size) {
                            byte[] _key17 = iprot.readBinary();
                            TList _list19 = iprot.readListBegin();
                            ArrayList<Integer> _val18 = new ArrayList<Integer>(Math.max(0, _list19.size));
                            int _i20 = 0;
                            while (_list19.size < 0 ? iprot.peekList() : _i20 < _list19.size) {
                                int _elem21 = iprot.readI32();
                                _val18.add(_elem21);
                                ++_i20;
                            }
                            iprot.readListEnd();
                            this.all_parts.put(_key17, _val18);
                            ++_i16;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 5: {
                    if (field.type == 8) {
                        this.role = iprot.readI32();
                        this.setRoleIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 6: {
                    if (field.type == 11) {
                        this.git_info_sha = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 7: {
                    if (field.type == 11) {
                        this.zone_name = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.hostAddr != null) {
            oprot.writeFieldBegin(HOST_ADDR_FIELD_DESC);
            this.hostAddr.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(STATUS_FIELD_DESC);
        oprot.writeI32(this.status);
        oprot.writeFieldEnd();
        if (this.leader_parts != null) {
            oprot.writeFieldBegin(LEADER_PARTS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 15, this.leader_parts.size()));
            for (Map.Entry<byte[], List<Integer>> _iter22 : this.leader_parts.entrySet()) {
                oprot.writeBinary(_iter22.getKey());
                oprot.writeListBegin(new TList(8, _iter22.getValue().size()));
                for (int _iter23 : _iter22.getValue()) {
                    oprot.writeI32(_iter23);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.all_parts != null) {
            oprot.writeFieldBegin(ALL_PARTS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 15, this.all_parts.size()));
            for (Map.Entry<byte[], List<Integer>> _iter24 : this.all_parts.entrySet()) {
                oprot.writeBinary(_iter24.getKey());
                oprot.writeListBegin(new TList(8, _iter24.getValue().size()));
                for (int _iter25 : _iter24.getValue()) {
                    oprot.writeI32(_iter25);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(ROLE_FIELD_DESC);
        oprot.writeI32(this.role);
        oprot.writeFieldEnd();
        if (this.git_info_sha != null) {
            oprot.writeFieldBegin(GIT_INFO_SHA_FIELD_DESC);
            oprot.writeBinary(this.git_info_sha);
            oprot.writeFieldEnd();
        }
        if (this.zone_name != null && this.isSetZone_name()) {
            oprot.writeFieldBegin(ZONE_NAME_FIELD_DESC);
            oprot.writeBinary(this.zone_name);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("HostItem");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("hostAddr");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHostAddr() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHostAddr(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("status");
        sb.append(space);
        sb.append(":").append(space);
        String status_name = HostStatus.VALUES_TO_NAMES.get(this.getStatus());
        if (status_name != null) {
            sb.append(status_name);
            sb.append(" (");
        }
        sb.append(this.getStatus());
        if (status_name != null) {
            sb.append(")");
        }
        if (!(first = false)) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader_parts");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader_parts() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader_parts(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("all_parts");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getAll_parts() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getAll_parts(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("role");
        sb.append(space);
        sb.append(":").append(space);
        String role_name = HostRole.VALUES_TO_NAMES.get(this.getRole());
        if (role_name != null) {
            sb.append(role_name);
            sb.append(" (");
        }
        sb.append(this.getRole());
        if (role_name != null) {
            sb.append(")");
        }
        if (!(first = false)) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("git_info_sha");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getGit_info_sha() == null) {
            sb.append("null");
        } else {
            int __git_info_sha_size = Math.min(this.getGit_info_sha().length, 128);
            for (i = 0; i < __git_info_sha_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getGit_info_sha()[i]).length() > 1 ? Integer.toHexString(this.getGit_info_sha()[i]).substring(Integer.toHexString(this.getGit_info_sha()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getGit_info_sha()[i]).toUpperCase());
            }
            if (this.getGit_info_sha().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (this.isSetZone_name()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("zone_name");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getZone_name() == null) {
                sb.append("null");
            } else {
                int __zone_name_size = Math.min(this.getZone_name().length, 128);
                for (i = 0; i < __zone_name_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getZone_name()[i]).length() > 1 ? Integer.toHexString(this.getZone_name()[i]).substring(Integer.toHexString(this.getZone_name()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getZone_name()[i]).toUpperCase());
                }
                if (this.getZone_name().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.isSetStatus() && !HostStatus.VALID_VALUES.contains(this.status)) {
            throw new TProtocolException("The field 'status' has been assigned the invalid value " + this.status);
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("hostAddr", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("status", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(3, new FieldMetaData("leader_parts", 3, new MapMetaData(13, new FieldValueMetaData(11), new ListMetaData(15, new FieldValueMetaData(8)))));
        tmpMetaDataMap.put(4, new FieldMetaData("all_parts", 3, new MapMetaData(13, new FieldValueMetaData(11), new ListMetaData(15, new FieldValueMetaData(8)))));
        tmpMetaDataMap.put(5, new FieldMetaData("role", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(6, new FieldMetaData("git_info_sha", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(7, new FieldMetaData("zone_name", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(HostItem.class, metaDataMap);
    }
}

