/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.transport.TSocket;
import com.facebook.thrift.transport.TTransport;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.storage.GraphStorageService;
import com.vesoft.nebula.storage.ScanEdgeRequest;
import com.vesoft.nebula.storage.ScanEdgeResponse;
import com.vesoft.nebula.storage.ScanVertexRequest;
import com.vesoft.nebula.storage.ScanVertexResponse;
import java.net.InetAddress;

public class GraphStorageConnection {
    protected TTransport transport = null;
    protected TProtocol protocol = null;
    public HostAddress address;
    private GraphStorageService.Client client;

    protected GraphStorageConnection() {
    }

    protected GraphStorageConnection open(HostAddress address, int timeout) throws Exception {
        this.address = address;
        int newTimeout = timeout <= 0 ? Integer.MAX_VALUE : timeout;
        this.transport = new TSocket(InetAddress.getByName(address.getHost()).getHostAddress(), address.getPort(), newTimeout, newTimeout);
        this.transport.open();
        this.protocol = new TCompactProtocol(this.transport);
        this.client = new GraphStorageService.Client(this.protocol);
        return this;
    }

    public ScanVertexResponse scanVertex(ScanVertexRequest request) throws TException {
        return this.client.scanVertex(request);
    }

    public ScanEdgeResponse scanEdge(ScanEdgeRequest request) throws TException {
        return this.client.scanEdge(request);
    }

    public void close() {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
    }

    public HostAddress getAddress() {
        return this.address;
    }
}

