/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.NewEdge;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class AddEdgesRequest
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("AddEdgesRequest");
    private static final TField SPACE_ID_FIELD_DESC = new TField("space_id", 8, 1);
    private static final TField PARTS_FIELD_DESC = new TField("parts", 13, 2);
    private static final TField PROP_NAMES_FIELD_DESC = new TField("prop_names", 15, 3);
    private static final TField OVERWRITABLE_FIELD_DESC = new TField("overwritable", 2, 4);
    public int space_id;
    public Map<Integer, List<NewEdge>> parts;
    public List<byte[]> prop_names;
    public boolean overwritable;
    public static final int SPACE_ID = 1;
    public static final int PARTS = 2;
    public static final int PROP_NAMES = 3;
    public static final int OVERWRITABLE = 4;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __SPACE_ID_ISSET_ID = 0;
    private static final int __OVERWRITABLE_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public AddEdgesRequest() {
        this.overwritable = true;
    }

    public AddEdgesRequest(int space_id, Map<Integer, List<NewEdge>> parts, List<byte[]> prop_names, boolean overwritable) {
        this();
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        this.parts = parts;
        this.prop_names = prop_names;
        this.overwritable = overwritable;
        this.setOverwritableIsSet(true);
    }

    public AddEdgesRequest(AddEdgesRequest other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.space_id = TBaseHelper.deepCopy(other.space_id);
        if (other.isSetParts()) {
            this.parts = TBaseHelper.deepCopy(other.parts);
        }
        if (other.isSetProp_names()) {
            this.prop_names = TBaseHelper.deepCopy(other.prop_names);
        }
        this.overwritable = TBaseHelper.deepCopy(other.overwritable);
    }

    @Override
    public AddEdgesRequest deepCopy() {
        return new AddEdgesRequest(this);
    }

    @Deprecated
    public AddEdgesRequest clone() {
        return new AddEdgesRequest(this);
    }

    public int getSpace_id() {
        return this.space_id;
    }

    public AddEdgesRequest setSpace_id(int space_id) {
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        return this;
    }

    public void unsetSpace_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetSpace_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setSpace_idIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public Map<Integer, List<NewEdge>> getParts() {
        return this.parts;
    }

    public AddEdgesRequest setParts(Map<Integer, List<NewEdge>> parts) {
        this.parts = parts;
        return this;
    }

    public void unsetParts() {
        this.parts = null;
    }

    public boolean isSetParts() {
        return this.parts != null;
    }

    public void setPartsIsSet(boolean value) {
        if (!value) {
            this.parts = null;
        }
    }

    public List<byte[]> getProp_names() {
        return this.prop_names;
    }

    public AddEdgesRequest setProp_names(List<byte[]> prop_names) {
        this.prop_names = prop_names;
        return this;
    }

    public void unsetProp_names() {
        this.prop_names = null;
    }

    public boolean isSetProp_names() {
        return this.prop_names != null;
    }

    public void setProp_namesIsSet(boolean value) {
        if (!value) {
            this.prop_names = null;
        }
    }

    public boolean isOverwritable() {
        return this.overwritable;
    }

    public AddEdgesRequest setOverwritable(boolean overwritable) {
        this.overwritable = overwritable;
        this.setOverwritableIsSet(true);
        return this;
    }

    public void unsetOverwritable() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetOverwritable() {
        return this.__isset_bit_vector.get(1);
    }

    public void setOverwritableIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetSpace_id();
                    break;
                }
                this.setSpace_id((Integer)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetParts();
                    break;
                }
                this.setParts((Map)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetProp_names();
                    break;
                }
                this.setProp_names((List)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetOverwritable();
                    break;
                }
                this.setOverwritable((Boolean)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Integer(this.getSpace_id());
            }
            case 2: {
                return this.getParts();
            }
            case 3: {
                return this.getProp_names();
            }
            case 4: {
                return new Boolean(this.isOverwritable());
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetSpace_id();
            }
            case 2: {
                return this.isSetParts();
            }
            case 3: {
                return this.isSetProp_names();
            }
            case 4: {
                return this.isSetOverwritable();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof AddEdgesRequest) {
            return this.equals((AddEdgesRequest)that);
        }
        return false;
    }

    public boolean equals(AddEdgesRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_space_id = true;
        boolean that_present_space_id = true;
        if (this_present_space_id || that_present_space_id) {
            if (!this_present_space_id || !that_present_space_id) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.space_id, that.space_id)) {
                return false;
            }
        }
        boolean this_present_parts = this.isSetParts();
        boolean that_present_parts = that.isSetParts();
        if (this_present_parts || that_present_parts) {
            if (!this_present_parts || !that_present_parts) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.parts, that.parts)) {
                return false;
            }
        }
        boolean this_present_prop_names = this.isSetProp_names();
        boolean that_present_prop_names = that.isSetProp_names();
        if (this_present_prop_names || that_present_prop_names) {
            if (!this_present_prop_names || !that_present_prop_names) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.prop_names, that.prop_names)) {
                return false;
            }
        }
        boolean this_present_overwritable = true;
        boolean that_present_overwritable = true;
        if (this_present_overwritable || that_present_overwritable) {
            if (!this_present_overwritable || !that_present_overwritable) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.overwritable, that.overwritable)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_space_id = true;
        builder.append(present_space_id);
        if (present_space_id) {
            builder.append(this.space_id);
        }
        boolean present_parts = this.isSetParts();
        builder.append(present_parts);
        if (present_parts) {
            builder.append(this.parts);
        }
        boolean present_prop_names = this.isSetProp_names();
        builder.append(present_prop_names);
        if (present_prop_names) {
            builder.append(this.prop_names);
        }
        boolean present_overwritable = true;
        builder.append(present_overwritable);
        if (present_overwritable) {
            builder.append(this.overwritable);
        }
        return builder.toHashCode();
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.space_id = iprot.readI32();
                        this.setSpace_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 13) {
                        TMap _map104 = iprot.readMapBegin();
                        this.parts = new HashMap<Integer, List<NewEdge>>(Math.max(0, 2 * _map104.size));
                        int _i105 = 0;
                        while (_map104.size < 0 ? iprot.peekMap() : _i105 < _map104.size) {
                            int _key106 = iprot.readI32();
                            TList _list108 = iprot.readListBegin();
                            ArrayList<NewEdge> _val107 = new ArrayList<NewEdge>(Math.max(0, _list108.size));
                            int _i109 = 0;
                            while (_list108.size < 0 ? iprot.peekList() : _i109 < _list108.size) {
                                NewEdge _elem110 = new NewEdge();
                                _elem110.read(iprot);
                                _val107.add(_elem110);
                                ++_i109;
                            }
                            iprot.readListEnd();
                            this.parts.put(_key106, _val107);
                            ++_i105;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 15) {
                        TList _list111 = iprot.readListBegin();
                        this.prop_names = new ArrayList<byte[]>(Math.max(0, _list111.size));
                        int _i112 = 0;
                        while (_list111.size < 0 ? iprot.peekList() : _i112 < _list111.size) {
                            byte[] _elem113 = iprot.readBinary();
                            this.prop_names.add(_elem113);
                            ++_i112;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 2) {
                        this.overwritable = iprot.readBool();
                        this.setOverwritableIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SPACE_ID_FIELD_DESC);
        oprot.writeI32(this.space_id);
        oprot.writeFieldEnd();
        if (this.parts != null) {
            oprot.writeFieldBegin(PARTS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 15, this.parts.size()));
            for (Map.Entry<Integer, List<NewEdge>> _iter114 : this.parts.entrySet()) {
                oprot.writeI32(_iter114.getKey());
                oprot.writeListBegin(new TList(12, _iter114.getValue().size()));
                for (NewEdge _iter115 : _iter114.getValue()) {
                    _iter115.write(oprot);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.prop_names != null) {
            oprot.writeFieldBegin(PROP_NAMES_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.prop_names.size()));
            for (byte[] _iter116 : this.prop_names) {
                oprot.writeBinary(_iter116);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(OVERWRITABLE_FIELD_DESC);
        oprot.writeBool(this.overwritable);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("AddEdgesRequest");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("space_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getSpace_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("parts");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getParts() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getParts(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("prop_names");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getProp_names() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getProp_names(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("overwritable");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.isOverwritable(), indent + 1, prettyPrint));
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("space_id", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("parts", 3, new MapMetaData(13, new FieldValueMetaData(8), new ListMetaData(15, new StructMetaData(12, NewEdge.class)))));
        tmpMetaDataMap.put(3, new FieldMetaData("prop_names", 3, new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMetaDataMap.put(4, new FieldMetaData("overwritable", 3, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(AddEdgesRequest.class, metaDataMap);
    }
}

