/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.Value;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Edge
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Edge");
    private static final TField SRC_FIELD_DESC = new TField("src", 11, 1);
    private static final TField DST_FIELD_DESC = new TField("dst", 11, 2);
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 3);
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 4);
    private static final TField RANKING_FIELD_DESC = new TField("ranking", 10, 5);
    private static final TField PROPS_FIELD_DESC = new TField("props", 13, 6);
    public byte[] src;
    public byte[] dst;
    public int type;
    public byte[] name;
    public long ranking;
    public Map<byte[], Value> props;
    public static final int SRC = 1;
    public static final int DST = 2;
    public static final int TYPE = 3;
    public static final int NAME = 4;
    public static final int RANKING = 5;
    public static final int PROPS = 6;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __TYPE_ISSET_ID = 0;
    private static final int __RANKING_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public Edge() {
    }

    public Edge(byte[] src, byte[] dst, int type, byte[] name, long ranking, Map<byte[], Value> props) {
        this();
        this.src = src;
        this.dst = dst;
        this.type = type;
        this.setTypeIsSet(true);
        this.name = name;
        this.ranking = ranking;
        this.setRankingIsSet(true);
        this.props = props;
    }

    public Edge(Edge other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetSrc()) {
            this.src = TBaseHelper.deepCopy(other.src);
        }
        if (other.isSetDst()) {
            this.dst = TBaseHelper.deepCopy(other.dst);
        }
        this.type = TBaseHelper.deepCopy(other.type);
        if (other.isSetName()) {
            this.name = TBaseHelper.deepCopy(other.name);
        }
        this.ranking = TBaseHelper.deepCopy(other.ranking);
        if (other.isSetProps()) {
            this.props = TBaseHelper.deepCopy(other.props);
        }
    }

    @Override
    public Edge deepCopy() {
        return new Edge(this);
    }

    @Deprecated
    public Edge clone() {
        return new Edge(this);
    }

    public byte[] getSrc() {
        return this.src;
    }

    public Edge setSrc(byte[] src) {
        this.src = src;
        return this;
    }

    public void unsetSrc() {
        this.src = null;
    }

    public boolean isSetSrc() {
        return this.src != null;
    }

    public void setSrcIsSet(boolean value) {
        if (!value) {
            this.src = null;
        }
    }

    public byte[] getDst() {
        return this.dst;
    }

    public Edge setDst(byte[] dst) {
        this.dst = dst;
        return this;
    }

    public void unsetDst() {
        this.dst = null;
    }

    public boolean isSetDst() {
        return this.dst != null;
    }

    public void setDstIsSet(boolean value) {
        if (!value) {
            this.dst = null;
        }
    }

    public int getType() {
        return this.type;
    }

    public Edge setType(int type) {
        this.type = type;
        this.setTypeIsSet(true);
        return this;
    }

    public void unsetType() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetType() {
        return this.__isset_bit_vector.get(0);
    }

    public void setTypeIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public byte[] getName() {
        return this.name;
    }

    public Edge setName(byte[] name) {
        this.name = name;
        return this;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    public long getRanking() {
        return this.ranking;
    }

    public Edge setRanking(long ranking) {
        this.ranking = ranking;
        this.setRankingIsSet(true);
        return this;
    }

    public void unsetRanking() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetRanking() {
        return this.__isset_bit_vector.get(1);
    }

    public void setRankingIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public Map<byte[], Value> getProps() {
        return this.props;
    }

    public Edge setProps(Map<byte[], Value> props) {
        this.props = props;
        return this;
    }

    public void unsetProps() {
        this.props = null;
    }

    public boolean isSetProps() {
        return this.props != null;
    }

    public void setPropsIsSet(boolean value) {
        if (!value) {
            this.props = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetSrc();
                    break;
                }
                this.setSrc((byte[])value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetDst();
                    break;
                }
                this.setDst((byte[])value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((Integer)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((byte[])value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetRanking();
                    break;
                }
                this.setRanking((Long)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetProps();
                    break;
                }
                this.setProps((Map)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getSrc();
            }
            case 2: {
                return this.getDst();
            }
            case 3: {
                return new Integer(this.getType());
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return new Long(this.getRanking());
            }
            case 6: {
                return this.getProps();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetSrc();
            }
            case 2: {
                return this.isSetDst();
            }
            case 3: {
                return this.isSetType();
            }
            case 4: {
                return this.isSetName();
            }
            case 5: {
                return this.isSetRanking();
            }
            case 6: {
                return this.isSetProps();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Edge) {
            return this.equals((Edge)that);
        }
        return false;
    }

    public boolean equals(Edge that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_src = this.isSetSrc();
        boolean that_present_src = that.isSetSrc();
        if (this_present_src || that_present_src) {
            if (!this_present_src || !that_present_src) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.src, that.src)) {
                return false;
            }
        }
        boolean this_present_dst = this.isSetDst();
        boolean that_present_dst = that.isSetDst();
        if (this_present_dst || that_present_dst) {
            if (!this_present_dst || !that_present_dst) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.dst, that.dst)) {
                return false;
            }
        }
        boolean this_present_type = true;
        boolean that_present_type = true;
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.type, that.type)) {
                return false;
            }
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.name, that.name)) {
                return false;
            }
        }
        boolean this_present_ranking = true;
        boolean that_present_ranking = true;
        if (this_present_ranking || that_present_ranking) {
            if (!this_present_ranking || !that_present_ranking) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.ranking, that.ranking)) {
                return false;
            }
        }
        boolean this_present_props = this.isSetProps();
        boolean that_present_props = that.isSetProps();
        if (this_present_props || that_present_props) {
            if (!this_present_props || !that_present_props) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.props, that.props)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_src = this.isSetSrc();
        builder.append(present_src);
        if (present_src) {
            builder.append(this.src);
        }
        boolean present_dst = this.isSetDst();
        builder.append(present_dst);
        if (present_dst) {
            builder.append(this.dst);
        }
        boolean present_type = true;
        builder.append(present_type);
        if (present_type) {
            builder.append(this.type);
        }
        boolean present_name = this.isSetName();
        builder.append(present_name);
        if (present_name) {
            builder.append(this.name);
        }
        boolean present_ranking = true;
        builder.append(present_ranking);
        if (present_ranking) {
            builder.append(this.ranking);
        }
        boolean present_props = this.isSetProps();
        builder.append(present_props);
        if (present_props) {
            builder.append(this.props);
        }
        return builder.toHashCode();
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.src = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.dst = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 8) {
                        this.type = iprot.readI32();
                        this.setTypeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 11) {
                        this.name = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 5: {
                    if (field.type == 10) {
                        this.ranking = iprot.readI64();
                        this.setRankingIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 6: {
                    if (field.type == 13) {
                        TMap _map34 = iprot.readMapBegin();
                        this.props = new HashMap<byte[], Value>(Math.max(0, 2 * _map34.size));
                        int _i35 = 0;
                        while (_map34.size < 0 ? iprot.peekMap() : _i35 < _map34.size) {
                            byte[] _key36 = iprot.readBinary();
                            Value _val37 = new Value();
                            _val37.read(iprot);
                            this.props.put(_key36, _val37);
                            ++_i35;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.src != null) {
            oprot.writeFieldBegin(SRC_FIELD_DESC);
            oprot.writeBinary(this.src);
            oprot.writeFieldEnd();
        }
        if (this.dst != null) {
            oprot.writeFieldBegin(DST_FIELD_DESC);
            oprot.writeBinary(this.dst);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TYPE_FIELD_DESC);
        oprot.writeI32(this.type);
        oprot.writeFieldEnd();
        if (this.name != null) {
            oprot.writeFieldBegin(NAME_FIELD_DESC);
            oprot.writeBinary(this.name);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(RANKING_FIELD_DESC);
        oprot.writeI64(this.ranking);
        oprot.writeFieldEnd();
        if (this.props != null) {
            oprot.writeFieldBegin(PROPS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 12, this.props.size()));
            for (Map.Entry<byte[], Value> _iter38 : this.props.entrySet()) {
                oprot.writeBinary(_iter38.getKey());
                _iter38.getValue().write(oprot);
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("Edge");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("src");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getSrc() == null) {
            sb.append("null");
        } else {
            int __src_size = Math.min(this.getSrc().length, 128);
            for (i = 0; i < __src_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getSrc()[i]).length() > 1 ? Integer.toHexString(this.getSrc()[i]).substring(Integer.toHexString(this.getSrc()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getSrc()[i]).toUpperCase());
            }
            if (this.getSrc().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("dst");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getDst() == null) {
            sb.append("null");
        } else {
            int __dst_size = Math.min(this.getDst().length, 128);
            for (i = 0; i < __dst_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getDst()[i]).length() > 1 ? Integer.toHexString(this.getDst()[i]).substring(Integer.toHexString(this.getDst()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getDst()[i]).toUpperCase());
            }
            if (this.getDst().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("type");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getType(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("name");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getName() == null) {
            sb.append("null");
        } else {
            int __name_size = Math.min(this.getName().length, 128);
            for (i = 0; i < __name_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getName()[i]).length() > 1 ? Integer.toHexString(this.getName()[i]).substring(Integer.toHexString(this.getName()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getName()[i]).toUpperCase());
            }
            if (this.getName().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("ranking");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getRanking(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("props");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getProps() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getProps(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("src", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("dst", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(3, new FieldMetaData("type", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(4, new FieldMetaData("name", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(5, new FieldMetaData("ranking", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(6, new FieldMetaData("props", 3, new MapMetaData(13, new FieldValueMetaData(11), new StructMetaData(12, Value.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(Edge.class, metaDataMap);
    }
}

