/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.EdgeKey;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Edge
implements TBase,
Serializable,
Cloneable,
Comparable<Edge> {
    private static final TStruct STRUCT_DESC = new TStruct("Edge");
    private static final TField KEY_FIELD_DESC = new TField("key", 12, 1);
    private static final TField PROPS_FIELD_DESC = new TField("props", 11, 2);
    public EdgeKey key;
    public byte[] props;
    public static final int KEY = 1;
    public static final int PROPS = 2;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public Edge() {
    }

    public Edge(EdgeKey key, byte[] props) {
        this();
        this.key = key;
        this.props = props;
    }

    public Edge(Edge other) {
        if (other.isSetKey()) {
            this.key = TBaseHelper.deepCopy(other.key);
        }
        if (other.isSetProps()) {
            this.props = TBaseHelper.deepCopy(other.props);
        }
    }

    @Override
    public Edge deepCopy() {
        return new Edge(this);
    }

    @Deprecated
    public Edge clone() {
        return new Edge(this);
    }

    public EdgeKey getKey() {
        return this.key;
    }

    public Edge setKey(EdgeKey key) {
        this.key = key;
        return this;
    }

    public void unsetKey() {
        this.key = null;
    }

    public boolean isSetKey() {
        return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
        if (!value) {
            this.key = null;
        }
    }

    public byte[] getProps() {
        return this.props;
    }

    public Edge setProps(byte[] props) {
        this.props = props;
        return this;
    }

    public void unsetProps() {
        this.props = null;
    }

    public boolean isSetProps() {
        return this.props != null;
    }

    public void setPropsIsSet(boolean value) {
        if (!value) {
            this.props = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetKey();
                    break;
                }
                this.setKey((EdgeKey)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetProps();
                    break;
                }
                this.setProps((byte[])value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getKey();
            }
            case 2: {
                return this.getProps();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetKey();
            }
            case 2: {
                return this.isSetProps();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Edge) {
            return this.equals((Edge)that);
        }
        return false;
    }

    public boolean equals(Edge that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_key = this.isSetKey();
        boolean that_present_key = that.isSetKey();
        if (this_present_key || that_present_key) {
            if (!this_present_key || !that_present_key) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.key, that.key)) {
                return false;
            }
        }
        boolean this_present_props = this.isSetProps();
        boolean that_present_props = that.isSetProps();
        if (this_present_props || that_present_props) {
            if (!this_present_props || !that_present_props) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.props, that.props)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_key = this.isSetKey();
        builder.append(present_key);
        if (present_key) {
            builder.append(this.key);
        }
        boolean present_props = this.isSetProps();
        builder.append(present_props);
        if (present_props) {
            builder.append(this.props);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(Edge other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(other.isSetKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.key, other.key);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProps()).compareTo(other.isSetProps());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.props, other.props);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 12) {
                        this.key = new EdgeKey();
                        this.key.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.props = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.key != null) {
            oprot.writeFieldBegin(KEY_FIELD_DESC);
            this.key.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.props != null) {
            oprot.writeFieldBegin(PROPS_FIELD_DESC);
            oprot.writeBinary(this.props);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("Edge");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("key");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getKey() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getKey(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("props");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getProps() == null) {
            sb.append("null");
        } else {
            int __props_size = Math.min(this.getProps().length, 128);
            for (int i = 0; i < __props_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getProps()[i]).length() > 1 ? Integer.toHexString(this.getProps()[i]).substring(Integer.toHexString(this.getProps()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getProps()[i]).toUpperCase());
            }
            if (this.getProps().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("key", 3, new StructMetaData(12, EdgeKey.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("props", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(Edge.class, metaDataMap);
    }
}

