/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.meta.async;

import com.facebook.thrift.TException;
import com.google.common.base.Optional;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.vesoft.nebula.AsyncAbstractClient;
import com.vesoft.nebula.client.meta.async.AsyncMetaClient;
import com.vesoft.nebula.client.meta.async.entry.ListEdgesCallback;
import com.vesoft.nebula.client.meta.async.entry.ListSpaceCallback;
import com.vesoft.nebula.client.meta.async.entry.ListTagsCallback;
import com.vesoft.nebula.meta.GetPartsAllocResp;
import com.vesoft.nebula.meta.ListEdgesReq;
import com.vesoft.nebula.meta.ListEdgesResp;
import com.vesoft.nebula.meta.ListSpacesReq;
import com.vesoft.nebula.meta.ListSpacesResp;
import com.vesoft.nebula.meta.ListTagsReq;
import com.vesoft.nebula.meta.ListTagsResp;
import com.vesoft.nebula.meta.MetaService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncMetaClientImpl
extends AsyncAbstractClient
implements AsyncMetaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncMetaClientImpl.class.getName());
    private Map<String, Integer> spaceNameID = new HashMap<String, Integer>();
    private MetaService.AsyncClient client;
    private Map<String, Integer> spaceNames;

    public AsyncMetaClientImpl(List<HostAndPort> addresses, int timeout, int connectionRetry, int executionRetry) {
        super(addresses, timeout, connectionRetry, executionRetry);
    }

    public AsyncMetaClientImpl(List<HostAndPort> addresses) {
        super(addresses);
    }

    public AsyncMetaClientImpl(String host, int port) {
        super(host, port);
    }

    @Override
    public int doConnect(List<HostAndPort> address) throws TException {
        this.client = new MetaService.AsyncClient(this.protocolFactory, this.manager, this.transport);
        return 0;
    }

    public int getSpaceIDFromCache(String name) {
        if (!this.spaceNameID.containsKey(name)) {
            return -1;
        }
        return this.spaceNameID.get(name);
    }

    @Override
    public ListenableFuture<Optional<ListSpacesResp>> listSpaces() {
        return this.service.submit(() -> {
            ListSpaceCallback callback = new ListSpaceCallback();
            try {
                this.client.listSpaces(new ListSpacesReq(), callback);
            }
            catch (TException e) {
                LOGGER.error(String.format("List Space Call Error: %s", e.getMessage()));
            }
            if (callback.getResult().isPresent()) {
                ListSpacesResp resp = (ListSpacesResp)callback.getResult().get();
                return Optional.of(resp);
            }
            return Optional.absent();
        });
    }

    @Override
    public ListenableFuture<Optional<GetPartsAllocResp>> getPartsAlloc(String spaceName) {
        if (!this.spaceNames.containsKey(spaceName)) {
            LOGGER.error("Space not found");
            return null;
        }
        return this.getPartsAlloc(spaceName);
    }

    @Override
    public ListenableFuture<Optional<ListTagsResp>> listTags(String spaceName) {
        return this.service.submit(() -> {
            ListTagsCallback callback = new ListTagsCallback();
            ListTagsReq req = new ListTagsReq();
            req.setSpace_id(this.getSpaceIDFromCache(spaceName));
            try {
                this.client.listTags(req, callback);
            }
            catch (TException e) {
                LOGGER.error(String.format("List Tags Call Error: %s", e.getMessage()));
            }
            while (!callback.checkReady()) {
                Thread.sleep(1L);
            }
            if (callback.getResult().isPresent()) {
                ListTagsResp resp = (ListTagsResp)callback.getResult().get();
                return Optional.of(resp);
            }
            return Optional.absent();
        });
    }

    @Override
    public ListenableFuture<Optional<ListEdgesResp>> listEdges(String spaceName) {
        return this.service.submit(() -> {
            ListEdgesCallback callback = new ListEdgesCallback();
            ListEdgesReq req = new ListEdgesReq();
            req.setSpace_id(this.getSpaceIDFromCache(spaceName));
            try {
                this.client.listEdges(req, callback);
            }
            catch (TException e) {
                LOGGER.error(String.format("List Edges Call Error: %s", e.getMessage()));
            }
            while (!callback.checkReady()) {
                Thread.sleep(1L);
            }
            if (callback.getResult().isPresent()) {
                ListEdgesResp resp = (ListEdgesResp)callback.getResult().get();
                return Optional.of(resp);
            }
            return Optional.absent();
        });
    }
}

