/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.graph;

import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.TUnion;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.graph.Edge;
import com.vesoft.nebula.graph.Vertex;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class PathEntry
extends TUnion<PathEntry>
implements Comparable<PathEntry> {
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final TStruct STRUCT_DESC = new TStruct("PathEntry");
    private static final TField VERTEX_FIELD_DESC = new TField("vertex", 12, 1);
    private static final TField EDGE_FIELD_DESC = new TField("edge", 12, 2);
    public static final int VERTEX = 1;
    public static final int EDGE = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public PathEntry() {
    }

    public PathEntry(int setField, Object value) {
        super(setField, value);
    }

    public PathEntry(PathEntry other) {
        super(other);
    }

    @Override
    public PathEntry deepCopy() {
        return new PathEntry(this);
    }

    public static PathEntry vertex(Vertex value) {
        PathEntry x = new PathEntry();
        x.setVertex(value);
        return x;
    }

    public static PathEntry edge(Edge value) {
        PathEntry x = new PathEntry();
        x.setEdge(value);
        return x;
    }

    @Override
    protected void checkType(short setField, Object value) throws ClassCastException {
        switch (setField) {
            case 1: {
                if (value instanceof Vertex) break;
                throw new ClassCastException("Was expecting value of type Vertex for field 'vertex', but got " + value.getClass().getSimpleName());
            }
            case 2: {
                if (value instanceof Edge) break;
                throw new ClassCastException("Was expecting value of type Edge for field 'edge', but got " + value.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown field id " + setField);
            }
        }
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        this.setField_ = 0;
        this.value_ = null;
        iprot.readStructBegin(metaDataMap);
        TField field = iprot.readFieldBegin();
        if (field.type != 0) {
            this.value_ = this.readValue(iprot, field);
            if (this.value_ != null) {
                switch (field.id) {
                    case 1: {
                        if (field.type != PathEntry.VERTEX_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                        break;
                    }
                    case 2: {
                        if (field.type != PathEntry.EDGE_FIELD_DESC.type) break;
                        this.setField_ = field.id;
                    }
                }
            }
            iprot.readFieldEnd();
            iprot.readFieldBegin();
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
    }

    @Override
    protected Object readValue(TProtocol iprot, TField field) throws TException {
        switch (field.id) {
            case 1: {
                if (field.type == PathEntry.VERTEX_FIELD_DESC.type) {
                    Vertex vertex = new Vertex();
                    vertex.read(iprot);
                    return vertex;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
            case 2: {
                if (field.type == PathEntry.EDGE_FIELD_DESC.type) {
                    Edge edge = new Edge();
                    edge.read(iprot);
                    return edge;
                }
                TProtocolUtil.skip(iprot, field.type);
                return null;
            }
        }
        TProtocolUtil.skip(iprot, field.type);
        return null;
    }

    @Override
    protected void writeValue(TProtocol oprot, short setField, Object value) throws TException {
        switch (setField) {
            case 1: {
                Vertex vertex = (Vertex)this.getFieldValue();
                vertex.write(oprot);
                return;
            }
            case 2: {
                Edge edge = (Edge)this.getFieldValue();
                edge.write(oprot);
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + setField);
    }

    @Override
    protected TField getFieldDesc(int setField) {
        switch (setField) {
            case 1: {
                return VERTEX_FIELD_DESC;
            }
            case 2: {
                return EDGE_FIELD_DESC;
            }
        }
        throw new IllegalArgumentException("Unknown field id " + setField);
    }

    @Override
    protected TStruct getStructDesc() {
        return STRUCT_DESC;
    }

    public Vertex getVertex() {
        if (this.getSetField() == 1) {
            return (Vertex)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'vertex' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setVertex(Vertex value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = 1;
        this.value_ = value;
    }

    public Edge getEdge() {
        if (this.getSetField() == 2) {
            return (Edge)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'edge' because union is currently set to " + this.getFieldDesc((int)this.getSetField()).name);
    }

    public void setEdge(Edge value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = 2;
        this.value_ = value;
    }

    public boolean equals(Object other) {
        if (other instanceof PathEntry) {
            return this.equals((PathEntry)other);
        }
        return false;
    }

    public boolean equals(PathEntry other) {
        return this.equalsNobinaryImpl(other);
    }

    @Override
    public int compareTo(PathEntry other) {
        return this.compareToImpl(other);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getSetField()).append(this.getFieldValue()).toHashCode();
    }

    @Override
    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("PathEntry");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        if (this.getSetField() == 1) {
            sb.append(indentStr);
            sb.append("vertex");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getVertex() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getVertex(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.getSetField() == 2) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("edge");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getEdge() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getEdge(), indent + 1, prettyPrint));
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("vertex", 3, new StructMetaData(12, Vertex.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("edge", 3, new StructMetaData(12, Edge.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
    }
}

