/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.data;

import com.vesoft.nebula.data.PropertyDef;

public class Property {
    private PropertyDef def;
    private Object value;

    public Property(PropertyDef def, Object value) {
        this.def = def;
        this.value = value;
    }

    public Property(PropertyDef.PropertyType type, String name, Object value) {
        this(new PropertyDef(type, name), value);
    }

    public PropertyDef.PropertyType getPropertyType() {
        return this.def.getType();
    }

    public String getName() {
        return this.def.getName();
    }

    public Object getValue() {
        switch (this.def.getType()) {
            case BOOL: {
                return this.getValueAsBool();
            }
            case INT: 
            case VID: 
            case VERTEX_ID: 
            case SRC_ID: 
            case DST_ID: 
            case EDGE_RANK: {
                return this.getValueAsLong();
            }
            case TAG_ID: 
            case EDGE_TYPE: {
                return this.getValueAsInt();
            }
            case FLOAT: {
                return Float.valueOf(this.getValueAsFloat());
            }
            case DOUBLE: {
                return this.getValueAsDouble();
            }
            case STRING: {
                return this.getValueAsString();
            }
        }
        return null;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean getValueAsBool() {
        return (Boolean)this.value;
    }

    public int getValueAsInt() {
        return (Integer)this.value;
    }

    public long getValueAsLong() {
        return (Long)this.value;
    }

    public float getValueAsFloat() {
        return ((Float)this.value).floatValue();
    }

    public double getValueAsDouble() {
        return (Double)this.value;
    }

    public String getValueAsString() {
        return (String)this.value;
    }
}

