/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.async;

import com.facebook.thrift.TException;
import com.facebook.thrift.async.TAsyncClientManager;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.transport.TNonblockingSocket;
import com.facebook.thrift.transport.TTransportException;
import com.google.common.base.Optional;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.vesoft.nebula.client.graph.NGQLException;
import com.vesoft.nebula.client.graph.ResultSet;
import com.vesoft.nebula.client.graph.async.AsyncGraphClient;
import com.vesoft.nebula.client.graph.async.entry.AuthenticateCallback;
import com.vesoft.nebula.client.graph.async.entry.ExecuteCallback;
import com.vesoft.nebula.graph.AuthResponse;
import com.vesoft.nebula.graph.ExecutionResponse;
import com.vesoft.nebula.graph.GraphService;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncGraphClientImpl
extends AsyncGraphClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncGraphClientImpl.class);
    private long sessionID;
    private GraphService.AsyncClient client;
    private String user;
    private String password;

    public AsyncGraphClientImpl(List addresses, int timeout, int connectionRetry, int executionRetry) {
        super(addresses, timeout, connectionRetry, executionRetry);
    }

    public AsyncGraphClientImpl(List<HostAndPort> addresses) {
        super(addresses);
    }

    public AsyncGraphClientImpl(String host, int port) {
        super(host, port);
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int doConnect(List<HostAndPort> addresses) throws TException {
        Random random = new Random(System.currentTimeMillis());
        int position = random.nextInt(addresses.size());
        HostAndPort address = addresses.get(position);
        try {
            this.manager = new TAsyncClientManager();
            this.transport = new TNonblockingSocket(address.getHostText(), address.getPort(), this.timeout);
            TBinaryProtocol.Factory protocol = new TBinaryProtocol.Factory();
            this.client = new GraphService.AsyncClient(protocol, this.manager, this.transport);
            this.client.setTimeout(this.timeout);
            AuthenticateCallback callback = new AuthenticateCallback();
            this.client.authenticate(this.user, this.password, callback);
            Optional<?> respOption = Optional.absent();
            while (!callback.checkReady()) {
                respOption = callback.getResult();
            }
            if (!respOption.isPresent()) {
                LOGGER.info(String.format("Auth not founded", new Object[0]));
                return -2;
            }
            AuthResponse result = (AuthResponse)respOption.get();
            if (result.getError_code() == -4) {
                LOGGER.error("User name or password error");
                return -4;
            }
            if (result.getError_code() != 0) {
                LOGGER.error(String.format("Connect address %s failed : %s", address.toString(), result.getError_msg()));
                return -2;
            }
            this.sessionID = result.getSession_id();
            return 0;
        }
        catch (TTransportException tte) {
            LOGGER.error("Connect failed: " + tte.getMessage());
            return -2;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -2;
        }
        catch (TException e) {
            e.printStackTrace();
            return -2;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return -2;
    }

    @Override
    public ListenableFuture<Optional<Integer>> switchSpace(String space) {
        return this.execute(String.format("USE %s", space));
    }

    @Override
    public ListenableFuture<Optional<Integer>> execute(String statement) {
        return this.service.submit(() -> {
            ExecuteCallback callback = new ExecuteCallback();
            try {
                this.client.execute(this.sessionID, statement, callback);
            }
            catch (TException e) {
                e.printStackTrace();
            }
            while (!callback.checkReady()) {
                Thread.sleep(1L);
            }
            if (callback.getResult().isPresent()) {
                ExecutionResponse resp = (ExecutionResponse)callback.getResult().get();
                if (resp.getError_code() != 0) {
                    LOGGER.error("execute error: " + resp.getError_msg());
                }
                return Optional.of((Object)resp.getError_code());
            }
            return Optional.absent();
        });
    }

    @Override
    public ListenableFuture<Optional<ResultSet>> executeQuery(final String statement) {
        return this.service.submit((Callable)new Callable<Optional<ResultSet>>(){

            @Override
            public Optional<ResultSet> call() throws Exception {
                ExecuteCallback callback = new ExecuteCallback();
                try {
                    AsyncGraphClientImpl.this.client.execute(AsyncGraphClientImpl.this.sessionID, statement, callback);
                }
                catch (TException e) {
                    e.printStackTrace();
                }
                while (!callback.checkReady()) {
                    Thread.sleep(1L);
                }
                if (callback.getResult().isPresent()) {
                    ExecutionResponse resp = (ExecutionResponse)callback.getResult().get();
                    int code = resp.getError_code();
                    if (code == 0) {
                        ResultSet rs = new ResultSet(resp.getColumn_names(), resp.getRows());
                        return Optional.of((Object)rs);
                    }
                    LOGGER.error("Execute error: " + resp.getError_msg());
                    throw new NGQLException(code);
                }
                return Optional.absent();
            }
        });
    }

    @Override
    public void close() {
        this.service.shutdown();
        this.transport.close();
        try {
            this.manager.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

