/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift;

import com.facebook.thrift.TBase;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class TBaseHelper {
    private TBaseHelper() {
    }

    public static <T extends TBase & Comparable<T>> int compareTo(T a, T b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a == b) {
            return 0;
        }
        return ((Comparable<T>)a).compareTo(b);
    }

    public static int compareTo(boolean a, boolean b) {
        return a == b ? 0 : (a ? 1 : -1);
    }

    public static int compareTo(byte a, byte b) {
        if (a < b) {
            return -1;
        }
        if (b < a) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(short a, short b) {
        if (a < b) {
            return -1;
        }
        if (b < a) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(int a, int b) {
        if (a < b) {
            return -1;
        }
        if (b < a) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(long a, long b) {
        if (a < b) {
            return -1;
        }
        if (b < a) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(double a, double b) {
        if (a < b) {
            return -1;
        }
        if (b < a) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(float a, float b) {
        if (a < b) {
            return -1;
        }
        if (b < a) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(String a, String b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a == b) {
            return 0;
        }
        return a.compareTo(b);
    }

    public static int compareTo(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a == b) {
            return 0;
        }
        int sizeCompare = TBaseHelper.compareTo(a.length, b.length);
        if (sizeCompare != 0) {
            return sizeCompare;
        }
        for (int i = 0; i < a.length; ++i) {
            int byteCompare = TBaseHelper.compareTo(a[i], b[i]);
            if (byteCompare == 0) continue;
            return byteCompare;
        }
        return 0;
    }

    public static <T> int compareTo(List<T> a, List<T> b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a == b) {
            return 0;
        }
        int lastComparison = TBaseHelper.compareTo(a.size(), b.size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        NestedStructureComparator<T> comparator = NestedStructureComparator.get();
        Iterator<T> iterA = a.iterator();
        Iterator<T> iterB = b.iterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            lastComparison = comparator.compare(iterA.next(), iterB.next());
            if (lastComparison == 0) continue;
            return lastComparison;
        }
        assert (!iterA.hasNext() && !iterB.hasNext());
        return 0;
    }

    public static <T> int compareTo(Set<T> a, Set<T> b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a == b) {
            return 0;
        }
        int lastComparison = TBaseHelper.compareTo(a.size(), b.size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        NestedStructureComparator comparator = NestedStructureComparator.get();
        TreeSet sortedA = new TreeSet(comparator);
        sortedA.addAll(a);
        TreeSet sortedB = new TreeSet(comparator);
        sortedB.addAll(b);
        Iterator iterA = sortedA.iterator();
        Iterator iterB = sortedB.iterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            lastComparison = comparator.compare(iterA.next(), iterB.next());
            if (lastComparison == 0) continue;
            return lastComparison;
        }
        assert (!iterA.hasNext() && !iterB.hasNext());
        return 0;
    }

    public static <K, V> int compareTo(Map<K, V> a, Map<K, V> b) {
        int lastComparison = TBaseHelper.compareTo(a.size(), b.size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (a == b) {
            return 0;
        }
        NestedStructureComparator comparatorK = NestedStructureComparator.get();
        NestedStructureComparator comparatorV = NestedStructureComparator.get();
        TreeMap sortedA = new TreeMap(comparatorK);
        sortedA.putAll(a);
        TreeMap sortedB = new TreeMap(comparatorK);
        sortedB.putAll(b);
        Iterator iterA = sortedA.entrySet().iterator();
        Iterator iterB = sortedB.entrySet().iterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            Map.Entry entryA = iterA.next();
            Map.Entry entryB = iterB.next();
            lastComparison = comparatorK.compare(entryA.getKey(), entryB.getKey());
            if (lastComparison != 0) {
                return lastComparison;
            }
            lastComparison = comparatorV.compare(entryA.getValue(), entryB.getValue());
            if (lastComparison == 0) continue;
            return lastComparison;
        }
        assert (!iterA.hasNext() && !iterB.hasNext());
        return 0;
    }

    static int compareToUnchecked(Object a, Object b) {
        return NestedStructureComparator.get().compare(a, b);
    }

    public static void toString(ByteBuffer bb, StringBuilder sb) {
        byte[] buf = bb.array();
        int arrayOffset = bb.arrayOffset();
        int origLimit = bb.limit();
        int limit = origLimit - arrayOffset > 128 ? arrayOffset + 128 : origLimit;
        for (int i = arrayOffset; i < limit; ++i) {
            if (i > arrayOffset) {
                sb.append(" ");
            }
            sb.append(TBaseHelper.paddedByteString(buf[i]));
        }
        if (origLimit != limit) {
            sb.append("...");
        }
    }

    public static String paddedByteString(byte b) {
        int extended = (b | 0x100) & 0x1FF;
        return Integer.toHexString(extended).toUpperCase().substring(1);
    }

    public static byte[] byteBufferToByteArray(ByteBuffer byteBuffer) {
        if (TBaseHelper.wrapsFullArray(byteBuffer)) {
            return byteBuffer.array();
        }
        byte[] target = new byte[byteBuffer.remaining()];
        TBaseHelper.byteBufferToByteArray(byteBuffer, target, 0);
        return target;
    }

    public static boolean wrapsFullArray(ByteBuffer byteBuffer) {
        return byteBuffer.hasArray() && byteBuffer.position() == 0 && byteBuffer.arrayOffset() == 0 && byteBuffer.remaining() == byteBuffer.capacity();
    }

    public static int byteBufferToByteArray(ByteBuffer byteBuffer, byte[] target, int offset) {
        int remaining = byteBuffer.remaining();
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), target, offset, remaining);
        return remaining;
    }

    public static ByteBuffer rightSize(ByteBuffer in) {
        if (in == null) {
            return null;
        }
        if (TBaseHelper.wrapsFullArray(in)) {
            return in;
        }
        return ByteBuffer.wrap(TBaseHelper.byteBufferToByteArray(in));
    }

    public static byte[] deepCopy(byte[] orig) {
        if (orig == null) {
            return null;
        }
        return Arrays.copyOf(orig, orig.length);
    }

    public static String deepCopy(String orig) {
        return orig;
    }

    public static boolean deepCopy(boolean orig) {
        return orig;
    }

    public static Boolean deepCopy(Boolean orig) {
        return orig;
    }

    public static byte deepCopy(byte orig) {
        return orig;
    }

    public static Byte deepCopy(Byte orig) {
        return orig;
    }

    public static short deepCopy(short orig) {
        return orig;
    }

    public static Short deepCopy(Short orig) {
        return orig;
    }

    public static int deepCopy(int orig) {
        return orig;
    }

    public static Integer deepCopy(Integer orig) {
        return orig;
    }

    public static long deepCopy(long orig) {
        return orig;
    }

    public static Long deepCopy(Long orig) {
        return orig;
    }

    public static double deepCopy(double orig) {
        return orig;
    }

    public static Double deepCopy(Double orig) {
        return orig;
    }

    public static float deepCopy(float orig) {
        return orig;
    }

    public static Float deepCopy(Float orig) {
        return orig;
    }

    public static <K, V> Map<K, V> deepCopy(Map<K, V> orig) {
        if (orig == null) {
            return null;
        }
        HashMap<K, V> copy = new HashMap<K, V>(orig);
        for (Map.Entry<K, V> entry : orig.entrySet()) {
            copy.put(TBaseHelper.deepCopyUnchecked(entry.getKey()), TBaseHelper.deepCopyUnchecked(entry.getValue()));
        }
        return copy;
    }

    public static <T> List<T> deepCopy(List<T> orig) {
        if (orig == null) {
            return null;
        }
        ArrayList<T> copy = new ArrayList<T>();
        for (T item : orig) {
            copy.add(TBaseHelper.deepCopyUnchecked(item));
        }
        return copy;
    }

    public static <T> Set<T> deepCopy(Set<T> orig) {
        if (orig == null) {
            return null;
        }
        HashSet<T> copy = new HashSet<T>();
        for (T item : orig) {
            copy.add(TBaseHelper.deepCopyUnchecked(item));
        }
        return copy;
    }

    public static <T extends TBase> T deepCopy(T orig) {
        return (T)orig.deepCopy();
    }

    static <T> T deepCopyUnchecked(T orig) {
        if (orig == null) {
            return null;
        }
        if (orig instanceof byte[]) {
            return (T)TBaseHelper.deepCopy((byte[])orig);
        }
        if (orig instanceof String || orig instanceof Boolean || orig instanceof Byte || orig instanceof Short || orig instanceof Integer || orig instanceof Long || orig instanceof Double || orig instanceof Float) {
            return orig;
        }
        if (orig instanceof Map) {
            return (T)TBaseHelper.deepCopy((Map)orig);
        }
        if (orig instanceof List) {
            return (T)TBaseHelper.deepCopy((List)orig);
        }
        if (orig instanceof Set) {
            return (T)TBaseHelper.deepCopy((Set)orig);
        }
        if (orig instanceof TBase) {
            return (T)TBaseHelper.deepCopy((TBase)orig);
        }
        throw new UnsupportedOperationException("Don't know how to deepCopy something of type " + orig.getClass() + " which is weird because nothing should be calling me on something I don't understand");
    }

    public static boolean equalsNobinary(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equalsNobinary(String a, String b) {
        return a.equals(b);
    }

    public static boolean equalsNobinary(boolean a, boolean b) {
        return a == b;
    }

    public static boolean equalsNobinary(Boolean a, Boolean b) {
        return a.equals(b);
    }

    public static boolean equalsNobinary(byte a, byte b) {
        return a == b;
    }

    public static boolean equalsNobinary(Byte a, Byte b) {
        return a.equals(b);
    }

    public static boolean equalsNobinary(short a, short b) {
        return a == b;
    }

    public static boolean equalsNobinary(Short a, Short b) {
        return a.equals(b);
    }

    public static boolean equalsNobinary(int a, int b) {
        return a == b;
    }

    public static boolean equalsNobinary(Integer a, Integer b) {
        return a.equals(b);
    }

    public static boolean equalsNobinary(long a, long b) {
        return a == b;
    }

    public static boolean equalsNobinary(Long a, Long b) {
        return a.equals(b);
    }

    public static boolean equalsNobinary(double a, double b) {
        return a == b;
    }

    public static boolean equalsNobinary(Double a, Double b) {
        return a.equals(b);
    }

    public static boolean equalsNobinary(float a, float b) {
        return a == b;
    }

    public static boolean equalsNobinary(Float a, Float b) {
        return a.equals(b);
    }

    public static <K, V> boolean equalsNobinary(Map<K, V> as, Map<K, V> bs) {
        return as.equals(bs);
    }

    public static <T> boolean equalsNobinary(List<T> as, List<T> bs) {
        if (as == bs) {
            return true;
        }
        return as.equals(bs);
    }

    public static <T> boolean equalsNobinary(Set<T> as, Set<T> bs) {
        if (as == bs) {
            return true;
        }
        return as.equals(bs);
    }

    public static <T extends TBase> boolean equalsNobinary(T a, T b) {
        if (a == b) {
            return true;
        }
        return a.equals(b);
    }

    public static boolean equalsSlow(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    public static <K, V> boolean equalsSlow(Map<K, V> a, Map<K, V> b) {
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Map.Entry[] as = a.entrySet().toArray(new Map.Entry[a.size()]);
        int firstValidA = 0;
        for (Map.Entry<K, V> elemB : b.entrySet()) {
            boolean found = false;
            for (int i = firstValidA; i < as.length; ++i) {
                if (!TBaseHelper.equalsSlowUnchecked(as[i].getKey(), elemB.getKey()) || !TBaseHelper.equalsSlowUnchecked(as[i].getValue(), elemB.getValue())) continue;
                found = true;
                as[i] = as[firstValidA];
                ++firstValidA;
                break;
            }
            if (found) continue;
            return false;
        }
        assert (firstValidA == as.length);
        return true;
    }

    public static <T> boolean equalsSlow(List<T> a, List<T> b) {
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<T> iterA = a.iterator();
        Iterator<T> iterB = b.iterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            if (TBaseHelper.equalsNobinaryUnchecked(iterA.next(), iterB.next())) continue;
            return false;
        }
        assert (!iterA.hasNext() && !iterB.hasNext());
        return true;
    }

    public static <T> boolean equalsSlow(Set<T> a, Set<T> b) {
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Object[] as = a.toArray(new Object[a.size()]);
        int firstValidA = 0;
        for (T elemB : b) {
            boolean found = false;
            for (int i = firstValidA; i < as.length; ++i) {
                if (!TBaseHelper.equalsSlowUnchecked(as[i], elemB)) continue;
                found = true;
                as[i] = as[firstValidA];
                ++firstValidA;
                break;
            }
            if (found) continue;
            return false;
        }
        assert (firstValidA == as.length);
        return true;
    }

    static <T> boolean equalsNobinaryUnchecked(T a, T b) {
        if (a == b) {
            return true;
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return TBaseHelper.equalsSlow((byte[])a, (byte[])b);
        }
        if (a.getClass() == b.getClass() && (a instanceof String || a instanceof Boolean || a instanceof Byte || a instanceof Short || a instanceof Integer || a instanceof Long || a instanceof Double || a instanceof Float)) {
            return a.equals(b);
        }
        if (a instanceof TBase) {
            return a.equals(b);
        }
        if (a instanceof Map && b instanceof Map) {
            return TBaseHelper.equalsNobinary((Map)a, (Map)b);
        }
        if (a instanceof List && b instanceof List) {
            return TBaseHelper.equalsNobinary((List)a, (List)b);
        }
        if (a instanceof Set && b instanceof Set) {
            return TBaseHelper.equalsNobinary((Set)a, (Set)b);
        }
        throw new IllegalAccessError("Don't know how to compare " + a + " and " + b + " which is odd, because nothing should be calling me on types I don't understand");
    }

    static <T> boolean equalsSlowUnchecked(T a, T b) {
        if (a == b) {
            return true;
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return TBaseHelper.equalsSlow((byte[])a, (byte[])b);
        }
        if (a.getClass() == b.getClass() && (a instanceof String || a instanceof Boolean || a instanceof Byte || a instanceof Short || a instanceof Integer || a instanceof Long || a instanceof Double || a instanceof Float)) {
            return a.equals(b);
        }
        if (a instanceof TBase) {
            return a.equals(b);
        }
        if (a instanceof Map && b instanceof Map) {
            return TBaseHelper.equalsSlow((Map)a, (Map)b);
        }
        if (a instanceof List && b instanceof List) {
            return TBaseHelper.equalsSlow((List)a, (List)b);
        }
        if (a instanceof Set && b instanceof Set) {
            return TBaseHelper.equalsSlow((Set)a, (Set)b);
        }
        throw new IllegalAccessError("Don't know how to compare " + a + " and " + b + " which is odd, because nothing should be calling me on types I don't understand");
    }

    public static String getIndentedString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    public static String reduceIndent(String indentStr) {
        return indentStr.length() > 1 ? indentStr.substring(0, indentStr.length() - 2) : "";
    }

    public static String toString(Object obj, int indent, boolean prettyPrint) {
        if (obj == null) {
            return "";
        }
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder();
        try {
            if (obj instanceof Map) {
                sb.append("{");
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    sb.append(newLine + indentStr + TBaseHelper.toString(key, indent + 2, prettyPrint) + space + ":" + space + TBaseHelper.toString(val, indent + 2, prettyPrint));
                }
                sb.append(newLine + TBaseHelper.reduceIndent(indentStr) + "}");
            } else if (obj instanceof Collection) {
                sb.append("[");
                for (Object o : (Collection)obj) {
                    sb.append(newLine + indentStr + TBaseHelper.toString(o, indent + 2, prettyPrint));
                }
                sb.append(newLine + TBaseHelper.reduceIndent(indentStr) + "]");
            } else if (obj instanceof TBase) {
                sb.append(((TBase)obj).toString(indent, prettyPrint));
            } else if (obj instanceof String) {
                if (prettyPrint) {
                    sb.append("\"" + obj + "\"");
                } else {
                    sb.append(obj);
                }
            } else {
                sb.append(obj.toString());
            }
        }
        catch (RuntimeException re) {
            sb.append("Exception occured :" + re.getClass() + re.getMessage());
        }
        return sb.toString();
    }

    private static class NestedStructureComparator<T>
    implements Comparator<T> {
        private static final NestedStructureComparator<?> INSTANCE = new NestedStructureComparator();

        private NestedStructureComparator() {
        }

        @Override
        public int compare(T oA, T oB) {
            if (oA == oB) {
                return 0;
            }
            if (oA == null && oB == null) {
                return 0;
            }
            if (oA == null) {
                return -1;
            }
            if (oB == null) {
                return 1;
            }
            if (oA instanceof List && oB instanceof List) {
                return TBaseHelper.compareTo((List)oA, (List)oB);
            }
            if (oA instanceof Set && oB instanceof Set) {
                return TBaseHelper.compareTo((Set)oA, (Set)oB);
            }
            if (oA instanceof Map && oB instanceof Map) {
                return TBaseHelper.compareTo((Map)oA, (Map)oB);
            }
            if (oA instanceof byte[]) {
                return TBaseHelper.compareTo((byte[])oA, (byte[])oB);
            }
            if (oA.getClass() == oB.getClass() && (oA instanceof String || oA instanceof Boolean || oA instanceof Byte || oA instanceof Short || oA instanceof Integer || oA instanceof Long || oA instanceof Float || oA instanceof Double || oA instanceof TBase)) {
                return ((Comparable)oA).compareTo(oB);
            }
            throw new IllegalArgumentException("cannot compare " + oA + " and " + oB);
        }

        public static <T> NestedStructureComparator<T> get() {
            return INSTANCE;
        }
    }
}

