/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.EdgeData;
import com.vesoft.nebula.storage.TagData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class VertexData
implements TBase,
Serializable,
Cloneable,
Comparable<VertexData> {
    private static final TStruct STRUCT_DESC = new TStruct("VertexData");
    private static final TField VERTEX_ID_FIELD_DESC = new TField("vertex_id", 10, 1);
    private static final TField TAG_DATA_FIELD_DESC = new TField("tag_data", 15, 2);
    private static final TField EDGE_DATA_FIELD_DESC = new TField("edge_data", 15, 3);
    public long vertex_id;
    public List<TagData> tag_data;
    public List<EdgeData> edge_data;
    public static final int VERTEX_ID = 1;
    public static final int TAG_DATA = 2;
    public static final int EDGE_DATA = 3;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __VERTEX_ID_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public VertexData() {
    }

    public VertexData(long vertex_id, List<TagData> tag_data, List<EdgeData> edge_data) {
        this();
        this.vertex_id = vertex_id;
        this.setVertex_idIsSet(true);
        this.tag_data = tag_data;
        this.edge_data = edge_data;
    }

    public VertexData(VertexData other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.vertex_id = TBaseHelper.deepCopy(other.vertex_id);
        if (other.isSetTag_data()) {
            this.tag_data = TBaseHelper.deepCopy(other.tag_data);
        }
        if (other.isSetEdge_data()) {
            this.edge_data = TBaseHelper.deepCopy(other.edge_data);
        }
    }

    @Override
    public VertexData deepCopy() {
        return new VertexData(this);
    }

    @Deprecated
    public VertexData clone() {
        return new VertexData(this);
    }

    public long getVertex_id() {
        return this.vertex_id;
    }

    public VertexData setVertex_id(long vertex_id) {
        this.vertex_id = vertex_id;
        this.setVertex_idIsSet(true);
        return this;
    }

    public void unsetVertex_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetVertex_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setVertex_idIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public List<TagData> getTag_data() {
        return this.tag_data;
    }

    public VertexData setTag_data(List<TagData> tag_data) {
        this.tag_data = tag_data;
        return this;
    }

    public void unsetTag_data() {
        this.tag_data = null;
    }

    public boolean isSetTag_data() {
        return this.tag_data != null;
    }

    public void setTag_dataIsSet(boolean value) {
        if (!value) {
            this.tag_data = null;
        }
    }

    public List<EdgeData> getEdge_data() {
        return this.edge_data;
    }

    public VertexData setEdge_data(List<EdgeData> edge_data) {
        this.edge_data = edge_data;
        return this;
    }

    public void unsetEdge_data() {
        this.edge_data = null;
    }

    public boolean isSetEdge_data() {
        return this.edge_data != null;
    }

    public void setEdge_dataIsSet(boolean value) {
        if (!value) {
            this.edge_data = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetVertex_id();
                    break;
                }
                this.setVertex_id((Long)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetTag_data();
                    break;
                }
                this.setTag_data((List)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetEdge_data();
                    break;
                }
                this.setEdge_data((List)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Long(this.getVertex_id());
            }
            case 2: {
                return this.getTag_data();
            }
            case 3: {
                return this.getEdge_data();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetVertex_id();
            }
            case 2: {
                return this.isSetTag_data();
            }
            case 3: {
                return this.isSetEdge_data();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof VertexData) {
            return this.equals((VertexData)that);
        }
        return false;
    }

    public boolean equals(VertexData that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_vertex_id = true;
        boolean that_present_vertex_id = true;
        if (this_present_vertex_id || that_present_vertex_id) {
            if (!this_present_vertex_id || !that_present_vertex_id) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.vertex_id, that.vertex_id)) {
                return false;
            }
        }
        boolean this_present_tag_data = this.isSetTag_data();
        boolean that_present_tag_data = that.isSetTag_data();
        if (this_present_tag_data || that_present_tag_data) {
            if (!this_present_tag_data || !that_present_tag_data) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.tag_data, that.tag_data)) {
                return false;
            }
        }
        boolean this_present_edge_data = this.isSetEdge_data();
        boolean that_present_edge_data = that.isSetEdge_data();
        if (this_present_edge_data || that_present_edge_data) {
            if (!this_present_edge_data || !that_present_edge_data) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.edge_data, that.edge_data)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_vertex_id = true;
        builder.append(present_vertex_id);
        if (present_vertex_id) {
            builder.append(this.vertex_id);
        }
        boolean present_tag_data = this.isSetTag_data();
        builder.append(present_tag_data);
        if (present_tag_data) {
            builder.append(this.tag_data);
        }
        boolean present_edge_data = this.isSetEdge_data();
        builder.append(present_edge_data);
        if (present_edge_data) {
            builder.append(this.edge_data);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(VertexData other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetVertex_id()).compareTo(other.isSetVertex_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.vertex_id, other.vertex_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTag_data()).compareTo(other.isSetTag_data());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.tag_data, other.tag_data);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEdge_data()).compareTo(other.isSetEdge_data());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.edge_data, other.edge_data);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 10) {
                        this.vertex_id = iprot.readI64();
                        this.setVertex_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list4 = iprot.readListBegin();
                        this.tag_data = new ArrayList<TagData>(Math.max(0, _list4.size));
                        int _i5 = 0;
                        while (_list4.size < 0 ? iprot.peekList() : _i5 < _list4.size) {
                            TagData _elem6 = new TagData();
                            _elem6.read(iprot);
                            this.tag_data.add(_elem6);
                            ++_i5;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 15) {
                        TList _list7 = iprot.readListBegin();
                        this.edge_data = new ArrayList<EdgeData>(Math.max(0, _list7.size));
                        int _i8 = 0;
                        while (_list7.size < 0 ? iprot.peekList() : _i8 < _list7.size) {
                            EdgeData _elem9 = new EdgeData();
                            _elem9.read(iprot);
                            this.edge_data.add(_elem9);
                            ++_i8;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(VERTEX_ID_FIELD_DESC);
        oprot.writeI64(this.vertex_id);
        oprot.writeFieldEnd();
        if (this.tag_data != null) {
            oprot.writeFieldBegin(TAG_DATA_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.tag_data.size()));
            for (TagData _iter10 : this.tag_data) {
                _iter10.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.edge_data != null) {
            oprot.writeFieldBegin(EDGE_DATA_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.edge_data.size()));
            for (EdgeData _iter11 : this.edge_data) {
                _iter11.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("VertexData");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("vertex_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getVertex_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("tag_data");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getTag_data() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getTag_data(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("edge_data");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getEdge_data() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getEdge_data(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("vertex_id", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(2, new FieldMetaData("tag_data", 3, new ListMetaData(15, new StructMetaData(12, TagData.class))));
        tmpMetaDataMap.put(3, new FieldMetaData("edge_data", 3, new ListMetaData(15, new StructMetaData(12, EdgeData.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(VertexData.class, metaDataMap);
    }
}

