/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ScanVertex
implements TBase,
Serializable,
Cloneable,
Comparable<ScanVertex> {
    private static final TStruct STRUCT_DESC = new TStruct("ScanVertex");
    private static final TField VERTEX_ID_FIELD_DESC = new TField("vertexId", 10, 1);
    private static final TField TAG_ID_FIELD_DESC = new TField("tagId", 8, 2);
    private static final TField VALUE_FIELD_DESC = new TField("value", 11, 3);
    public long vertexId;
    public int tagId;
    public byte[] value;
    public static final int VERTEXID = 1;
    public static final int TAGID = 2;
    public static final int VALUE = 3;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __VERTEXID_ISSET_ID = 0;
    private static final int __TAGID_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ScanVertex() {
    }

    public ScanVertex(long vertexId, int tagId, byte[] value) {
        this();
        this.vertexId = vertexId;
        this.setVertexIdIsSet(true);
        this.tagId = tagId;
        this.setTagIdIsSet(true);
        this.value = value;
    }

    public ScanVertex(ScanVertex other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.vertexId = TBaseHelper.deepCopy(other.vertexId);
        this.tagId = TBaseHelper.deepCopy(other.tagId);
        if (other.isSetValue()) {
            this.value = TBaseHelper.deepCopy(other.value);
        }
    }

    @Override
    public ScanVertex deepCopy() {
        return new ScanVertex(this);
    }

    @Deprecated
    public ScanVertex clone() {
        return new ScanVertex(this);
    }

    public long getVertexId() {
        return this.vertexId;
    }

    public ScanVertex setVertexId(long vertexId) {
        this.vertexId = vertexId;
        this.setVertexIdIsSet(true);
        return this;
    }

    public void unsetVertexId() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetVertexId() {
        return this.__isset_bit_vector.get(0);
    }

    public void setVertexIdIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public int getTagId() {
        return this.tagId;
    }

    public ScanVertex setTagId(int tagId) {
        this.tagId = tagId;
        this.setTagIdIsSet(true);
        return this;
    }

    public void unsetTagId() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetTagId() {
        return this.__isset_bit_vector.get(1);
    }

    public void setTagIdIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public byte[] getValue() {
        return this.value;
    }

    public ScanVertex setValue(byte[] value) {
        this.value = value;
        return this;
    }

    public void unsetValue() {
        this.value = null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValueIsSet(boolean value) {
        if (!value) {
            this.value = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetVertexId();
                    break;
                }
                this.setVertexId((Long)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetTagId();
                    break;
                }
                this.setTagId((Integer)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetValue();
                    break;
                }
                this.setValue((byte[])value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Long(this.getVertexId());
            }
            case 2: {
                return new Integer(this.getTagId());
            }
            case 3: {
                return this.getValue();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetVertexId();
            }
            case 2: {
                return this.isSetTagId();
            }
            case 3: {
                return this.isSetValue();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ScanVertex) {
            return this.equals((ScanVertex)that);
        }
        return false;
    }

    public boolean equals(ScanVertex that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_vertexId = true;
        boolean that_present_vertexId = true;
        if (this_present_vertexId || that_present_vertexId) {
            if (!this_present_vertexId || !that_present_vertexId) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.vertexId, that.vertexId)) {
                return false;
            }
        }
        boolean this_present_tagId = true;
        boolean that_present_tagId = true;
        if (this_present_tagId || that_present_tagId) {
            if (!this_present_tagId || !that_present_tagId) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.tagId, that.tagId)) {
                return false;
            }
        }
        boolean this_present_value = this.isSetValue();
        boolean that_present_value = that.isSetValue();
        if (this_present_value || that_present_value) {
            if (!this_present_value || !that_present_value) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.value, that.value)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_vertexId = true;
        builder.append(present_vertexId);
        if (present_vertexId) {
            builder.append(this.vertexId);
        }
        boolean present_tagId = true;
        builder.append(present_tagId);
        if (present_tagId) {
            builder.append(this.tagId);
        }
        boolean present_value = this.isSetValue();
        builder.append(present_value);
        if (present_value) {
            builder.append(this.value);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(ScanVertex other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetVertexId()).compareTo(other.isSetVertexId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.vertexId, other.vertexId);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTagId()).compareTo(other.isSetTagId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.tagId, other.tagId);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(other.isSetValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.value, other.value);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 10) {
                        this.vertexId = iprot.readI64();
                        this.setVertexIdIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 8) {
                        this.tagId = iprot.readI32();
                        this.setTagIdIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 11) {
                        this.value = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(VERTEX_ID_FIELD_DESC);
        oprot.writeI64(this.vertexId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(TAG_ID_FIELD_DESC);
        oprot.writeI32(this.tagId);
        oprot.writeFieldEnd();
        if (this.value != null) {
            oprot.writeFieldBegin(VALUE_FIELD_DESC);
            oprot.writeBinary(this.value);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ScanVertex");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("vertexId");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getVertexId(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("tagId");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getTagId(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("value");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getValue() == null) {
            sb.append("null");
        } else {
            int __value_size = Math.min(this.getValue().length, 128);
            for (int i = 0; i < __value_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getValue()[i]).length() > 1 ? Integer.toHexString(this.getValue()[i]).substring(Integer.toHexString(this.getValue()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getValue()[i]).toUpperCase());
            }
            if (this.getValue().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("vertexId", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(2, new FieldMetaData("tagId", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(3, new FieldMetaData("value", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ScanVertex.class, metaDataMap);
    }
}

