/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.EdgeKey;
import com.vesoft.nebula.storage.PropDef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class EdgePropRequest
implements TBase,
Serializable,
Cloneable,
Comparable<EdgePropRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("EdgePropRequest");
    private static final TField SPACE_ID_FIELD_DESC = new TField("space_id", 8, 1);
    private static final TField PARTS_FIELD_DESC = new TField("parts", 13, 2);
    private static final TField EDGE_TYPE_FIELD_DESC = new TField("edge_type", 8, 3);
    private static final TField FILTER_FIELD_DESC = new TField("filter", 11, 4);
    private static final TField RETURN_COLUMNS_FIELD_DESC = new TField("return_columns", 15, 5);
    public int space_id;
    public Map<Integer, List<EdgeKey>> parts;
    public int edge_type;
    public byte[] filter;
    public List<PropDef> return_columns;
    public static final int SPACE_ID = 1;
    public static final int PARTS = 2;
    public static final int EDGE_TYPE = 3;
    public static final int FILTER = 4;
    public static final int RETURN_COLUMNS = 5;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __SPACE_ID_ISSET_ID = 0;
    private static final int __EDGE_TYPE_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public EdgePropRequest() {
    }

    public EdgePropRequest(int space_id, Map<Integer, List<EdgeKey>> parts, int edge_type, byte[] filter, List<PropDef> return_columns) {
        this();
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        this.parts = parts;
        this.edge_type = edge_type;
        this.setEdge_typeIsSet(true);
        this.filter = filter;
        this.return_columns = return_columns;
    }

    public EdgePropRequest(EdgePropRequest other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.space_id = TBaseHelper.deepCopy(other.space_id);
        if (other.isSetParts()) {
            this.parts = TBaseHelper.deepCopy(other.parts);
        }
        this.edge_type = TBaseHelper.deepCopy(other.edge_type);
        if (other.isSetFilter()) {
            this.filter = TBaseHelper.deepCopy(other.filter);
        }
        if (other.isSetReturn_columns()) {
            this.return_columns = TBaseHelper.deepCopy(other.return_columns);
        }
    }

    @Override
    public EdgePropRequest deepCopy() {
        return new EdgePropRequest(this);
    }

    @Deprecated
    public EdgePropRequest clone() {
        return new EdgePropRequest(this);
    }

    public int getSpace_id() {
        return this.space_id;
    }

    public EdgePropRequest setSpace_id(int space_id) {
        this.space_id = space_id;
        this.setSpace_idIsSet(true);
        return this;
    }

    public void unsetSpace_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetSpace_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setSpace_idIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public Map<Integer, List<EdgeKey>> getParts() {
        return this.parts;
    }

    public EdgePropRequest setParts(Map<Integer, List<EdgeKey>> parts) {
        this.parts = parts;
        return this;
    }

    public void unsetParts() {
        this.parts = null;
    }

    public boolean isSetParts() {
        return this.parts != null;
    }

    public void setPartsIsSet(boolean value) {
        if (!value) {
            this.parts = null;
        }
    }

    public int getEdge_type() {
        return this.edge_type;
    }

    public EdgePropRequest setEdge_type(int edge_type) {
        this.edge_type = edge_type;
        this.setEdge_typeIsSet(true);
        return this;
    }

    public void unsetEdge_type() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetEdge_type() {
        return this.__isset_bit_vector.get(1);
    }

    public void setEdge_typeIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public byte[] getFilter() {
        return this.filter;
    }

    public EdgePropRequest setFilter(byte[] filter) {
        this.filter = filter;
        return this;
    }

    public void unsetFilter() {
        this.filter = null;
    }

    public boolean isSetFilter() {
        return this.filter != null;
    }

    public void setFilterIsSet(boolean value) {
        if (!value) {
            this.filter = null;
        }
    }

    public List<PropDef> getReturn_columns() {
        return this.return_columns;
    }

    public EdgePropRequest setReturn_columns(List<PropDef> return_columns) {
        this.return_columns = return_columns;
        return this;
    }

    public void unsetReturn_columns() {
        this.return_columns = null;
    }

    public boolean isSetReturn_columns() {
        return this.return_columns != null;
    }

    public void setReturn_columnsIsSet(boolean value) {
        if (!value) {
            this.return_columns = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetSpace_id();
                    break;
                }
                this.setSpace_id((Integer)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetParts();
                    break;
                }
                this.setParts((Map)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetEdge_type();
                    break;
                }
                this.setEdge_type((Integer)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetFilter();
                    break;
                }
                this.setFilter((byte[])value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetReturn_columns();
                    break;
                }
                this.setReturn_columns((List)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Integer(this.getSpace_id());
            }
            case 2: {
                return this.getParts();
            }
            case 3: {
                return new Integer(this.getEdge_type());
            }
            case 4: {
                return this.getFilter();
            }
            case 5: {
                return this.getReturn_columns();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetSpace_id();
            }
            case 2: {
                return this.isSetParts();
            }
            case 3: {
                return this.isSetEdge_type();
            }
            case 4: {
                return this.isSetFilter();
            }
            case 5: {
                return this.isSetReturn_columns();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof EdgePropRequest) {
            return this.equals((EdgePropRequest)that);
        }
        return false;
    }

    public boolean equals(EdgePropRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_space_id = true;
        boolean that_present_space_id = true;
        if (this_present_space_id || that_present_space_id) {
            if (!this_present_space_id || !that_present_space_id) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.space_id, that.space_id)) {
                return false;
            }
        }
        boolean this_present_parts = this.isSetParts();
        boolean that_present_parts = that.isSetParts();
        if (this_present_parts || that_present_parts) {
            if (!this_present_parts || !that_present_parts) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.parts, that.parts)) {
                return false;
            }
        }
        boolean this_present_edge_type = true;
        boolean that_present_edge_type = true;
        if (this_present_edge_type || that_present_edge_type) {
            if (!this_present_edge_type || !that_present_edge_type) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.edge_type, that.edge_type)) {
                return false;
            }
        }
        boolean this_present_filter = this.isSetFilter();
        boolean that_present_filter = that.isSetFilter();
        if (this_present_filter || that_present_filter) {
            if (!this_present_filter || !that_present_filter) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.filter, that.filter)) {
                return false;
            }
        }
        boolean this_present_return_columns = this.isSetReturn_columns();
        boolean that_present_return_columns = that.isSetReturn_columns();
        if (this_present_return_columns || that_present_return_columns) {
            if (!this_present_return_columns || !that_present_return_columns) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.return_columns, that.return_columns)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_space_id = true;
        builder.append(present_space_id);
        if (present_space_id) {
            builder.append(this.space_id);
        }
        boolean present_parts = this.isSetParts();
        builder.append(present_parts);
        if (present_parts) {
            builder.append(this.parts);
        }
        boolean present_edge_type = true;
        builder.append(present_edge_type);
        if (present_edge_type) {
            builder.append(this.edge_type);
        }
        boolean present_filter = this.isSetFilter();
        builder.append(present_filter);
        if (present_filter) {
            builder.append(this.filter);
        }
        boolean present_return_columns = this.isSetReturn_columns();
        builder.append(present_return_columns);
        if (present_return_columns) {
            builder.append(this.return_columns);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(EdgePropRequest other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetSpace_id()).compareTo(other.isSetSpace_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.space_id, other.space_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParts()).compareTo(other.isSetParts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.parts, other.parts);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEdge_type()).compareTo(other.isSetEdge_type());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.edge_type, other.edge_type);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFilter()).compareTo(other.isSetFilter());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.filter, other.filter);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReturn_columns()).compareTo(other.isSetReturn_columns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.return_columns, other.return_columns);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.space_id = iprot.readI32();
                        this.setSpace_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 13) {
                        TMap _map68 = iprot.readMapBegin();
                        this.parts = new HashMap<Integer, List<EdgeKey>>(Math.max(0, 2 * _map68.size));
                        int _i69 = 0;
                        while (_map68.size < 0 ? iprot.peekMap() : _i69 < _map68.size) {
                            int _key70 = iprot.readI32();
                            TList _list72 = iprot.readListBegin();
                            ArrayList<EdgeKey> _val71 = new ArrayList<EdgeKey>(Math.max(0, _list72.size));
                            int _i73 = 0;
                            while (_list72.size < 0 ? iprot.peekList() : _i73 < _list72.size) {
                                EdgeKey _elem74 = new EdgeKey();
                                _elem74.read(iprot);
                                _val71.add(_elem74);
                                ++_i73;
                            }
                            iprot.readListEnd();
                            this.parts.put(_key70, _val71);
                            ++_i69;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 8) {
                        this.edge_type = iprot.readI32();
                        this.setEdge_typeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 11) {
                        this.filter = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 5: {
                    if (field.type == 15) {
                        TList _list75 = iprot.readListBegin();
                        this.return_columns = new ArrayList<PropDef>(Math.max(0, _list75.size));
                        int _i76 = 0;
                        while (_list75.size < 0 ? iprot.peekList() : _i76 < _list75.size) {
                            PropDef _elem77 = new PropDef();
                            _elem77.read(iprot);
                            this.return_columns.add(_elem77);
                            ++_i76;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SPACE_ID_FIELD_DESC);
        oprot.writeI32(this.space_id);
        oprot.writeFieldEnd();
        if (this.parts != null) {
            oprot.writeFieldBegin(PARTS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 15, this.parts.size()));
            for (Map.Entry<Integer, List<EdgeKey>> _iter78 : this.parts.entrySet()) {
                oprot.writeI32(_iter78.getKey());
                oprot.writeListBegin(new TList(12, _iter78.getValue().size()));
                for (EdgeKey _iter79 : _iter78.getValue()) {
                    _iter79.write(oprot);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(EDGE_TYPE_FIELD_DESC);
        oprot.writeI32(this.edge_type);
        oprot.writeFieldEnd();
        if (this.filter != null) {
            oprot.writeFieldBegin(FILTER_FIELD_DESC);
            oprot.writeBinary(this.filter);
            oprot.writeFieldEnd();
        }
        if (this.return_columns != null) {
            oprot.writeFieldBegin(RETURN_COLUMNS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.return_columns.size()));
            for (PropDef _iter80 : this.return_columns) {
                _iter80.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("EdgePropRequest");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("space_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getSpace_id(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("parts");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getParts() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getParts(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("edge_type");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getEdge_type(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("filter");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getFilter() == null) {
            sb.append("null");
        } else {
            int __filter_size = Math.min(this.getFilter().length, 128);
            for (int i = 0; i < __filter_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getFilter()[i]).length() > 1 ? Integer.toHexString(this.getFilter()[i]).substring(Integer.toHexString(this.getFilter()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getFilter()[i]).toUpperCase());
            }
            if (this.getFilter().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("return_columns");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getReturn_columns() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getReturn_columns(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("space_id", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("parts", 3, new MapMetaData(13, new FieldValueMetaData(8), new ListMetaData(15, new StructMetaData(12, EdgeKey.class)))));
        tmpMetaDataMap.put(3, new FieldMetaData("edge_type", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(4, new FieldMetaData("filter", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(5, new FieldMetaData("return_columns", 3, new ListMetaData(15, new StructMetaData(12, PropDef.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(EdgePropRequest.class, metaDataMap);
    }
}

