/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.vesoft.nebula.session.Session;
import java.util.List;

public class Cluster {
    public Session build() {
        return null;
    }

    public class Builder {
        private final List<HostAndPort> addresses = Lists.newLinkedList();
        private String user;
        private String password;
        private long connectionTimeout;
        private int connectionRetry;
        private int executionRetry;
        private Type type;

        public Builder addNode(String host, int port) {
            for (HostAndPort address : this.addresses) {
                if (!address.getHost().equals(host) || address.getPort() != port) continue;
                throw new IllegalArgumentException("Address have duplicate");
            }
            this.addresses.add(HostAndPort.fromParts((String)host, (int)port));
            return this;
        }

        public Builder withUser(String user) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)user) ? 1 : 0) != 0);
            this.user = user;
            return this;
        }

        public Builder withPassword(String password) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)password) ? 1 : 0) != 0);
            this.password = password;
            return this;
        }

        public Builder withConnectionTimeout(long timeout) {
            Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
            this.connectionTimeout = timeout;
            return this;
        }

        public Builder withConnectionRetry(int retry) {
            Preconditions.checkArgument((retry > 0 ? 1 : 0) != 0);
            this.connectionRetry = retry;
            return this;
        }

        public Builder withExecutionRetry(int retry) {
            Preconditions.checkArgument((retry > 0 ? 1 : 0) != 0);
            this.executionRetry = retry;
            return this;
        }

        public Builder withMeta() {
            this.type = Type.META;
            return this;
        }

        public Builder withStorage() {
            this.type = Type.STORAGE;
            return this;
        }

        public Builder withGraph() {
            this.type = Type.GRAPH;
            return this;
        }

        public Cluster build() {
            Cluster cluster = new Cluster();
            return cluster;
        }
    }

    private static enum Type {
        META,
        STORAGE,
        GRAPH;

    }
}

