/*
 * Decompiled with CFR 0.152.
 */
package com.verygoodsecurity.vgsshow.util.url;

import com.verygoodsecurity.vgsshow.core.VGSEnvironment;
import com.verygoodsecurity.vgsshow.util.extension.LogKt;
import com.verygoodsecurity.vgsshow.util.extension.ValidatorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/verygoodsecurity/vgsshow/util/url/UrlHelper;", "", "()V", "EMPTY", "", "HTTPS_SCHEME", "HTTP_SCHEME", "PROXY_PORT_DIVIDER", "PROXY_URL_DIVIDER", "PROXY_URL_DOMEN", "buildLocalhostUrl", "localhost", "port", "", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/String;", "buildProxyUrl", "vaultId", "environment", "Lcom/verygoodsecurity/vgsshow/core/VGSEnvironment;", "vgsshow_release"})
public final class UrlHelper {
    private static final String HTTPS_SCHEME = "https://";
    private static final String HTTP_SCHEME = "http://";
    private static final String PROXY_URL_DOMEN = "verygoodproxy.com";
    private static final String PROXY_URL_DIVIDER = ".";
    private static final String PROXY_PORT_DIVIDER = ":";
    private static final String EMPTY = "";
    @NotNull
    public static final UrlHelper INSTANCE;

    @NotNull
    public final String buildLocalhostUrl(@NotNull String localhost, @Nullable Integer port) {
        String string;
        Intrinsics.checkNotNullParameter((Object)localhost, (String)"localhost");
        if (!ValidatorKt.isValidPort(port)) {
            LogKt.logWaring$default(this, "Port is not specified", null, 2, null);
            string = EMPTY;
        } else {
            string = EMPTY + ':' + port;
        }
        String prt = string;
        String string2 = HTTP_SCHEME + localhost + prt;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder(HTTP_SCHEM\u2026)\n            .toString()");
        return string2;
    }

    @NotNull
    public final String buildProxyUrl(@NotNull String vaultId, @NotNull VGSEnvironment environment) {
        String string;
        Intrinsics.checkNotNullParameter((Object)vaultId, (String)"vaultId");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (!ValidatorKt.isValidTenantId(vaultId)) {
            LogKt.logWaring$default(this, "VaultId(" + vaultId + ") is not valid", null, 2, null);
            string = EMPTY;
        } else if (!VGSEnvironment.Companion.isValid(environment)) {
            LogKt.logWaring$default(this, "Environment(" + environment + ") is not valid", null, 2, null);
            string = EMPTY;
        } else {
            String string2 = HTTPS_SCHEME + vaultId + PROXY_URL_DIVIDER + environment.getValue() + PROXY_URL_DIVIDER + PROXY_URL_DOMEN;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder(HTTPS_SCHE\u2026)\n            .toString()");
        }
        return string;
    }

    private UrlHelper() {
    }

    static {
        UrlHelper urlHelper;
        INSTANCE = urlHelper = new UrlHelper();
    }
}

