/*
 * Decompiled with CFR 0.152.
 */
package com.verygoodsecurity.vgsshow.util.extension;

import androidx.core.util.PatternsCompat;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0001H\u0000\u001a\f\u0010\n\u001a\u00020\t*\u00020\u0001H\u0000\u001a\u0013\u0010\u000b\u001a\u00020\t*\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\u0010\r\u001a\f\u0010\u000e\u001a\u00020\t*\u00020\u0001H\u0000\u001a\f\u0010\u000f\u001a\u00020\t*\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"AVD_LOCALHOST_ALIAS", "", "GENYMOTION_LOCALHOST_ALIAS", "PORT_MAX_VALUE", "", "PORT_MIN_VALUE", "PRIVATE_NETWORK_IP_PREFIX", "TENANT_ID_REGEX", "isIpAllowed", "", "isValidIp", "isValidPort", "", "(Ljava/lang/Integer;)Z", "isValidTenantId", "isValidUrl", "vgsshow_release"})
public final class ValidatorKt {
    private static final String TENANT_ID_REGEX = "^[a-zA-Z0-9]+$";
    private static final String AVD_LOCALHOST_ALIAS = "10.0.2.2";
    private static final String GENYMOTION_LOCALHOST_ALIAS = "10.0.3.2";
    private static final String PRIVATE_NETWORK_IP_PREFIX = "192.168.";
    public static final long PORT_MIN_VALUE = 1L;
    public static final long PORT_MAX_VALUE = 65353L;

    public static final boolean isValidTenantId(@NotNull String $this$isValidTenantId) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidTenantId, (String)"$this$isValidTenantId");
        return Pattern.compile(TENANT_ID_REGEX).matcher($this$isValidTenantId).matches();
    }

    public static final boolean isValidUrl(@NotNull String $this$isValidUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidUrl, (String)"$this$isValidUrl");
        return StringsKt.isBlank((CharSequence)$this$isValidUrl) ? false : PatternsCompat.WEB_URL.matcher($this$isValidUrl).matches();
    }

    public static final boolean isValidIp(@NotNull String $this$isValidIp) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidIp, (String)"$this$isValidIp");
        CharSequence charSequence = $this$isValidIp;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence.length() == 0 ? false : PatternsCompat.IP_ADDRESS.matcher($this$isValidIp).matches();
    }

    public static final boolean isIpAllowed(@NotNull String $this$isIpAllowed) {
        Intrinsics.checkNotNullParameter((Object)$this$isIpAllowed, (String)"$this$isIpAllowed");
        return Intrinsics.areEqual((Object)$this$isIpAllowed, (Object)AVD_LOCALHOST_ALIAS) || Intrinsics.areEqual((Object)$this$isIpAllowed, (Object)GENYMOTION_LOCALHOST_ALIAS) || StringsKt.startsWith$default((String)$this$isIpAllowed, (String)PRIVATE_NETWORK_IP_PREFIX, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValidPort(@Nullable Integer $this$isValidPort) {
        if ($this$isValidPort == null) return false;
        long l = $this$isValidPort.intValue();
        if (1L > l) return false;
        if (65353L < l) return false;
        return true;
    }
}

