/*
 * Decompiled with CFR 0.152.
 */
package com.verygoodsecurity.vgsshow.core.network.client.okhttp;

import androidx.annotation.RequiresApi;
import com.verygoodsecurity.vgsshow.core.network.client.BaseHttpClient;
import com.verygoodsecurity.vgsshow.core.network.client.HttpRequestCallback;
import com.verygoodsecurity.vgsshow.core.network.client.extension.OkHttpConnectionKt;
import com.verygoodsecurity.vgsshow.core.network.client.model.HttpRequest;
import com.verygoodsecurity.vgsshow.core.network.client.model.HttpResponse;
import com.verygoodsecurity.vgsshow.core.network.client.okhttp.OkHttpClient;
import com.verygoodsecurity.vgsshow.core.network.client.okhttp.interceptor.CnameInterceptor;
import com.verygoodsecurity.vgsshow.core.network.extension.MapperKt;
import com.verygoodsecurity.vgsshow.core.network.model.data.request.RequestData;
import com.verygoodsecurity.vgsshow.util.extension.LogKt;
import com.verygoodsecurity.vgsshow.util.extension.MapKt;
import com.verygoodsecurity.vgsshow.util.extension.StringKt;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J4\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00150 H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/verygoodsecurity/vgsshow/core/network/client/okhttp/OkHttpClient;", "Lcom/verygoodsecurity/vgsshow/core/network/client/BaseHttpClient;", "isLogsEnabled", "", "(Z)V", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "cnameInterceptor", "Lcom/verygoodsecurity/vgsshow/core/network/client/okhttp/interceptor/CnameInterceptor;", "getCnameInterceptor", "()Lcom/verygoodsecurity/vgsshow/core/network/client/okhttp/interceptor/CnameInterceptor;", "cnameInterceptor$delegate", "buildOkHttpRequest", "Lokhttp3/Request;", "request", "Lcom/verygoodsecurity/vgsshow/core/network/client/model/HttpRequest;", "cancelAll", "", "enqueue", "callback", "Lcom/verygoodsecurity/vgsshow/core/network/client/HttpRequestCallback;", "execute", "Lcom/verygoodsecurity/vgsshow/core/network/client/model/HttpResponse;", "setCname", "vaultId", "", "cname", "cnameResult", "Lkotlin/Function2;", "", "LoggingInterceptor", "vgsshow_release"})
@RequiresApi(api=21)
public final class OkHttpClient
extends BaseHttpClient {
    private final Lazy cnameInterceptor$delegate = LazyKt.lazy((Function0)cnameInterceptor.2.INSTANCE);
    private final Lazy client$delegate;

    private final CnameInterceptor getCnameInterceptor() {
        Lazy lazy = this.cnameInterceptor$delegate;
        OkHttpClient okHttpClient = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CnameInterceptor)lazy.getValue();
    }

    private final okhttp3.OkHttpClient getClient() {
        Lazy lazy = this.client$delegate;
        OkHttpClient okHttpClient = this;
        Object var3_3 = null;
        boolean bl = false;
        return (okhttp3.OkHttpClient)lazy.getValue();
    }

    @Override
    @NotNull
    public HttpResponse execute(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return MapperKt.toHttpResponse(this.getClient().newCall(this.buildOkHttpRequest(request)).execute());
    }

    @Override
    public void enqueue(@NotNull HttpRequest request, @NotNull HttpRequestCallback callback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        try {
            this.getClient().newCall(this.buildOkHttpRequest(request)).enqueue(new Callback(callback){
                final /* synthetic */ HttpRequestCallback $callback;

                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$callback.onFailure(e);
                    LogKt.logException$default(this, e, null, 2, null);
                }

                public void onResponse(@NotNull Call call, @NotNull Response response) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    this.$callback.onResponse(MapperKt.toHttpResponse(response));
                }
                {
                    this.$callback = $captured_local_variable$0;
                }
            });
        }
        catch (Exception e) {
            LogKt.logException$default(this, e, null, 2, null);
            callback.onFailure(e);
        }
    }

    @Override
    public void setCname(@NotNull String vaultId, @Nullable String cname, @NotNull Function2<? super Boolean, ? super Long, Unit> cnameResult) {
        Intrinsics.checkNotNullParameter((Object)vaultId, (String)"vaultId");
        Intrinsics.checkNotNullParameter(cnameResult, (String)"cnameResult");
        this.getCnameInterceptor().setCname(vaultId, cname, cnameResult);
    }

    @Override
    public void cancelAll() {
        this.getClient().dispatcher().cancelAll();
    }

    private final Request buildOkHttpRequest(HttpRequest request) throws Exception {
        String contentType = MapperKt.toContentType(request.getFormat());
        MediaType mediaType = MediaType.Companion.parse(contentType);
        RequestData requestData = request.getData();
        RequestBody requestBody = OkHttpConnectionKt.toRequestBodyOrNull((byte[])(requestData != null ? requestData.getData() : null), mediaType, request.getMethod());
        return OkHttpConnectionKt.addHeaders(new Request.Builder().url(StringKt.toURL(StringKt.concatWithSlash(request.getUrl(), request.getPath()))), MapKt.plusItem(request.getHeaders(), TuplesKt.to((Object)"Content-type", (Object)contentType))).method(request.getMethod().name(), requestBody).build();
    }

    public OkHttpClient(boolean isLogsEnabled) {
        super(isLogsEnabled);
        this.client$delegate = LazyKt.lazy((Function0)((Function0)new Function0<okhttp3.OkHttpClient>(this, isLogsEnabled){
            final /* synthetic */ OkHttpClient this$0;
            final /* synthetic */ boolean $isLogsEnabled;

            @NotNull
            public final okhttp3.OkHttpClient invoke() {
                OkHttpClient.Builder builder = new okhttp3.OkHttpClient().newBuilder().addInterceptor((Interceptor)OkHttpClient.access$getCnameInterceptor$p(this.this$0)).callTimeout(60000L, TimeUnit.MILLISECONDS).readTimeout(60000L, TimeUnit.MILLISECONDS).writeTimeout(60000L, TimeUnit.MILLISECONDS);
                boolean bl = false;
                boolean bl2 = false;
                OkHttpClient.Builder it = builder;
                boolean bl3 = false;
                if (this.$isLogsEnabled) {
                    it.addInterceptor((Interceptor)new LoggingInterceptor());
                }
                return builder.build();
            }
            {
                this.this$0 = okHttpClient;
                this.$isLogsEnabled = bl;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ CnameInterceptor access$getCnameInterceptor$p(OkHttpClient $this) {
        return $this.getCnameInterceptor();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/verygoodsecurity/vgsshow/core/network/client/okhttp/OkHttpClient$LoggingInterceptor;", "Lokhttp3/Interceptor;", "()V", "getBody", "", "request", "Lokhttp3/RequestBody;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "vgsshow_release"})
    public static final class LoggingInterceptor
    implements Interceptor {
        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) {
            Request it;
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
            String requestId = string;
            Request request = chain.request();
            boolean bl = false;
            boolean bl2 = false;
            Request request2 = request;
            Interceptor.Chain chain2 = chain;
            boolean bl3 = false;
            LogKt.logRequest$default(it, requestId, it.url().toString(), it.method(), MapsKt.toMap((Iterable)((Iterable)it.headers())), this.getBody(it.body()), null, 32, null);
            Unit unit = Unit.INSTANCE;
            request = chain2.proceed(request);
            bl = false;
            bl2 = false;
            it = request;
            boolean bl4 = false;
            LogKt.logResponse$default(this, requestId, it.request().url().toString(), it.code(), it.message(), MapsKt.toMap((Iterable)((Iterable)it.headers())), null, 32, null);
            return request;
        }

        private final String getBody(RequestBody request) {
            String string;
            try {
                Buffer buffer = new Buffer();
                RequestBody requestBody = request;
                if (requestBody != null) {
                    requestBody.writeTo((BufferedSink)buffer);
                }
                string = buffer.readUtf8();
            }
            catch (IOException e) {
                string = "";
            }
            return string;
        }
    }
}

