/*
 * Decompiled with CFR 0.152.
 */
package com.verygoodsecurity.vgsshow.core.network.client.httpurl;

import com.verygoodsecurity.vgsshow.core.network.client.BaseHttpClient;
import com.verygoodsecurity.vgsshow.core.network.client.HttpRequestCallback;
import com.verygoodsecurity.vgsshow.core.network.client.extension.CnameKt;
import com.verygoodsecurity.vgsshow.core.network.client.extension.HttpURLConnectionKt;
import com.verygoodsecurity.vgsshow.core.network.client.httpurl.HttpUrlClient;
import com.verygoodsecurity.vgsshow.core.network.client.httpurl.TLSSocketFactory;
import com.verygoodsecurity.vgsshow.core.network.client.model.HttpRequest;
import com.verygoodsecurity.vgsshow.core.network.client.model.HttpResponse;
import com.verygoodsecurity.vgsshow.core.network.extension.MapperKt;
import com.verygoodsecurity.vgsshow.core.network.model.data.request.RequestData;
import com.verygoodsecurity.vgsshow.util.extension.LogKt;
import com.verygoodsecurity.vgsshow.util.extension.MapKt;
import com.verygoodsecurity.vgsshow.util.extension.StringKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\nH\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J4\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0002J4\u0010+\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016J\u001a\u0010,\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0018\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/verygoodsecurity/vgsshow/core/network/client/httpurl/HttpUrlClient;", "Lcom/verygoodsecurity/vgsshow/core/network/client/BaseHttpClient;", "isLogsEnabled", "", "(Z)V", "cname", "", "cnameResult", "Lkotlin/Function2;", "", "", "executor", "Ljava/util/concurrent/ExecutorService;", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "executor$delegate", "Lkotlin/Lazy;", "isCnameValid", "Ljava/lang/Boolean;", "submittedTasks", "", "Ljava/util/concurrent/Future;", "vaultId", "cancelAll", "enqueue", "request", "Lcom/verygoodsecurity/vgsshow/core/network/client/model/HttpRequest;", "callback", "Lcom/verygoodsecurity/vgsshow/core/network/client/HttpRequestCallback;", "execute", "Lcom/verygoodsecurity/vgsshow/core/network/client/model/HttpResponse;", "generateBaseUrl", "generateBaseUrlWithCname", "url", "getValidatedCname", "logRequest", "requestId", "requestHeaders", "", "connection", "Ljava/net/HttpURLConnection;", "logResponse", "readResponse", "setCname", "writeData", "data", "", "vgsshow_release"})
public final class HttpUrlClient
extends BaseHttpClient {
    private String cname;
    private String vaultId;
    private Boolean isCnameValid;
    private Function2<? super Boolean, ? super Long, Unit> cnameResult;
    private final List<Future<?>> submittedTasks;
    private final Lazy executor$delegate;

    private final ExecutorService getExecutor() {
        Lazy lazy = this.executor$delegate;
        HttpUrlClient httpUrlClient = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ExecutorService)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public HttpResponse execute(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        String requestId = string;
        HttpURLConnection connection = null;
        try {
            Map<String, String> requestHeaders = MapKt.plusItem(request.getHeaders(), TuplesKt.to((Object)"Content-type", (Object)MapperKt.toContentType(request.getFormat())));
            String string2 = StringKt.toURL(StringKt.concatWithSlash(this.generateBaseUrl(request), request.getPath())).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(generateBaseUrl(request\u2026.path).toURL().toString()");
            connection = HttpURLConnectionKt.setMethod(HttpURLConnectionKt.addHeaders(HttpURLConnectionKt.setCacheEnabled(HttpURLConnectionKt.setIsUserInteractionEnabled(HttpURLConnectionKt.setInstanceFollowRedirectEnabled(HttpURLConnectionKt.readTimeout(HttpURLConnectionKt.callTimeout(HttpURLConnectionKt.setSSLSocketFactory(HttpURLConnectionKt.openConnection(string2), new TLSSocketFactory()), 60000L), 60000L), false), false), false), requestHeaders), request.getMethod());
            this.logRequest(requestId, request, requestHeaders, connection);
            RequestData requestData = request.getData();
            this.writeData(connection, (byte[])(requestData != null ? requestData.getData() : null));
            this.logResponse(requestId, connection);
            HttpResponse httpResponse = this.readResponse(connection);
            return httpResponse;
        }
        catch (Exception e) {
            LogKt.logException$default(this, e, null, 2, null);
            throw (Throwable)e;
        }
        finally {
            block5: {
                HttpURLConnection httpURLConnection = connection;
                if (httpURLConnection == null) break block5;
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enqueue(@NotNull HttpRequest request, @NotNull HttpRequestCallback callback) {
        void task;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        task.element = this.getExecutor().submit(new Runnable(this, callback, request, (Ref.ObjectRef)task){
            final /* synthetic */ HttpUrlClient this$0;
            final /* synthetic */ HttpRequestCallback $callback;
            final /* synthetic */ HttpRequest $request;
            final /* synthetic */ Ref.ObjectRef $task;

            public final void run() {
                try {
                    this.$callback.onResponse(this.this$0.execute(this.$request));
                    Collection collection = HttpUrlClient.access$getSubmittedTasks$p(this.this$0);
                    Future future = (Future)this.$task.element;
                    boolean bl = false;
                    Collection collection2 = collection;
                    if (collection2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                    }
                    TypeIntrinsics.asMutableCollection((Object)collection2).remove(future);
                }
                catch (Exception e) {
                    this.$callback.onFailure(e);
                }
            }
            {
                this.this$0 = httpUrlClient;
                this.$callback = httpRequestCallback;
                this.$request = httpRequest;
                this.$task = objectRef;
            }
        });
        Future future = (Future)task.element;
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"task");
        this.submittedTasks.add(future);
    }

    @Override
    public void setCname(@NotNull String vaultId, @Nullable String cname, @NotNull Function2<? super Boolean, ? super Long, Unit> cnameResult) {
        Intrinsics.checkNotNullParameter((Object)vaultId, (String)"vaultId");
        Intrinsics.checkNotNullParameter(cnameResult, (String)"cnameResult");
        this.cname = cname;
        this.vaultId = vaultId;
        this.isCnameValid = null;
        this.cnameResult = cnameResult;
    }

    @Override
    public void cancelAll() {
        Iterable $this$forEach$iv = this.submittedTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Future it = (Future)element$iv;
            boolean bl = false;
            it.cancel(true);
        }
        this.submittedTasks.clear();
    }

    private final String generateBaseUrl(HttpRequest request) {
        CharSequence charSequence = this.cname;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = this.vaultId;
            bl = false;
            bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string = request.getUrl();
                String string2 = this.cname;
                Intrinsics.checkNotNull((Object)string2);
                String string3 = this.vaultId;
                Intrinsics.checkNotNull((Object)string3);
                return this.generateBaseUrlWithCname(string, string2, string3);
            }
        }
        return request.getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String generateBaseUrlWithCname(String url, String cname, String vaultId) {
        String string;
        HttpUrlClient httpUrlClient = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (httpUrlClient) {
            boolean bl3;
            boolean bl4 = false;
            Boolean bl5 = this.isCnameValid;
            if (bl5 != null) {
                bl3 = bl5;
            } else {
                String string2 = this.getValidatedCname(cname, vaultId);
                boolean bl6 = false;
                boolean bl7 = false;
                String $this$run = string2;
                boolean bl8 = false;
                boolean bl9 = $this$run != null;
                boolean bl10 = false;
                boolean bl11 = false;
                boolean it = bl9;
                boolean bl12 = false;
                this.isCnameValid = it;
                bl3 = bl9;
            }
            boolean isValid = bl3;
            string = isValid ? StringKt.concatWithHttpProtocol(cname) : url;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getValidatedCname(String cname, String vaultId) {
        Object object;
        HttpURLConnection connection = null;
        Long responseTime = null;
        HttpResponse response = null;
        try {
            Object object2;
            block13: {
                block12: {
                    boolean $i$f$measureTimeMillis = false;
                    boolean bl = false;
                    long start$iv = System.currentTimeMillis();
                    boolean bl2 = false;
                    HttpURLConnection httpURLConnection = connection = HttpURLConnectionKt.openConnection(CnameKt.toHostnameValidationUrl(cname, vaultId));
                    Intrinsics.checkNotNull((Object)httpURLConnection);
                    httpURLConnection.setRequestMethod("GET");
                    HttpURLConnection httpURLConnection2 = connection;
                    Intrinsics.checkNotNull((Object)httpURLConnection2);
                    response = this.readResponse(httpURLConnection2);
                    Unit unit = Unit.INSTANCE;
                    responseTime = System.currentTimeMillis() - start$iv;
                    object2 = response;
                    if (object2 == null) break block12;
                    object = object2;
                    bl = false;
                    boolean bl3 = false;
                    Object it = object;
                    boolean bl4 = false;
                    object2 = ((HttpResponse)it).isSuccessful() ? object : null;
                    if (object2 == null || (object2 = ((HttpResponse)object2).getResponseBody()) == null) break block12;
                    object = object2;
                    bl = false;
                    bl3 = false;
                    it = object;
                    boolean bl5 = false;
                    CharSequence charSequence = (CharSequence)it;
                    boolean bl6 = false;
                    object2 = charSequence.length() > 0 && StringKt.equalsHosts((String)it, cname) ? object : null;
                    if (object2 == null) break block12;
                    object = object2;
                    bl = false;
                    bl3 = false;
                    Object $this$run = object;
                    boolean bl7 = false;
                    Function2<? super Boolean, ? super Long, Unit> function2 = this.cnameResult;
                    if (function2 != null) {
                        Unit cfr_ignored_0 = (Unit)function2.invoke((Object)true, (Object)responseTime);
                    }
                    if ((object2 = cname) != null) break block13;
                }
                throw (Throwable)new Exception();
            }
            object = object2;
        }
        catch (Exception e) {
            LogKt.logWaring$default(this, "A specified cname(" + cname + ") incorrect, response time = " + responseTime, null, 2, null);
            Function2<? super Boolean, ? super Long, Unit> function2 = this.cnameResult;
            if (function2 != null) {
                Long l = responseTime;
                Unit cfr_ignored_1 = (Unit)function2.invoke((Object)false, (Object)(l != null ? l : 0L));
            }
            object = null;
        }
        finally {
            HttpURLConnection httpURLConnection = connection;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeData(HttpURLConnection connection, byte[] data) throws IOException {
        if (data != null) {
            byte[] byArray = data;
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray;
            boolean bl3 = false;
            Closeable closeable = connection.getOutputStream();
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                OutputStream os = (OutputStream)closeable;
                boolean bl6 = false;
                os.write(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpResponse readResponse(HttpURLConnection connection) throws IOException {
        Object object;
        if (HttpURLConnectionKt.isSuccessful(connection)) {
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
            Closeable closeable = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable2 = closeable;
            int n = 0;
            closeable2 = new InputStreamReader((InputStream)closeable2, charset);
            n = 8192;
            boolean bl2 = false;
            closeable = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n);
            boolean bl3 = false;
            bl = false;
            Throwable throwable = null;
            try {
                Object it = (BufferedReader)closeable;
                boolean bl4 = false;
                it = new HttpResponse(connection.getResponseCode(), true, null, TextStreamsKt.readText((Reader)((Reader)it)), 4, null);
                object = it;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        InputStream inputStream = connection.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.errorStream");
        Closeable closeable = inputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Closeable it = closeable;
        int bl4 = 0;
        it = new InputStreamReader((InputStream)it, charset);
        bl4 = 8192;
        boolean bl5 = false;
        closeable = it instanceof BufferedReader ? (BufferedReader)it : new BufferedReader((Reader)it, bl4);
        boolean bl6 = false;
        bl = false;
        Throwable throwable = null;
        try {
            it = (BufferedReader)closeable;
            boolean bl7 = false;
            HttpResponse httpResponse = new HttpResponse(connection.getResponseCode(), false, TextStreamsKt.readText((Reader)((Reader)it)), null, 8, null);
            object = httpResponse;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }

    private final void logRequest(String requestId, HttpRequest request, Map<String, String> requestHeaders, HttpURLConnection connection) {
        if (!this.isLogsEnabled()) {
            return;
        }
        String string = connection.getURL().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.url.toString()");
        String string2 = connection.getRequestMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"connection.requestMethod");
        RequestData requestData = request.getData();
        LogKt.logRequest$default(this, requestId, string, string2, requestHeaders, requestData != null ? requestData.getRawData() : null, null, 32, null);
    }

    private final void logResponse(String requestId, HttpURLConnection connection) {
        if (!this.isLogsEnabled()) {
            return;
        }
        String string = connection.getURL().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.url.toString()");
        int n = connection.getResponseCode();
        String string2 = connection.getResponseMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"connection.responseMessage");
        LogKt.logResponse$default(this, requestId, string, n, string2, HttpURLConnectionKt.getHeaders(connection), null, 32, null);
    }

    public HttpUrlClient(boolean isLogsEnabled) {
        super(isLogsEnabled);
        boolean bl = false;
        this.submittedTasks = new ArrayList();
        this.executor$delegate = LazyKt.lazy((Function0)executor.2.INSTANCE);
    }

    public static final /* synthetic */ List access$getSubmittedTasks$p(HttpUrlClient $this) {
        return $this.submittedTasks;
    }
}

