/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.WorkerConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util.TopicCreationGroup;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicCreation {
    private static final Logger log = LoggerFactory.getLogger(TopicCreation.class);
    private static final TopicCreation EMPTY = new TopicCreation(false, null, Collections.emptyMap(), Collections.emptySet());
    private final boolean isTopicCreationEnabled;
    private final TopicCreationGroup defaultTopicGroup;
    private final Map<String, TopicCreationGroup> topicGroups;
    private final Set<String> topicCache;

    protected TopicCreation(boolean isTopicCreationEnabled, TopicCreationGroup defaultTopicGroup, Map<String, TopicCreationGroup> topicGroups, Set<String> topicCache) {
        this.isTopicCreationEnabled = isTopicCreationEnabled;
        this.defaultTopicGroup = defaultTopicGroup;
        this.topicGroups = topicGroups;
        this.topicCache = topicCache;
    }

    public static TopicCreation newTopicCreation(WorkerConfig workerConfig, Map<String, TopicCreationGroup> topicGroups) {
        if (!workerConfig.topicCreationEnable() || topicGroups == null) {
            return EMPTY;
        }
        LinkedHashMap<String, TopicCreationGroup> groups = new LinkedHashMap<String, TopicCreationGroup>(topicGroups);
        groups.remove("default");
        return new TopicCreation(true, topicGroups.get("default"), groups, new HashSet<String>());
    }

    public static TopicCreation empty() {
        return EMPTY;
    }

    public boolean isTopicCreationEnabled() {
        return this.isTopicCreationEnabled;
    }

    public boolean isTopicCreationRequired(String topic) {
        return this.isTopicCreationEnabled && !this.topicCache.contains(topic);
    }

    public TopicCreationGroup defaultTopicGroup() {
        return this.defaultTopicGroup;
    }

    public Map<String, TopicCreationGroup> topicGroups() {
        return this.topicGroups;
    }

    public void addTopic(String topic) {
        if (this.isTopicCreationEnabled) {
            this.topicCache.add(topic);
        }
    }

    public TopicCreationGroup findFirstGroup(String topic) {
        return this.topicGroups.values().stream().filter(group -> group.matches(topic)).findFirst().orElse(this.defaultTopicGroup);
    }
}

