/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.DescribeProducersResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class DescribeProducersResponse
extends AbstractResponse {
    private final DescribeProducersResponseData data;

    public DescribeProducersResponse(DescribeProducersResponseData data) {
        super(ApiKeys.DESCRIBE_PRODUCERS);
        this.data = data;
    }

    @Override
    public DescribeProducersResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (DescribeProducersResponseData.TopicResponse topicResponse : this.data.topics()) {
            for (DescribeProducersResponseData.PartitionResponse partitionResponse : topicResponse.partitions()) {
                this.updateErrorCounts(errorCounts, Errors.forCode(partitionResponse.errorCode()));
            }
        }
        return errorCounts;
    }

    public static DescribeProducersResponse parse(ByteBuffer buffer, short version) {
        return new DescribeProducersResponse(new DescribeProducersResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }
}

