/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiMessage;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Readable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Writable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class ListTransactionsRequestData
implements ApiMessage {
    List<String> stateFilters;
    List<Long> producerIdFilters;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("state_filters", new CompactArrayOf(Type.COMPACT_STRING), "The transaction states to filter by: if empty, all transactions are returned; if non-empty, then only transactions matching one of the filtered states will be returned"), new Field("producer_id_filters", new CompactArrayOf(Type.INT64), "The producerIds to filter by: if empty, all transactions will be returned; if non-empty, only transactions which match one of the filtered producerIds will be returned"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ListTransactionsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ListTransactionsRequestData() {
        this.stateFilters = new ArrayList<String>(0);
        this.producerIdFilters = new ArrayList<Long>(0);
    }

    @Override
    public short apiKey() {
        return 66;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field stateFilters was serialized as null");
        }
        ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field stateFilters element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field stateFilters element had invalid length " + length);
            }
            newCollection.add(_readable.readString(length));
        }
        this.stateFilters = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field producerIdFilters was serialized as null");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((String)((Object)Long.valueOf(_readable.readLong())));
        }
        this.producerIdFilters = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.stateFilters.size() + 1);
        for (String stateFiltersElement : this.stateFilters) {
            byte[] _stringBytes = _cache.getSerializedValue(stateFiltersElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeUnsignedVarint(this.producerIdFilters.size() + 1);
        for (Long producerIdFiltersElement : this.producerIdFilters) {
            _writable.writeLong(producerIdFiltersElement);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.stateFilters.size() + 1));
        for (String stateFiltersElement : this.stateFilters) {
            byte[] _stringBytes = stateFiltersElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'stateFiltersElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(stateFiltersElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.producerIdFilters.size() + 1));
        _size.addBytes(this.producerIdFilters.size() * 8);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListTransactionsRequestData)) {
            return false;
        }
        ListTransactionsRequestData other = (ListTransactionsRequestData)obj;
        if (this.stateFilters == null ? other.stateFilters != null : !this.stateFilters.equals(other.stateFilters)) {
            return false;
        }
        if (this.producerIdFilters == null ? other.producerIdFilters != null : !this.producerIdFilters.equals(other.producerIdFilters)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.stateFilters == null ? 0 : this.stateFilters.hashCode());
        hashCode = 31 * hashCode + (this.producerIdFilters == null ? 0 : this.producerIdFilters.hashCode());
        return hashCode;
    }

    @Override
    public ListTransactionsRequestData duplicate() {
        ListTransactionsRequestData _duplicate = new ListTransactionsRequestData();
        ArrayList<String> newStateFilters = new ArrayList<String>(this.stateFilters.size());
        for (String _element : this.stateFilters) {
            newStateFilters.add(_element);
        }
        _duplicate.stateFilters = newStateFilters;
        ArrayList<Long> newProducerIdFilters = new ArrayList<Long>(this.producerIdFilters.size());
        for (Long _element : this.producerIdFilters) {
            newProducerIdFilters.add(_element);
        }
        _duplicate.producerIdFilters = newProducerIdFilters;
        return _duplicate;
    }

    public String toString() {
        return "ListTransactionsRequestData(stateFilters=" + MessageUtil.deepToString(this.stateFilters.iterator()) + ", producerIdFilters=" + MessageUtil.deepToString(this.producerIdFilters.iterator()) + ")";
    }

    public List<String> stateFilters() {
        return this.stateFilters;
    }

    public List<Long> producerIdFilters() {
        return this.producerIdFilters;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListTransactionsRequestData setStateFilters(List<String> v) {
        this.stateFilters = v;
        return this;
    }

    public ListTransactionsRequestData setProducerIdFilters(List<Long> v) {
        this.producerIdFilters = v;
        return this;
    }
}

