/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.schema;

import com.ververica.cdc.common.event.AddColumnEvent;
import com.ververica.cdc.common.schema.Column;
import com.ververica.cdc.common.types.DataType;
import com.ververica.cdc.common.types.DataTypes;
import com.ververica.cdc.runtime.serializer.EnumSerializer;
import com.ververica.cdc.runtime.serializer.NullableSerializerWrapper;
import com.ververica.cdc.runtime.serializer.TypeSerializerSingleton;
import com.ververica.cdc.runtime.serializer.schema.ColumnSerializer;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class ColumnWithPositionSerializer
extends TypeSerializerSingleton<AddColumnEvent.ColumnWithPosition> {
    private static final long serialVersionUID = 1L;
    public static final ColumnWithPositionSerializer INSTANCE = new ColumnWithPositionSerializer();
    private final TypeSerializer<Column> columnSerializer = new NullableSerializerWrapper<Column>(ColumnSerializer.INSTANCE);
    private final EnumSerializer<AddColumnEvent.ColumnPosition> positionEnumSerializer = new EnumSerializer<AddColumnEvent.ColumnPosition>(AddColumnEvent.ColumnPosition.class);

    public boolean isImmutableType() {
        return false;
    }

    public AddColumnEvent.ColumnWithPosition createInstance() {
        return new AddColumnEvent.ColumnWithPosition((Column)Column.physicalColumn((String)"unknown", (DataType)DataTypes.BIGINT()));
    }

    public AddColumnEvent.ColumnWithPosition copy(AddColumnEvent.ColumnWithPosition from) {
        return new AddColumnEvent.ColumnWithPosition((Column)this.columnSerializer.copy((Object)from.getAddColumn()), from.getPosition(), (Column)this.columnSerializer.copy((Object)from.getExistingColumn()));
    }

    public AddColumnEvent.ColumnWithPosition copy(AddColumnEvent.ColumnWithPosition from, AddColumnEvent.ColumnWithPosition reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(AddColumnEvent.ColumnWithPosition record, DataOutputView target) throws IOException {
        this.columnSerializer.serialize((Object)record.getAddColumn(), target);
        this.positionEnumSerializer.serialize(record.getPosition(), target);
        if (record.getExistingColumn() == null) {
            target.writeInt(0);
        } else {
            target.writeInt(1);
            this.columnSerializer.serialize((Object)record.getExistingColumn(), target);
        }
    }

    public AddColumnEvent.ColumnWithPosition deserialize(DataInputView source) throws IOException {
        Column addColumn = (Column)this.columnSerializer.deserialize(source);
        AddColumnEvent.ColumnPosition position = (AddColumnEvent.ColumnPosition)this.positionEnumSerializer.deserialize(source);
        if (source.readInt() == 1) {
            return new AddColumnEvent.ColumnWithPosition(addColumn, position, (Column)this.columnSerializer.deserialize(source));
        }
        return new AddColumnEvent.ColumnWithPosition(addColumn, position, null);
    }

    public AddColumnEvent.ColumnWithPosition deserialize(AddColumnEvent.ColumnWithPosition reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<AddColumnEvent.ColumnWithPosition> snapshotConfiguration() {
        return new ColumnWithPositionSerializerSnapshot();
    }

    public static final class ColumnWithPositionSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<AddColumnEvent.ColumnWithPosition> {
        public ColumnWithPositionSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

