/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.event;

import com.ververica.cdc.common.event.CreateTableEvent;
import com.ververica.cdc.common.event.TableId;
import com.ververica.cdc.common.schema.Schema;
import com.ververica.cdc.runtime.serializer.TableIdSerializer;
import com.ververica.cdc.runtime.serializer.TypeSerializerSingleton;
import com.ververica.cdc.runtime.serializer.schema.SchemaSerializer;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class CreateTableEventSerializer
extends TypeSerializerSingleton<CreateTableEvent> {
    private static final long serialVersionUID = 1L;
    public static final CreateTableEventSerializer INSTANCE = new CreateTableEventSerializer();
    private final TableIdSerializer tableIdSerializer = TableIdSerializer.INSTANCE;
    private final SchemaSerializer schemaSerializer = SchemaSerializer.INSTANCE;

    public boolean isImmutableType() {
        return false;
    }

    public CreateTableEvent createInstance() {
        return new CreateTableEvent(TableId.tableId((String)"unknown"), Schema.newBuilder().build());
    }

    public CreateTableEvent copy(CreateTableEvent from) {
        return new CreateTableEvent(from.tableId(), this.schemaSerializer.copy(from.getSchema()));
    }

    public CreateTableEvent copy(CreateTableEvent from, CreateTableEvent reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(CreateTableEvent record, DataOutputView target) throws IOException {
        this.tableIdSerializer.serialize(record.tableId(), target);
        this.schemaSerializer.serialize(record.getSchema(), target);
    }

    public CreateTableEvent deserialize(DataInputView source) throws IOException {
        return new CreateTableEvent(this.tableIdSerializer.deserialize(source), this.schemaSerializer.deserialize(source));
    }

    public CreateTableEvent deserialize(CreateTableEvent reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<CreateTableEvent> snapshotConfiguration() {
        return new CreateTableEventSerializerSnapshot();
    }

    public static final class CreateTableEventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<CreateTableEvent> {
        public CreateTableEventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

