/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer.data;

import com.ververica.cdc.common.data.TimestampData;
import com.ververica.cdc.common.data.ZonedTimestampData;
import com.ververica.cdc.runtime.serializer.StringSerializer;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class ZonedTimestampDataSerializer
extends TypeSerializer<ZonedTimestampData> {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final StringSerializer stringSerializer = StringSerializer.INSTANCE;

    public ZonedTimestampDataSerializer(int precision) {
        this.precision = precision;
    }

    public boolean isImmutableType() {
        return true;
    }

    public TypeSerializer<ZonedTimestampData> duplicate() {
        return new ZonedTimestampDataSerializer(this.precision);
    }

    public ZonedTimestampData createInstance() {
        return ZonedTimestampData.of((long)1L, (int)1, (String)"UTC");
    }

    public ZonedTimestampData copy(ZonedTimestampData from) {
        return ZonedTimestampData.of((long)from.getMillisecond(), (int)from.getNanoOfMillisecond(), (String)from.getZoneId());
    }

    public ZonedTimestampData copy(ZonedTimestampData from, ZonedTimestampData reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return ZonedTimestampData.isCompact((int)this.precision) ? 8 : 12;
    }

    public void serialize(ZonedTimestampData record, DataOutputView target) throws IOException {
        this.stringSerializer.serialize(record.getZoneId(), target);
        if (ZonedTimestampData.isCompact((int)this.precision)) {
            assert (record.getNanoOfMillisecond() == 0);
            target.writeLong(record.getMillisecond());
        } else {
            target.writeLong(record.getMillisecond());
            target.writeInt(record.getNanoOfMillisecond());
        }
    }

    public ZonedTimestampData deserialize(DataInputView source) throws IOException {
        String zoneId = this.stringSerializer.deserialize(source);
        if (TimestampData.isCompact((int)this.precision)) {
            long val = source.readLong();
            return ZonedTimestampData.of((long)val, (int)0, (String)zoneId);
        }
        long longVal = source.readLong();
        int intVal = source.readInt();
        return ZonedTimestampData.of((long)longVal, (int)intVal, (String)zoneId);
    }

    public ZonedTimestampData deserialize(ZonedTimestampData reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.stringSerializer.serialize(this.stringSerializer.deserialize(source), target);
        if (ZonedTimestampData.isCompact((int)this.precision)) {
            target.writeLong(source.readLong());
        } else {
            target.writeLong(source.readLong());
            target.writeInt(source.readInt());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ZonedTimestampDataSerializer that = (ZonedTimestampDataSerializer)((Object)obj);
        return this.precision == that.precision;
    }

    public int hashCode() {
        return this.precision;
    }

    public TypeSerializerSnapshot<ZonedTimestampData> snapshotConfiguration() {
        return new ZonedTimestampDataSerializerSnapshot(this.precision);
    }

    public static final class ZonedTimestampDataSerializerSnapshot
    implements TypeSerializerSnapshot<ZonedTimestampData> {
        private static final int CURRENT_VERSION = 1;
        private int previousPrecision;

        public ZonedTimestampDataSerializerSnapshot() {
        }

        ZonedTimestampDataSerializerSnapshot(int precision) {
            this.previousPrecision = precision;
        }

        public int getCurrentVersion() {
            return 1;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.previousPrecision);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.previousPrecision = in.readInt();
        }

        public TypeSerializer<ZonedTimestampData> restoreSerializer() {
            return new ZonedTimestampDataSerializer(this.previousPrecision);
        }

        public TypeSerializerSchemaCompatibility<ZonedTimestampData> resolveSchemaCompatibility(TypeSerializer<ZonedTimestampData> newSerializer) {
            if (!(newSerializer instanceof ZonedTimestampDataSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            ZonedTimestampDataSerializer timestampDataSerializer = (ZonedTimestampDataSerializer)newSerializer;
            if (this.previousPrecision != timestampDataSerializer.precision) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

