/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer;

import com.ververica.cdc.common.event.TableId;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class TableIdSerializer
extends TypeSerializer<TableId> {
    private static final long serialVersionUID = 1L;
    public static final TableIdSerializer INSTANCE = new TableIdSerializer();

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<TableId> duplicate() {
        return new TableIdSerializer();
    }

    public TableId createInstance() {
        return TableId.tableId((String)"unknown", (String)"unknown", (String)"unknown");
    }

    public TableId copy(TableId from) {
        return from;
    }

    public TableId copy(TableId from, TableId reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(TableId record, DataOutputView target) throws IOException {
        int parts = 1;
        parts += record.getNamespace() == null ? 0 : 1;
        target.writeInt(parts += record.getSchemaName() == null ? 0 : 1);
        if (record.getNamespace() != null) {
            target.writeUTF(record.getNamespace());
        }
        if (record.getSchemaName() != null) {
            target.writeUTF(record.getSchemaName());
        }
        target.writeUTF(record.getTableName());
    }

    public TableId deserialize(DataInputView source) throws IOException {
        int parts = source.readInt();
        if (parts == 3) {
            return TableId.tableId((String)source.readUTF(), (String)source.readUTF(), (String)source.readUTF());
        }
        if (parts == 2) {
            return TableId.tableId((String)source.readUTF(), (String)source.readUTF());
        }
        return TableId.tableId((String)source.readUTF());
    }

    public TableId deserialize(TableId reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == ((Object)((Object)this)).getClass();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public TypeSerializerSnapshot<TableId> snapshotConfiguration() {
        return new TableIdSerializerSnapshot();
    }

    public static final class TableIdSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<TableId> {
        public TableIdSerializerSnapshot() {
            super(TableIdSerializer::new);
        }
    }
}

