/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.serializer;

import com.ververica.cdc.common.utils.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class MapSerializer<K, V>
extends TypeSerializer<Map<K, V>> {
    private static final long serialVersionUID = -6885593032367050078L;
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<V> valueSerializer;

    public MapSerializer(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer, (String)"The key serializer cannot be null");
        this.valueSerializer = (TypeSerializer)Preconditions.checkNotNull(valueSerializer, (String)"The value serializer cannot be null.");
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<Map<K, V>> duplicate() {
        TypeSerializer duplicateKeySerializer = this.keySerializer.duplicate();
        TypeSerializer duplicateValueSerializer = this.valueSerializer.duplicate();
        return duplicateKeySerializer == this.keySerializer && duplicateValueSerializer == this.valueSerializer ? this : new MapSerializer<K, V>(duplicateKeySerializer, duplicateValueSerializer);
    }

    public Map<K, V> createInstance() {
        return new HashMap();
    }

    public Map<K, V> copy(Map<K, V> from) {
        HashMap<Object, Object> newMap = new HashMap<Object, Object>(from.size());
        for (Map.Entry<K, V> entry : from.entrySet()) {
            Object newKey = this.keySerializer.copy(entry.getKey());
            Object newValue = entry.getValue() == null ? null : this.valueSerializer.copy(entry.getValue());
            newMap.put(newKey, newValue);
        }
        return newMap;
    }

    public Map<K, V> copy(Map<K, V> from, Map<K, V> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(Map<K, V> map, DataOutputView target) throws IOException {
        int size = map.size();
        target.writeInt(size);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.keySerializer.serialize(entry.getKey(), target);
            if (entry.getValue() == null) {
                target.writeBoolean(true);
                continue;
            }
            target.writeBoolean(false);
            this.valueSerializer.serialize(entry.getValue(), target);
        }
    }

    public Map<K, V> deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = this.keySerializer.deserialize(source);
            boolean isNull = source.readBoolean();
            Object value = isNull ? null : this.valueSerializer.deserialize(source);
            map.put(key, value);
        }
        return map;
    }

    public Map<K, V> deserialize(Map<K, V> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int size = source.readInt();
        target.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.keySerializer.copy(source, target);
            boolean isNull = source.readBoolean();
            target.writeBoolean(isNull);
            if (isNull) continue;
            this.valueSerializer.copy(source, target);
        }
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && this.keySerializer.equals(((MapSerializer)((Object)obj)).getKeySerializer()) && this.valueSerializer.equals(((MapSerializer)((Object)obj)).getValueSerializer());
    }

    public int hashCode() {
        return this.keySerializer.hashCode() * 31 + this.valueSerializer.hashCode();
    }

    public TypeSerializerSnapshot<Map<K, V>> snapshotConfiguration() {
        return new MapSerializerSnapshot(this);
    }

    public static final class MapSerializerSnapshot<K, V>
    extends CompositeTypeSerializerSnapshot<Map<K, V>, MapSerializer<K, V>> {
        private static final int CURRENT_VERSION = 1;

        public MapSerializerSnapshot() {
            super(MapSerializer.class);
        }

        public MapSerializerSnapshot(MapSerializer<K, V> mapSerializer) {
            super(mapSerializer);
        }

        public int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected MapSerializer<K, V> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            TypeSerializer<?> keySerializer = nestedSerializers[0];
            TypeSerializer<?> valueSerializer = nestedSerializers[1];
            return new MapSerializer(keySerializer, valueSerializer);
        }

        protected TypeSerializer<?>[] getNestedSerializers(MapSerializer<K, V> outerSerializer) {
            return new TypeSerializer[]{outerSerializer.getKeySerializer(), outerSerializer.getValueSerializer()};
        }

        public TypeSerializerSnapshot<K> getKeySerializerSnapshot() {
            return this.getNestedSerializerSnapshots()[0];
        }
    }
}

