/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.operators.sink;

import com.ververica.cdc.common.event.TableId;
import com.ververica.cdc.common.schema.Schema;
import com.ververica.cdc.runtime.operators.schema.event.CoordinationResponseUtils;
import com.ververica.cdc.runtime.operators.schema.event.FlushSuccessEvent;
import com.ververica.cdc.runtime.operators.schema.event.GetSchemaRequest;
import com.ververica.cdc.runtime.operators.schema.event.GetSchemaResponse;
import com.ververica.cdc.runtime.operators.schema.event.SinkWriterRegisterEvent;
import java.io.IOException;
import java.util.Optional;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.SerializedValue;

public class SchemaEvolutionClient {
    private final TaskOperatorEventGateway toCoordinator;
    private final OperatorID schemaOperatorID;

    public SchemaEvolutionClient(TaskOperatorEventGateway toCoordinator, OperatorID schemaOperatorID) {
        this.toCoordinator = toCoordinator;
        this.schemaOperatorID = schemaOperatorID;
    }

    public void registerSubtask(int subtask) throws IOException {
        this.toCoordinator.sendOperatorEventToCoordinator(this.schemaOperatorID, new SerializedValue((Object)new SinkWriterRegisterEvent(subtask)));
    }

    public void notifyFlushSuccess(int subtask, TableId tableId) throws IOException {
        this.toCoordinator.sendOperatorEventToCoordinator(this.schemaOperatorID, new SerializedValue((Object)new FlushSuccessEvent(subtask, tableId)));
    }

    public Optional<Schema> getLatestSchema(TableId tableId) throws Exception {
        GetSchemaResponse getSchemaResponse = (GetSchemaResponse)CoordinationResponseUtils.unwrap((CoordinationResponse)this.toCoordinator.sendRequestToCoordinator(this.schemaOperatorID, new SerializedValue((Object)GetSchemaRequest.ofLatestSchema(tableId))).get());
        return getSchemaResponse.getSchema();
    }
}

