/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.runtime.operators.route;

import com.ververica.cdc.common.data.RecordData;
import com.ververica.cdc.common.event.AddColumnEvent;
import com.ververica.cdc.common.event.AlterColumnTypeEvent;
import com.ververica.cdc.common.event.ChangeEvent;
import com.ververica.cdc.common.event.CreateTableEvent;
import com.ververica.cdc.common.event.DataChangeEvent;
import com.ververica.cdc.common.event.DropColumnEvent;
import com.ververica.cdc.common.event.Event;
import com.ververica.cdc.common.event.RenameColumnEvent;
import com.ververica.cdc.common.event.SchemaChangeEvent;
import com.ververica.cdc.common.event.TableId;
import com.ververica.cdc.common.schema.Selectors;
import com.ververica.cdc.common.utils.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;

public class RouteFunction
extends RichMapFunction<Event, Event> {
    private final List<Tuple2<String, TableId>> routingRules;
    private transient List<Tuple2<Selectors, TableId>> routes;

    public static Builder newBuilder() {
        return new Builder();
    }

    private RouteFunction(List<Tuple2<String, TableId>> routingRules) {
        this.routingRules = routingRules;
    }

    public void open(Configuration parameters) throws Exception {
        this.routes = this.routingRules.stream().map((? super T tuple2) -> {
            String tableInclusions = (String)tuple2.f0;
            TableId replaceBy = (TableId)tuple2.f1;
            Selectors selectors = new Selectors.SelectorsBuilder().includeTables(tableInclusions).build();
            return new Tuple2((Object)selectors, (Object)replaceBy);
        }).collect(Collectors.toList());
    }

    public Event map(Event event) throws Exception {
        Preconditions.checkState((boolean)(event instanceof ChangeEvent), (Object)String.format("The input event of the route is not a ChangeEvent but with type \"%s\"", event.getClass().getCanonicalName()));
        ChangeEvent changeEvent = (ChangeEvent)event;
        TableId tableId = changeEvent.tableId();
        for (Tuple2<Selectors, TableId> route : this.routes) {
            Selectors selectors = (Selectors)route.f0;
            TableId replaceBy = (TableId)route.f1;
            if (!selectors.isMatch(tableId)) continue;
            return this.recreateChangeEvent(changeEvent, replaceBy);
        }
        return event;
    }

    private ChangeEvent recreateChangeEvent(ChangeEvent event, TableId tableId) {
        if (event instanceof DataChangeEvent) {
            return this.recreateDataChangeEvent((DataChangeEvent)event, tableId);
        }
        if (event instanceof SchemaChangeEvent) {
            return this.recreateSchemaChangeEvent((SchemaChangeEvent)event, tableId);
        }
        throw new UnsupportedOperationException(String.format("Unsupported change event with type \"%s\"", event.getClass().getCanonicalName()));
    }

    private DataChangeEvent recreateDataChangeEvent(DataChangeEvent dataChangeEvent, TableId tableId) {
        switch (dataChangeEvent.op()) {
            case INSERT: {
                return DataChangeEvent.insertEvent((TableId)tableId, (RecordData)dataChangeEvent.after(), (Map)dataChangeEvent.meta());
            }
            case UPDATE: {
                return DataChangeEvent.updateEvent((TableId)tableId, (RecordData)dataChangeEvent.before(), (RecordData)dataChangeEvent.after(), (Map)dataChangeEvent.meta());
            }
            case REPLACE: {
                return DataChangeEvent.replaceEvent((TableId)tableId, (RecordData)dataChangeEvent.after(), (Map)dataChangeEvent.meta());
            }
            case DELETE: {
                return DataChangeEvent.deleteEvent((TableId)tableId, (RecordData)dataChangeEvent.before(), (Map)dataChangeEvent.meta());
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported operation type \"%s\" in data change event", dataChangeEvent.op()));
    }

    private SchemaChangeEvent recreateSchemaChangeEvent(SchemaChangeEvent schemaChangeEvent, TableId tableId) {
        if (schemaChangeEvent instanceof CreateTableEvent) {
            CreateTableEvent createTableEvent = (CreateTableEvent)schemaChangeEvent;
            return new CreateTableEvent(tableId, createTableEvent.getSchema());
        }
        if (schemaChangeEvent instanceof AlterColumnTypeEvent) {
            AlterColumnTypeEvent alterColumnTypeEvent = (AlterColumnTypeEvent)schemaChangeEvent;
            return new AlterColumnTypeEvent(tableId, alterColumnTypeEvent.getTypeMapping());
        }
        if (schemaChangeEvent instanceof RenameColumnEvent) {
            RenameColumnEvent renameColumnEvent = (RenameColumnEvent)schemaChangeEvent;
            return new RenameColumnEvent(tableId, renameColumnEvent.getNameMapping());
        }
        if (schemaChangeEvent instanceof DropColumnEvent) {
            DropColumnEvent dropColumnEvent = (DropColumnEvent)schemaChangeEvent;
            return new DropColumnEvent(tableId, dropColumnEvent.getDroppedColumns());
        }
        if (schemaChangeEvent instanceof AddColumnEvent) {
            AddColumnEvent addColumnEvent = (AddColumnEvent)schemaChangeEvent;
            return new AddColumnEvent(tableId, addColumnEvent.getAddedColumns());
        }
        throw new UnsupportedOperationException(String.format("Unsupported schema change event with type \"%s\"", schemaChangeEvent.getClass().getCanonicalName()));
    }

    public static class Builder {
        private final List<Tuple2<String, TableId>> routingRules = new ArrayList<Tuple2<String, TableId>>();

        public Builder addRoute(String tableInclusions, TableId replaceBy) {
            this.routingRules.add((Tuple2<String, TableId>)Tuple2.of((Object)tableInclusions, (Object)replaceBy));
            return this;
        }

        public RouteFunction build() {
            return new RouteFunction(this.routingRules);
        }
    }
}

