/*
 * Decompiled with CFR 0.152.
 */
package com.versioneye;

import com.versioneye.ProjectMojo;
import com.versioneye.dto.ProjectJsonResponse;
import com.versioneye.utils.HttpUtils;
import com.versioneye.utils.PropertiesUtils;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.jackson.map.ObjectMapper;

@Mojo(name="create", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class CreateMojo
extends ProjectMojo {
    @Parameter(property="resource", defaultValue="/projects?api_key=")
    private String resource;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.setProxy();
            this.prettyPrintStart();
            ByteArrayOutputStream jsonDirectDependenciesStream = this.getDirectDependenciesJsonStream(this.nameStrategy);
            if (jsonDirectDependenciesStream == null) {
                this.prettyPrint0End();
                return;
            }
            ProjectJsonResponse response = this.uploadDependencies(jsonDirectDependenciesStream);
            this.merge(response.getId());
            if (this.updatePropertiesAfterCreate) {
                this.writeProperties(response);
            }
            this.prettyPrint(response);
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Oh no! Something went wrong :-( Get in touch with the VersionEye guys and give them feedback.You find them on Twitter at https//twitter.com/VersionEye. ", exception);
        }
    }

    private ProjectJsonResponse uploadDependencies(ByteArrayOutputStream outStream) throws Exception {
        String apiKey = this.fetchApiKey();
        String url = this.baseUrl + this.apiPath + this.resource + apiKey;
        Reader reader = HttpUtils.post(url, outStream.toByteArray(), "upload", this.visibility, this.name, this.organisation, this.team);
        ObjectMapper mapper = new ObjectMapper();
        return (ProjectJsonResponse)mapper.readValue(reader, ProjectJsonResponse.class);
    }

    private void prettyPrintStart() {
        this.getLog().info((CharSequence)".");
        this.getLog().info((CharSequence)"Starting to upload dependencies. This can take a couple seconds ... ");
        this.getLog().info((CharSequence)".");
    }

    protected void writeProperties(ProjectJsonResponse response) throws Exception {
        Properties properties = this.fetchProjectProperties();
        if (response.getId() != null) {
            properties.setProperty("project_id", response.getId());
        }
        PropertiesUtils utils = new PropertiesUtils();
        utils.writeProperties(properties, this.getPropertiesPath());
    }

    protected void merge(String childId) {
        if (!this.mergeAfterCreate) {
            return;
        }
        try {
            if (this.parentGroupId == null || this.parentGroupId.isEmpty() || this.parentArtifactId == null || this.parentArtifactId.isEmpty()) {
                MavenProject mp = this.project.getParent();
                if (mp == null || mp.getGroupId() == null || mp.getGroupId().isEmpty() || mp.getArtifactId() == null || mp.getArtifactId().isEmpty()) {
                    return;
                }
                this.parentGroupId = mp.getGroupId();
                this.parentArtifactId = mp.getArtifactId();
            }
            this.parentGroupId = this.parentGroupId.replaceAll("\\.", "~").replaceAll("/", ":");
            this.parentArtifactId = this.parentArtifactId.replaceAll("\\.", "~").replaceAll("/", ":");
            if (this.project.getGroupId().equals(this.parentGroupId) && this.project.getArtifactId().equals(this.parentArtifactId)) {
                return;
            }
            this.getLog().debug((CharSequence)("group: " + this.parentGroupId + " artifact: " + this.parentArtifactId));
            String url = this.baseUrl + this.apiPath + "/projects/" + this.parentGroupId + "/" + this.parentArtifactId + "/merge_ga/" + childId + "?api_key=" + this.fetchApiKey();
            String response = HttpUtils.get(url);
            this.getLog().debug((CharSequence)("merge response: " + response));
        }
        catch (Exception ex) {
            this.getLog().error((Throwable)ex);
        }
    }
}

