/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.webview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.MutableContextWrapper;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.URLUtil;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.iab.omid.library.oath.adsession.AdEvents;
import com.iab.omid.library.oath.adsession.AdSession;
import com.iab.omid.library.oath.adsession.AdSessionConfiguration;
import com.iab.omid.library.oath.adsession.AdSessionContext;
import com.iab.omid.library.oath.adsession.Owner;
import com.iab.omid.library.oath.adsession.Partner;
import com.verizon.ads.Configuration;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.omsdk.OMSDKPlugin;
import com.verizon.ads.omsdk.OpenMeasurementService;
import com.verizon.ads.support.utils.ViewUtils;
import com.verizon.ads.utils.IOUtils;
import com.verizon.ads.utils.ThreadUtils;
import com.verizon.ads.webview.VASAdsWebChromeClient;
import com.verizon.ads.webview.VASAdsWebViewClient;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"ViewConstructor"})
public class VASAdsWebView
extends WebView {
    private static final Logger logger = Logger.getInstance(VASAdsWebView.class);
    private static final String WHO = VASAdsWebView.class.getSimpleName();
    private static final boolean USE_ACTIONS_QUEUE = Build.VERSION.SDK_INT < 19;
    private static final String VERIZON_ADS_DOMAIN = "com.verizon.ads";
    private static final String WATERFALL_PROVIDER_BASE_URL_KEY = "waterfallProviderBaseUrl";
    private static final String BASE_URL_DEFAULT = "http://ads.nexage.com";
    private static final Pattern htmlStartPattern = Pattern.compile("<html[^>]*>", 2);
    private static final Pattern headStartPattern = Pattern.compile("<head[^>]*>", 2);
    private static final Pattern bodyStartPattern = Pattern.compile("<body[^>]*>", 2);
    private static final Pattern nonMetaPattern = Pattern.compile("<(?!meta)[^>]*>", 2);
    private static final int ERROR_NULL_DATA = -1;
    private static final int ERROR_LOAD_DATA = -2;
    private volatile JSONArray actionsQueue;
    private GestureDetector gestureDetector;
    private volatile boolean destroyed = false;
    private volatile boolean beenTouched = false;
    static final String secureContentMeta = "<meta http-equiv=\"Content-Security-Policy\" content=\"upgrade-insecure-requests\">";
    static final String bodyStyling = "<style>body {margin:0;padding:0;}</style>";
    String currentUrl;
    VASAdsWebViewListener webViewListener;
    VASAdsWebViewClient webViewClient;
    volatile LoadDataListener loadDataListener;
    LinkedHashMap<String, String> scriptsToBeLoaded;
    AdSession omsdkAdSession;
    private AdEvents adEvents;

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    @TargetApi(value=17)
    public VASAdsWebView(Context context, VASAdsWebViewListener webViewListener) {
        super((Context)new MutableContextWrapper(context));
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d("Creating webview " + ((Object)((Object)this)).hashCode());
        }
        this.setTag("VASAdsWebView");
        this.webViewListener = webViewListener != null ? webViewListener : this.getNoOpWebViewListener();
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.gestureDetector = new GestureDetector(context.getApplicationContext(), (GestureDetector.OnGestureListener)new VASAdsWebViewGestureListener(this));
        this.webViewClient = new VASAdsWebViewClient();
        this.setWebViewClient(this.webViewClient);
        this.setWebChromeClient(new VASAdsWebChromeClient());
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setCacheMode(-1);
        webSettings.setDefaultTextEncodingName("UTF-8");
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setGeolocationEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 17) {
            logger.d("Disabling user gesture requirement for media playback");
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        webSettings.setAllowFileAccess(false);
        webSettings.setAllowContentAccess(false);
        webSettings.setAllowFileAccessFromFileURLs(false);
        webSettings.setAllowUniversalAccessFromFileURLs(false);
        this.scriptsToBeLoaded = new LinkedHashMap();
        if (USE_ACTIONS_QUEUE) {
            this.scriptsToBeLoaded.put("actionsQueue.js", "vas/actionsQueue.js");
        }
        List<String> extraScriptsToLoad = this.getExtraScriptsToLoad();
        for (String scriptAssetPath : extraScriptsToLoad) {
            if (scriptAssetPath == null) continue;
            this.scriptsToBeLoaded.put(scriptAssetPath.substring(scriptAssetPath.lastIndexOf(47) + 1), scriptAssetPath);
        }
        this.addJavascriptInterface(new CommonJavaScriptInterface(), "MmInjectedFunctions");
    }

    public void loadData(String data, String mimeType, String encoding, LoadDataListener loadDataListener) {
        String contentUrl = Configuration.getString((String)VERIZON_ADS_DOMAIN, (String)WATERFALL_PROVIDER_BASE_URL_KEY, (String)BASE_URL_DEFAULT);
        this.loadDataWithBaseURL(contentUrl, data, mimeType, encoding, null, loadDataListener);
    }

    public String getUrl() {
        if (this.destroyed) {
            return null;
        }
        return super.getUrl();
    }

    public void release() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("release must be called on the UI thread");
            return;
        }
        if (this.omsdkAdSession != null) {
            logger.d("Finishing the OMSDK Ad session.");
            this.omsdkAdSession.finish();
        }
        ThreadUtils.runOnUiThreadDelayed((Runnable)new Runnable(){

            @Override
            public void run() {
                VASAdsWebView.this.destroyed = true;
                if (Logger.isLogLevelEnabled((int)3)) {
                    logger.d("Releasing webview " + ((Object)((Object)VASAdsWebView.this)).hashCode());
                }
                if (VASAdsWebView.this.getParent() != null) {
                    ViewUtils.removeFromParent((View)VASAdsWebView.this);
                }
                VASAdsWebView.super.loadUrl("about:blank");
                VASAdsWebView.this.stopLoading();
                VASAdsWebView.this.setWebChromeClient(null);
                VASAdsWebView.this.setWebViewClient(null);
                try {
                    VASAdsWebView.this.destroy();
                }
                catch (Exception e) {
                    logger.e("An error occurred destroying the webview.", (Throwable)e);
                }
                VASAdsWebView.this.gestureDetector = null;
            }
        }, (long)1000L);
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        this.currentUrl = baseUrl;
        super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
    }

    public void loadDataWithBaseURL(final String baseUrl, String data, final String mimeType, final String encoding, final String historyUrl, LoadDataListener loadDataListener) {
        this.loadDataListener = loadDataListener;
        if (data == null) {
            this.onLoadComplete(new ErrorInfo(WHO, "data was null", -1));
            return;
        }
        this.currentUrl = baseUrl;
        boolean secureContent = URLUtil.isHttpsUrl((String)baseUrl);
        final boolean hasScriptsToInject = !this.scriptsToBeLoaded.isEmpty();
        String injectedContent = this.injectJavaScriptAssets(data, secureContent);
        try {
            OpenMeasurementService openMeasurementService = OMSDKPlugin.getMeasurementService();
            if (openMeasurementService != null) {
                injectedContent = openMeasurementService.enhanceHTML(injectedContent);
            }
        }
        catch (IOException e) {
            logger.e("Error injecting OMSDK scripts into HTML content.", (Throwable)e);
        }
        final String postProcessedInjectedContent = this.postProcessContent(injectedContent);
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Injected Content:\n%s", injectedContent));
        }
        ThreadUtils.postOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    VASAdsWebView.super.loadDataWithBaseURL(baseUrl, postProcessedInjectedContent, mimeType, encoding, historyUrl != null ? historyUrl : "vasadsdk");
                    if (!hasScriptsToInject) {
                        VASAdsWebView.this.onLoadComplete(null);
                    }
                }
                catch (Exception e) {
                    logger.e("Error occurred when calling through to loadDataWithBaseUrl", (Throwable)e);
                    VASAdsWebView.this.onLoadComplete(new ErrorInfo(WHO, "Exception occurred loading content.", -2));
                }
            }
        });
    }

    public void loadUrl(final String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            logger.e("Url is null or empty");
            return;
        }
        if (this.destroyed) {
            logger.d("Attempt to load url after webview has been destroyed");
            return;
        }
        if (url.startsWith("http")) {
            this.currentUrl = url;
        }
        ThreadUtils.postOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                VASAdsWebView.this.loadUrlOnUiThread(url);
            }
        });
    }

    public void fireImpression() {
        if (this.adEvents != null) {
            try {
                this.adEvents.impressionOccurred();
                logger.d("Fired OMSDK impression event.");
            }
            catch (Throwable t) {
                logger.e("Error occurred firing OMSDK Impression event.", t);
            }
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        this.beenTouched = true;
        if (this.gestureDetector != null) {
            this.gestureDetector.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public void callJavascript(String function, Object ... parameters) {
        block10: {
            JSONArray args = new JSONArray(Arrays.asList(parameters));
            try {
                if (!this.isInjectedJSReady()) {
                    if (Logger.isLogLevelEnabled((int)3)) {
                        logger.d("jsBridge scripts are not loaded: " + function + "(" + args.join(",") + ")");
                    }
                    return;
                }
                if (USE_ACTIONS_QUEUE) {
                    JSONObject json = new JSONObject();
                    json.put("functionName", (Object)function);
                    json.put("args", (Object)args);
                    VASAdsWebView vASAdsWebView = this;
                    synchronized (vASAdsWebView) {
                        if (Logger.isLogLevelEnabled((int)3)) {
                            logger.d("Queuing js: " + function + " args: " + args.toString());
                        }
                        if (this.actionsQueue == null) {
                            this.actionsQueue = new JSONArray();
                        }
                        this.actionsQueue.put((Object)json);
                        break block10;
                    }
                }
                final String js = function + "(" + args.join(",") + ")";
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Logger.isLogLevelEnabled((int)3)) {
                            logger.d("Calling js: " + js);
                        }
                        VASAdsWebView.this.evaluateJavascript(js, null);
                    }
                });
            }
            catch (JSONException e) {
                logger.e("Unable to execute javascript function", (Throwable)e);
            }
        }
    }

    protected boolean hasNotBeenTouched() {
        return !this.beenTouched;
    }

    String injectJavaScriptAssets(String content, boolean secureContent) {
        String injectedContent = secureContent ? "<meta http-equiv=\"Content-Security-Policy\" content=\"upgrade-insecure-requests\"><style>body {margin:0;padding:0;}</style>" : bodyStyling;
        injectedContent = injectedContent + this.buildScriptStatements(this.scriptsToBeLoaded.values());
        StringBuffer sb = new StringBuffer(content.length() + injectedContent.length() + 64);
        Matcher matcher = htmlStartPattern.matcher(content);
        boolean hasHtmlTag = matcher.find(0);
        if (!hasHtmlTag) {
            sb.append("<html>");
        }
        matcher.usePattern(headStartPattern);
        if (matcher.find()) {
            int start = matcher.end(0);
            matcher.usePattern(nonMetaPattern);
            matcher.region(start, matcher.regionEnd());
            if (matcher.find()) {
                matcher.appendReplacement(sb, "");
                sb.append(injectedContent).append(matcher.group(0));
            }
            matcher.appendTail(sb);
        } else {
            matcher.usePattern(bodyStartPattern);
            if (matcher.find()) {
                matcher.appendReplacement(sb, "");
                sb.append("<head>").append(injectedContent).append("</head>").append(matcher.group(0));
                matcher.appendTail(sb);
            } else if (!hasHtmlTag) {
                sb.append("<head>").append(injectedContent).append("</head><body>").append(content).append("</body>");
            }
        }
        if (!hasHtmlTag) {
            sb.append("</html>");
        }
        return sb.toString();
    }

    protected String buildScriptStatements(Collection<String> scriptAssets) {
        StringBuilder sb = new StringBuilder();
        for (String scriptAsset : scriptAssets) {
            sb.append("\n<script>");
            sb.append(this.getAssetContents(scriptAsset));
            sb.append("</script>");
        }
        return sb.toString();
    }

    boolean isInjectedJSReady() {
        return this.scriptsToBeLoaded.isEmpty();
    }

    boolean isOriginalUrl(String url) {
        return !TextUtils.isEmpty((CharSequence)this.currentUrl) && (url.startsWith(this.currentUrl + "?") || url.startsWith(this.currentUrl + "#"));
    }

    void prepareOMSDK() {
        ThreadUtils.postOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VASAdsWebView.this.omsdkAdSession != null) {
                    return;
                }
                logger.d("Preparing OMSDK");
                if (!VASAdsWebView.this.createOMSDKAdSession()) {
                    return;
                }
                try {
                    VASAdsWebView.this.adEvents = AdEvents.createAdEvents((AdSession)VASAdsWebView.this.omsdkAdSession);
                    VASAdsWebView.this.omsdkAdSession.registerAdView((View)VASAdsWebView.this);
                    logger.d("Starting the OMSDK Ad Session.");
                    VASAdsWebView.this.omsdkAdSession.start();
                }
                catch (Throwable t) {
                    logger.e("OMSDK is disabled - error starting OMSDK Ad Session.", t);
                    VASAdsWebView.this.omsdkAdSession = null;
                    VASAdsWebView.this.adEvents = null;
                }
            }
        });
    }

    boolean createOMSDKAdSession() {
        OpenMeasurementService openMeasurementService = OMSDKPlugin.getMeasurementService();
        if (openMeasurementService == null) {
            logger.d("OMSDK is disabled");
            return false;
        }
        try {
            AdSessionContext context = AdSessionContext.createHtmlAdSessionContext((Partner)openMeasurementService.getPartner(), (WebView)this, (String)"");
            AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((Owner)Owner.NATIVE, null, (boolean)false);
            this.omsdkAdSession = AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration, (AdSessionContext)context);
            return true;
        }
        catch (Throwable t) {
            logger.e("OMSDK is disabled - error initializing OMSDK Ad Session.", t);
            return false;
        }
    }

    protected List<String> getExtraScriptsToLoad() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAssetContents(String assetPath) {
        InputStream is = null;
        try {
            is = this.getContext().getAssets().open(assetPath);
            String string = IOUtils.convertStreamToString((InputStream)is);
            return string;
        }
        catch (IOException e) {
            logger.e("Error opening asset input stream", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.e("Error closing asset input stream", (Throwable)e);
                }
            }
        }
        return "";
    }

    protected VASAdsWebViewListener getNoOpWebViewListener() {
        return new VASAdsWebViewListener(){

            @Override
            public void onError(ErrorInfo errorInfo) {
            }

            @Override
            public void onAdLeftApplication(VASAdsWebView vasAdsWebView) {
            }

            @Override
            public void onClicked(VASAdsWebView vasAdsWebView) {
            }
        };
    }

    protected void onLoadComplete(ErrorInfo errorInfo) {
        this.prepareOMSDK();
        if (this.loadDataListener != null) {
            this.loadDataListener.onComplete(errorInfo);
            this.loadDataListener = null;
        }
    }

    protected String postProcessContent(String content) {
        return content;
    }

    private void loadUrlOnUiThread(String url) {
        if (this.destroyed) {
            logger.d("Attempt to loadUrlOnUiThread after webview has been destroyed");
            return;
        }
        try {
            super.loadUrl(url);
        }
        catch (Exception e) {
            logger.e("Error loading url", (Throwable)e);
        }
    }

    class CommonJavaScriptInterface {
        CommonJavaScriptInterface() {
        }

        @JavascriptInterface
        public Boolean useActionsQueue() {
            return USE_ACTIONS_QUEUE;
        }

        @JavascriptInterface
        public synchronized String getActionsQueue() {
            if (VASAdsWebView.this.actionsQueue != null) {
                String result = VASAdsWebView.this.actionsQueue.toString();
                VASAdsWebView.this.actionsQueue = null;
                return result;
            }
            return null;
        }

        @JavascriptInterface
        public void fileLoaded(String args) throws JSONException {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("fileLoaded: " + args);
            }
            JSONObject json = new JSONObject(args);
            VASAdsWebView.this.scriptsToBeLoaded.remove(json.getString("filename"));
            if (VASAdsWebView.this.isInjectedJSReady()) {
                VASAdsWebView.this.onLoadComplete(null);
            }
        }
    }

    static class VASAdsWebViewGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private WeakReference<VASAdsWebView> vasAdsWebViewWeakRef;

        VASAdsWebViewGestureListener(VASAdsWebView vasAdsWebView) {
            this.vasAdsWebViewWeakRef = new WeakReference<VASAdsWebView>(vasAdsWebView);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            VASAdsWebView vasAdsWebView = (VASAdsWebView)((Object)this.vasAdsWebViewWeakRef.get());
            if (vasAdsWebView != null) {
                vasAdsWebView.webViewListener.onClicked(vasAdsWebView);
            }
            return true;
        }
    }

    public static interface LoadDataListener {
        public void onComplete(ErrorInfo var1);
    }

    public static interface VASAdsWebViewListener {
        public void onError(ErrorInfo var1);

        public void onAdLeftApplication(VASAdsWebView var1);

        public void onClicked(VASAdsWebView var1);
    }
}

