/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.videoplayer;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.AbsSavedState;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import androidx.annotation.NonNull;
import com.verizon.ads.Component;
import com.verizon.ads.ComponentFactory;
import com.verizon.ads.Logger;
import com.verizon.ads.VideoPlayer;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class VerizonVideoPlayer
implements VideoPlayer {
    private static final Logger logger = Logger.getInstance(VerizonVideoPlayer.class);
    private static final int DEFAULT_PROGRESS_POLLING_INTERVAL = 1000;
    private static final int MIN_PROGRESS_POLLING_INTERVAL = 100;
    private static final int MEDIA_ERROR_EXTRA_AUDIO_NO_INIT = -19;
    private static final int MEDIA_ERROR_STATE_EXCEPTION = -38;
    private final ExecutorService callbackExecutor;
    private final Set<VideoPlayer.VideoPlayerListener> listeners;
    private final WeakReference<Context> contextWeakRef;
    private Uri uri;
    private int videoWidth;
    private int videoHeight;
    private MediaPlayer mediaPlayer;
    private WeakReference<SurfaceView> surfaceViewWeakReference;
    private SurfaceHolder surfaceHolder;
    private float volume = 1.0f;
    private ProgressHandler progressHandler;
    private HandlerThread progressHandlerThread;
    private int progressInterval = 1000;
    private int seekToMilliseconds = 0;
    private volatile int targetState;
    private volatile int currentState = 0;

    public VerizonVideoPlayer(Context context) {
        this.contextWeakRef = new WeakReference<Context>(context);
        this.callbackExecutor = Executors.newSingleThreadExecutor();
        this.listeners = new HashSet<VideoPlayer.VideoPlayerListener>();
    }

    public void setSurfaceView(SurfaceView surfaceView) {
        this.surfaceViewWeakReference = new WeakReference<SurfaceView>(surfaceView);
        this.surfaceHolder = surfaceView.getHolder();
        this.surfaceHolder.addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                VerizonVideoPlayer.this.onSurfaceCreated(holder);
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                if (VerizonVideoPlayer.this.mediaPlayer != null && VerizonVideoPlayer.this.targetState == 4) {
                    VerizonVideoPlayer.this.play();
                }
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                VerizonVideoPlayer.this.surfaceHolder = null;
                if (VerizonVideoPlayer.this.mediaPlayer != null) {
                    VerizonVideoPlayer.this.mediaPlayer.setDisplay(null);
                }
            }
        });
        surfaceView.getHolder().setType(3);
        surfaceView.setOnClickListener(view -> this.postToCallbackExecutor(() -> {
            for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                listener.onClick((VideoPlayer)this);
            }
        }));
    }

    @NonNull
    public AbsSavedState saveInstanceState(Parcelable parcelable) {
        VideoViewInfo videoViewInfo = new VideoViewInfo(parcelable);
        videoViewInfo.currentState = this.currentState;
        videoViewInfo.targetState = this.targetState;
        videoViewInfo.currentPosition = this.getCurrentPosition();
        videoViewInfo.volume = this.getVolume();
        videoViewInfo.uri = this.uri != null ? this.uri.toString() : null;
        return videoViewInfo;
    }

    public void restoreInstanceState(AbsSavedState absSavedState) {
        if (absSavedState instanceof VideoViewInfo) {
            VideoViewInfo videoViewInfo = (VideoViewInfo)absSavedState;
            this.targetState = videoViewInfo.targetState;
            this.seekToMilliseconds = videoViewInfo.currentPosition;
            this.setVolume(videoViewInfo.volume);
            if (videoViewInfo.uri != null) {
                this.load(videoViewInfo.uri);
            }
            if (videoViewInfo.currentState == 4 || videoViewInfo.targetState == 4) {
                this.play();
            }
        }
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public void unload() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("unload must be called from UI thread.");
            return;
        }
        if (this.mediaPlayer != null) {
            if (this.progressHandlerThread != null) {
                this.progressHandlerThread.quit();
            }
            this.mediaPlayer.setDisplay(null);
            this.mediaPlayer.reset();
            this.mediaPlayer.release();
            this.mediaPlayer = null;
            this.currentState = 0;
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onUnloaded((VideoPlayer)this);
                }
            });
        }
    }

    public void load(Uri uri) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("load must be called from UI thread.");
            return;
        }
        this.uri = uri;
        if (uri == null) {
            return;
        }
        this.unload();
        this.progressHandlerThread = new HandlerThread("vp-progress-handler");
        this.progressHandlerThread.start();
        this.progressHandler = new ProgressHandler(this, this.progressHandlerThread.getLooper(), this.progressInterval);
        this.mediaPlayer = new MediaPlayer();
        if (this.surfaceHolder != null && this.surfaceHolder.getSurface().isValid()) {
            this.mediaPlayer.setDisplay(this.surfaceHolder);
        }
        MediaPlayerListener mediaPlayerListener = new MediaPlayerListener(this);
        this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)mediaPlayerListener);
        this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)mediaPlayerListener);
        this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)mediaPlayerListener);
        this.mediaPlayer.setOnSeekCompleteListener(mp -> this.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)mediaPlayerListener));
        this.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)mediaPlayerListener);
        try {
            Context context = (Context)this.contextWeakRef.get();
            if (context == null) {
                logger.d("load cannot complete; context has been released.");
                return;
            }
            this.mediaPlayer.setDataSource(context, uri, null);
            this.currentState = 1;
            this.mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            logger.e("An error occurred preparing the VideoPlayer.", (Throwable)e);
            this.currentState = 7;
            this.targetState = 7;
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onError((VideoPlayer)this);
                }
            });
        }
    }

    public void load(String path) {
        this.load(Uri.parse((String)path));
    }

    public void replay() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("replay must be called from UI thread.");
            return;
        }
        if (Build.VERSION.SDK_INT <= 21) {
            if (this.uri == null) {
                return;
            }
            this.load(this.uri);
        } else {
            this.seekTo(0);
        }
        this.play();
    }

    public void play() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("play must be called from UI thread.");
            return;
        }
        if (this.isInPlaybackState() && this.currentState != 4) {
            this.setVolume(this.volume);
            if (this.seekToMilliseconds != 0) {
                this.mediaPlayer.seekTo(this.seekToMilliseconds);
                this.seekToMilliseconds = 0;
            }
            this.mediaPlayer.start();
            this.currentState = 4;
            this.targetState = 4;
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onPlay((VideoPlayer)this);
                }
            });
            this.progressHandler.sendStartMessage();
        } else {
            this.targetState = 4;
        }
    }

    public void pause() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("pause must be called from UI thread.");
            return;
        }
        if (this.isInPlaybackState() && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.pause();
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onPaused((VideoPlayer)this);
                }
            });
            this.currentState = 5;
            this.targetState = 5;
        }
    }

    public void seekTo(int milliseconds) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("seekTo must be called from UI thread.");
            return;
        }
        if (this.isInPlaybackState()) {
            this.mediaPlayer.seekTo(milliseconds);
            this.seekToMilliseconds = 0;
        } else {
            this.seekToMilliseconds = milliseconds;
        }
    }

    public void setVolume(float volume) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setVolume must be called from UI thread.");
            return;
        }
        this.volume = volume;
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setVolume(volume, volume);
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onVolumeChanged((VideoPlayer)this, volume);
                }
            });
        }
        this.setAudioFocus();
    }

    public float getVolume() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("getVolume must be called from UI thread.");
            return -1.0f;
        }
        return this.volume;
    }

    public int getCurrentPosition() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("getCurrentPosition must be called from UI thread.");
            return -1;
        }
        if (this.isInPlaybackState()) {
            return this.mediaPlayer.getCurrentPosition();
        }
        return -1;
    }

    public int getDuration() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("getDuration must be called from UI thread.");
            return -1;
        }
        if (this.isInPlaybackState() || this.currentState == 2) {
            return this.mediaPlayer.getDuration();
        }
        return -1;
    }

    public void registerListener(VideoPlayer.VideoPlayerListener videoPlayerListener) {
        if (videoPlayerListener == null) {
            logger.w("Cannot register a null instance.");
            return;
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("registerListener must be called from UI thread.");
            return;
        }
        this.postToCallbackExecutor(() -> this.listeners.add(videoPlayerListener));
    }

    public void unregisterListener(VideoPlayer.VideoPlayerListener videoPlayerListener) {
        if (videoPlayerListener == null) {
            logger.w("Cannot unregister a null instance.");
            return;
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("unregisterListener must be called from UI thread.");
            return;
        }
        this.postToCallbackExecutor(() -> this.listeners.remove(videoPlayerListener));
    }

    public int getState() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("unregisterListener must be called from UI thread.");
            return -1;
        }
        return this.currentState;
    }

    public void setProgressInterval(int progressInterval) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setProgressInterval must be called from UI thread.");
            return;
        }
        int n = this.progressInterval = progressInterval < 100 && progressInterval != -1 ? 100 : progressInterval;
        if (this.progressHandler != null) {
            this.progressHandler.setInterval(progressInterval);
        }
    }

    public void setAudioFocus() {
        Context context = (Context)this.contextWeakRef.get();
        if (context == null) {
            logger.d("setAudioFocus is not available. context was released.");
            return;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            if (this.volume > 0.0f) {
                audioManager.requestAudioFocus(null, 3, 3);
            } else {
                audioManager.abandonAudioFocus(null);
            }
        }
    }

    public void releaseAudioFocus() {
        Context context = (Context)this.contextWeakRef.get();
        if (context == null) {
            logger.d("releaseAudioFocus is not available. context was released.");
            return;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            audioManager.abandonAudioFocus(null);
        }
    }

    boolean isInPlaybackState() {
        return this.currentState != 0 && this.currentState != 1 && this.currentState != 2 && this.currentState != 7;
    }

    void postToCallbackExecutor(Runnable r) {
        if (this.callbackExecutor != null && !this.callbackExecutor.isShutdown()) {
            this.callbackExecutor.submit(r);
        }
    }

    void onSurfaceCreated(SurfaceHolder holder) {
        this.surfaceHolder = holder;
        if (!this.surfaceHolder.getSurface().isValid()) {
            this.currentState = 7;
            this.targetState = 7;
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onError((VideoPlayer)this);
                }
            });
            return;
        }
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setDisplay(this.surfaceHolder);
        }
        if (this.currentState == 2) {
            this.setAudioFocus();
            this.currentState = 3;
            SurfaceView surfaceView = (SurfaceView)this.surfaceViewWeakReference.get();
            if (surfaceView != null && this.videoWidth != 0 && this.videoHeight != 0) {
                surfaceView.requestLayout();
            }
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onReady((VideoPlayer)this);
                }
            });
            if (this.targetState == 4) {
                this.play();
            }
        }
    }

    public void release() {
        this.unload();
    }

    static class ProgressHandler
    extends Handler {
        private static final int START = 1;
        private static final int STOP = 2;
        private static final int UPDATE = 3;
        private static final int SET_INTERVAL = 4;
        private final WeakReference<VerizonVideoPlayer> verizonVideoPlayerRef;
        private boolean started = false;
        private int interval;

        ProgressHandler(VerizonVideoPlayer verizonVideoPlayer, Looper looper, int interval) {
            super(looper);
            this.verizonVideoPlayerRef = new WeakReference<VerizonVideoPlayer>(verizonVideoPlayer);
            this.interval = interval;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.doStart(false);
                    break;
                }
                case 2: {
                    this.doStop();
                    break;
                }
                case 3: {
                    this.doUpdate();
                    break;
                }
                case 4: {
                    this.doSetInterval(msg.arg1);
                    break;
                }
                default: {
                    logger.e(String.format("Invalid what %d sent to ProgressHandler.", msg.what));
                }
            }
        }

        void sendStartMessage() {
            this.sendEmptyMessage(1);
        }

        void sendStopMessage() {
            this.sendEmptyMessage(2);
        }

        void setInterval(int interval) {
            this.sendMessage(this.obtainMessage(4, interval, 0));
        }

        private void doStart(boolean intervalChanged) {
            if (this.interval == -1) {
                return;
            }
            if (this.started) {
                return;
            }
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Starting progress handler with interval %d ms.", this.interval));
            }
            this.started = true;
            if (intervalChanged) {
                this.sendEmptyMessageDelayed(3, this.interval);
            } else {
                this.sendEmptyMessage(3);
            }
        }

        private void doStop() {
            if (!this.started) {
                return;
            }
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("Stopping progress handler.");
            }
            this.started = false;
            this.removeMessages(3);
        }

        private void doUpdate() {
            VerizonVideoPlayer verizonVideoPlayer = (VerizonVideoPlayer)this.verizonVideoPlayerRef.get();
            if (verizonVideoPlayer != null) {
                int currentPosition = verizonVideoPlayer.mediaPlayer.getCurrentPosition();
                verizonVideoPlayer.postToCallbackExecutor(() -> {
                    for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayer.listeners) {
                        listener.onProgress((VideoPlayer)verizonVideoPlayer, currentPosition);
                    }
                });
                this.sendEmptyMessageDelayed(3, this.interval);
            }
        }

        private void doSetInterval(int interval) {
            this.interval = interval;
            if (!this.started) {
                return;
            }
            this.doStop();
            if (this.interval != -1) {
                this.doStart(true);
            }
        }
    }

    static class VideoViewInfo
    extends View.BaseSavedState {
        public static final Parcelable.Creator<VideoViewInfo> CREATOR = new Parcelable.Creator<VideoViewInfo>(){

            public VideoViewInfo createFromParcel(Parcel source) {
                return new VideoViewInfo(source);
            }

            public VideoViewInfo[] newArray(int size) {
                return new VideoViewInfo[size];
            }
        };
        int currentState;
        int targetState;
        int currentPosition;
        float volume;
        String uri;

        VideoViewInfo(Parcelable superState) {
            super(superState);
        }

        private VideoViewInfo(Parcel source) {
            super(source);
            this.currentState = source.readInt();
            this.targetState = source.readInt();
            this.currentPosition = source.readInt();
            this.volume = source.readFloat();
            this.uri = source.readString();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentState);
            dest.writeInt(this.targetState);
            dest.writeInt(this.currentPosition);
            dest.writeFloat(this.volume);
            dest.writeString(this.uri);
        }
    }

    static class MediaPlayerListener
    implements MediaPlayer.OnCompletionListener,
    MediaPlayer.OnErrorListener,
    MediaPlayer.OnPreparedListener,
    MediaPlayer.OnVideoSizeChangedListener,
    MediaPlayer.OnSeekCompleteListener {
        private final WeakReference<VerizonVideoPlayer> verizonVideoPlayerRef;

        MediaPlayerListener(VerizonVideoPlayer verizonVideoPlayer) {
            this.verizonVideoPlayerRef = new WeakReference<VerizonVideoPlayer>(verizonVideoPlayer);
        }

        public void onCompletion(MediaPlayer mediaPlayer) {
            VerizonVideoPlayer verizonVideoPlayer = (VerizonVideoPlayer)this.verizonVideoPlayerRef.get();
            if (verizonVideoPlayer != null) {
                verizonVideoPlayer.currentState = 6;
                verizonVideoPlayer.targetState = 6;
                verizonVideoPlayer.progressHandler.sendStopMessage();
                int duration = verizonVideoPlayer.getDuration();
                verizonVideoPlayer.postToCallbackExecutor(() -> {
                    for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayer.listeners) {
                        listener.onProgress((VideoPlayer)verizonVideoPlayer, duration);
                        listener.onComplete((VideoPlayer)verizonVideoPlayer);
                    }
                });
            }
        }

        public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
            VerizonVideoPlayer verizonVideoPlayer = (VerizonVideoPlayer)this.verizonVideoPlayerRef.get();
            if (verizonVideoPlayer != null) {
                if (what == 1 && extra == -19 || what == -38) {
                    if (Logger.isLogLevelEnabled((int)3)) {
                        logger.d(String.format("Ignoring acceptable media error: (%d, %d)", what, extra));
                    }
                    return true;
                }
                verizonVideoPlayer.currentState = 7;
                verizonVideoPlayer.postToCallbackExecutor(() -> {
                    for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayer.listeners) {
                        listener.onError((VideoPlayer)verizonVideoPlayer);
                    }
                });
            }
            return true;
        }

        public void onPrepared(MediaPlayer mediaPlayer) {
            mediaPlayer.seekTo(1);
            VerizonVideoPlayer verizonVideoPlayer = (VerizonVideoPlayer)this.verizonVideoPlayerRef.get();
            if (verizonVideoPlayer != null) {
                if (verizonVideoPlayer.surfaceHolder != null && verizonVideoPlayer.surfaceHolder.getSurface().isValid()) {
                    verizonVideoPlayer.setAudioFocus();
                    verizonVideoPlayer.currentState = 3;
                    verizonVideoPlayer.postToCallbackExecutor(() -> {
                        for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayer.listeners) {
                            listener.onLoaded((VideoPlayer)verizonVideoPlayer);
                            listener.onReady((VideoPlayer)verizonVideoPlayer);
                        }
                    });
                    if (verizonVideoPlayer.targetState == 4) {
                        verizonVideoPlayer.play();
                    }
                } else {
                    verizonVideoPlayer.currentState = 2;
                    verizonVideoPlayer.postToCallbackExecutor(() -> {
                        for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayer.listeners) {
                            listener.onLoaded((VideoPlayer)verizonVideoPlayer);
                        }
                    });
                }
            }
        }

        public void onSeekComplete(MediaPlayer mp) {
            VerizonVideoPlayer verizonVideoPlayer = (VerizonVideoPlayer)this.verizonVideoPlayerRef.get();
            if (verizonVideoPlayer != null) {
                verizonVideoPlayer.postToCallbackExecutor(() -> {
                    for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayer.listeners) {
                        listener.onSeekCompleted((VideoPlayer)verizonVideoPlayer);
                    }
                });
            }
        }

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            VerizonVideoPlayer verizonVideoPlayer = (VerizonVideoPlayer)this.verizonVideoPlayerRef.get();
            if (verizonVideoPlayer != null && height != 0 && width != 0) {
                verizonVideoPlayer.videoWidth = width;
                verizonVideoPlayer.videoHeight = height;
                SurfaceView surfaceView = (SurfaceView)verizonVideoPlayer.surfaceViewWeakReference.get();
                if (surfaceView != null) {
                    surfaceView.requestLayout();
                }
                verizonVideoPlayer.postToCallbackExecutor(() -> {
                    for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayer.listeners) {
                        listener.onVideoSizeChanged(width, height);
                    }
                });
            }
        }
    }

    static class Factory
    implements ComponentFactory {
        Factory() {
        }

        public Component newInstance(Context context, JSONObject jsonObject, Object ... objects) {
            return new VerizonVideoPlayer(context);
        }
    }
}

