/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.videoplayer;

import android.content.Context;
import android.content.MutableContextWrapper;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.ToggleButton;
import androidx.annotation.NonNull;
import com.verizon.ads.Component;
import com.verizon.ads.ComponentFactory;
import com.verizon.ads.Logger;
import com.verizon.ads.VideoPlayer;
import com.verizon.ads.VideoPlayerView;
import com.verizon.ads.utils.ThreadUtils;
import com.verizon.ads.videoplayer.R;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class VerizonVideoPlayerView
extends VideoPlayerView {
    private static final Logger logger = Logger.getInstance(VerizonVideoPlayerView.class);
    private static final int DEFAULT_PROGRESS_POLLING_INTERVAL = 1000;
    private static final int MIN_PROGRESS_POLLING_INTERVAL = 100;
    private static final int MEDIA_ERROR_EXTRA_AUDIO_NO_INIT = -19;
    private static final int MEDIA_ERROR_STATE_EXCEPTION = -38;
    private final ExecutorService callbackExecutor = Executors.newSingleThreadExecutor();
    private final Set<VideoPlayer.VideoPlayerListener> listeners = new HashSet<VideoPlayer.VideoPlayerListener>();
    private Uri uri;
    private int videoWidth;
    private int videoHeight;
    private MediaPlayer mediaPlayer;
    private SurfaceHolder surfaceHolder;
    private RelativeLayout relativeLayout;
    private float volume = 1.0f;
    private ProgressHandler progressHandler;
    private HandlerThread progressHandlerThread;
    private int progressInterval = 1000;
    private Button replayButton;
    private Button playButton;
    private ToggleButton muteToggleButton;
    private boolean isReplayButtonEnabled = false;
    private boolean isPlayButtonEnabled = false;
    private boolean isMuteToggleEnabled = false;
    private int seekToMilliseconds = 0;
    private volatile int targetState;
    private volatile int currentState = 0;

    public VerizonVideoPlayerView(Context context) {
        this(context, null, 0);
    }

    public VerizonVideoPlayerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VerizonVideoPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super((Context)new MutableContextWrapper(context), attrs, defStyleAttr);
        this.setBackgroundColor(this.getResources().getColor(17170444));
        MutableContextWrapper mutableContext = (MutableContextWrapper)this.getContext();
        this.relativeLayout = new RelativeLayout(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.relativeLayout, (ViewGroup.LayoutParams)layoutParams);
        VideoSurfaceView surfaceView = new VideoSurfaceView((Context)mutableContext);
        surfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                VerizonVideoPlayerView.this.onSurfaceCreated(holder);
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                if (VerizonVideoPlayerView.this.mediaPlayer != null && VerizonVideoPlayerView.this.targetState == 4) {
                    VerizonVideoPlayerView.this.play();
                }
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                VerizonVideoPlayerView.this.surfaceHolder = null;
                if (VerizonVideoPlayerView.this.mediaPlayer != null) {
                    VerizonVideoPlayerView.this.mediaPlayer.setDisplay(null);
                }
            }
        });
        surfaceView.getHolder().setType(3);
        surfaceView.setOnClickListener(view -> this.postToCallbackExecutor(() -> {
            for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                listener.onClick((VideoPlayer)this);
            }
        }));
        this.relativeLayout.setOnClickListener(view -> {
            for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                listener.onClick((VideoPlayer)this);
            }
        });
        RelativeLayout.LayoutParams surfaceLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        surfaceLayoutParams.addRule(13);
        this.relativeLayout.addView((View)surfaceView, (ViewGroup.LayoutParams)surfaceLayoutParams);
        this.setupVideoControls();
    }

    void setupVideoControls() {
        Context context = this.getContext();
        this.muteToggleButton = new ToggleButton(context);
        this.muteToggleButton.setText((CharSequence)"");
        this.muteToggleButton.setTextOff((CharSequence)"");
        this.muteToggleButton.setTextOn((CharSequence)"");
        this.muteToggleButton.setTag((Object)"MUTE_UNMUTE_TOGGLE");
        this.muteToggleButton.setBackgroundResource(R.drawable.verizon_ads_sdk_mute_toggle);
        this.muteToggleButton.setOnCheckedChangeListener((buttonView, isChecked) -> this.setVolume(isChecked ? 1.0f : 0.0f));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_mute_width), (int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_mute_width));
        layoutParams.addRule(12);
        layoutParams.addRule(11);
        this.relativeLayout.addView((View)this.muteToggleButton, (ViewGroup.LayoutParams)layoutParams);
        this.replayButton = new Button(context);
        this.replayButton.setTag((Object)"REPLAY_BUTTON");
        this.replayButton.setBackgroundResource(R.drawable.verizon_ads_sdk_replay);
        this.replayButton.setOnClickListener(v -> this.replay());
        layoutParams = new RelativeLayout.LayoutParams((int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width), (int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width));
        layoutParams.addRule(13);
        this.relativeLayout.addView((View)this.replayButton, (ViewGroup.LayoutParams)layoutParams);
        this.playButton = new Button(context);
        this.playButton.setTag((Object)"PLAY_BUTTON");
        this.playButton.setBackgroundResource(R.drawable.verizon_ads_sdk_play);
        this.playButton.setOnClickListener(v -> this.play());
        layoutParams = new RelativeLayout.LayoutParams((int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width), (int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width));
        layoutParams.addRule(13);
        this.relativeLayout.addView((View)this.playButton, (ViewGroup.LayoutParams)layoutParams);
        this.updateReplayVisibility();
        this.updateMuteToggleVisibility();
        this.updatePlayVisibility();
    }

    void restoreFromVideoViewInfo(VideoViewInfo videoViewInfo) {
        this.targetState = videoViewInfo.targetState;
        this.seekToMilliseconds = videoViewInfo.currentPosition;
        this.setVolume(videoViewInfo.volume);
        if (this.muteToggleButton != null) {
            if (videoViewInfo.volume == 0.0f) {
                this.muteToggleButton.setChecked(false);
            } else {
                this.muteToggleButton.setChecked(true);
            }
        }
        if (videoViewInfo.currentState == 4 || videoViewInfo.targetState == 4) {
            this.play();
        }
    }

    protected Parcelable onSaveInstanceState() {
        return this.createVideoViewInfo(super.onSaveInstanceState());
    }

    protected void onRestoreInstanceState(Parcelable state) {
        VideoViewInfo videoViewInfo = (VideoViewInfo)state;
        super.onRestoreInstanceState(videoViewInfo.getSuperState());
        this.restoreFromVideoViewInfo(videoViewInfo);
    }

    @NonNull
    Parcelable createVideoViewInfo(Parcelable parentState) {
        VideoViewInfo videoViewInfo = new VideoViewInfo(parentState);
        videoViewInfo.currentState = this.currentState;
        videoViewInfo.targetState = this.targetState;
        videoViewInfo.currentPosition = this.getCurrentPosition();
        videoViewInfo.volume = this.getVolume();
        videoViewInfo.uri = this.uri != null ? this.uri.toString() : null;
        return videoViewInfo;
    }

    public void unload() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("unload must be called from UI thread.");
            return;
        }
        if (this.mediaPlayer != null) {
            if (this.progressHandlerThread != null) {
                this.progressHandlerThread.quit();
            }
            this.mediaPlayer.setDisplay(null);
            this.mediaPlayer.reset();
            this.mediaPlayer.release();
            this.mediaPlayer = null;
            this.currentState = 0;
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onUnloaded((VideoPlayer)this);
                }
            });
        }
    }

    public void load(Uri uri) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("load must be called from UI thread.");
            return;
        }
        this.uri = uri;
        if (uri == null) {
            return;
        }
        this.unload();
        this.progressHandlerThread = new HandlerThread("vp-progress-handler");
        this.progressHandlerThread.start();
        this.progressHandler = new ProgressHandler(this, this.progressHandlerThread.getLooper(), this.progressInterval);
        this.mediaPlayer = new MediaPlayer();
        if (this.surfaceHolder != null) {
            this.mediaPlayer.setDisplay(this.surfaceHolder);
        }
        MediaPlayerListener mediaPlayerListener = new MediaPlayerListener(this);
        this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)mediaPlayerListener);
        this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)mediaPlayerListener);
        this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)mediaPlayerListener);
        this.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)mediaPlayerListener);
        this.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)mediaPlayerListener);
        try {
            this.mediaPlayer.setDataSource(this.getContext(), uri, null);
            this.currentState = 1;
            this.mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            logger.e("An error occurred preparing the VideoPlayer.", (Throwable)e);
            this.currentState = 7;
            this.targetState = 7;
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onError((VideoPlayer)this);
                }
            });
        }
    }

    public void load(String path) {
        this.load(Uri.parse((String)path));
    }

    public void replay() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("replay must be called from UI thread.");
            return;
        }
        if (Build.VERSION.SDK_INT <= 21) {
            if (this.uri == null) {
                return;
            }
            this.load(this.uri);
        } else {
            this.seekTo(0);
        }
        this.play();
    }

    public void play() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("play must be called from UI thread.");
            return;
        }
        if (this.isInPlaybackState() && this.currentState != 4) {
            this.setVolume(this.volume);
            if (this.seekToMilliseconds != 0) {
                this.mediaPlayer.seekTo(this.seekToMilliseconds);
                this.seekToMilliseconds = 0;
            }
            this.mediaPlayer.start();
            this.currentState = 4;
            this.targetState = 4;
            this.updateReplayVisibility();
            this.updatePlayVisibility();
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onPlay((VideoPlayer)this);
                }
            });
            this.progressHandler.sendStartMessage();
        } else {
            this.targetState = 4;
        }
    }

    public void pause() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("pause must be called from UI thread.");
            return;
        }
        if (this.isInPlaybackState() && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.pause();
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onPaused((VideoPlayer)this);
                }
            });
            this.currentState = 5;
            this.targetState = 5;
        }
    }

    public void seekTo(int milliseconds) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("seekTo must be called from UI thread.");
            return;
        }
        if (this.isInPlaybackState()) {
            this.mediaPlayer.seekTo(milliseconds);
            this.seekToMilliseconds = 0;
        } else {
            this.seekToMilliseconds = milliseconds;
        }
    }

    public void setVolume(float volume) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setVolume must be called from UI thread.");
            return;
        }
        this.volume = volume;
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setVolume(volume, volume);
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onVolumeChanged((VideoPlayer)this, volume);
                }
            });
        }
        this.setAudioFocus();
    }

    public float getVolume() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("getVolume must be called from UI thread.");
            return -1.0f;
        }
        return this.volume;
    }

    public int getCurrentPosition() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("getCurrentPosition must be called from UI thread.");
            return -1;
        }
        if (this.isInPlaybackState()) {
            return this.mediaPlayer.getCurrentPosition();
        }
        return -1;
    }

    public int getDuration() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("getDuration must be called from UI thread.");
            return -1;
        }
        if (this.isInPlaybackState() || this.currentState == 2) {
            return this.mediaPlayer.getDuration();
        }
        return -1;
    }

    public void registerListener(VideoPlayer.VideoPlayerListener videoPlayerListener) {
        if (videoPlayerListener == null) {
            logger.w("Cannot register a null instance.");
            return;
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("registerListener must be called from UI thread.");
            return;
        }
        this.postToCallbackExecutor(() -> this.listeners.add(videoPlayerListener));
    }

    public void unregisterListener(VideoPlayer.VideoPlayerListener videoPlayerListener) {
        if (videoPlayerListener == null) {
            logger.w("Cannot unregister a null instance.");
            return;
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("unregisterListener must be called from UI thread.");
            return;
        }
        this.postToCallbackExecutor(() -> this.listeners.remove(videoPlayerListener));
    }

    public int getState() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("unregisterListener must be called from UI thread.");
            return -1;
        }
        return this.currentState;
    }

    public void setProgressInterval(int progressInterval) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setProgressInterval must be called from UI thread.");
            return;
        }
        int n = this.progressInterval = progressInterval < 100 && progressInterval != -1 ? 100 : progressInterval;
        if (this.progressHandler != null) {
            this.progressHandler.setInterval(progressInterval);
        }
    }

    public void setMuteToggleEnabled(boolean isMuteToggleEnabled) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setMuteToggleEnabled must be called from UI thread.");
            return;
        }
        this.isMuteToggleEnabled = isMuteToggleEnabled;
        this.updateMuteToggleVisibility();
    }

    private void updateMuteToggleVisibility() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("updateMuteToggleVisibility must be called from UI thread.");
            return;
        }
        if (this.muteToggleButton != null) {
            if (this.isMuteToggleEnabled) {
                this.muteToggleButton.setVisibility(0);
            } else {
                this.muteToggleButton.setVisibility(8);
            }
        }
    }

    public void setReplayButtonEnabled(boolean isReplayButtonEnabled) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setReplayButtonEnabled must be called from UI thread.");
            return;
        }
        this.isReplayButtonEnabled = isReplayButtonEnabled;
        this.updateReplayVisibility();
    }

    private void updateReplayVisibility() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("updateReplayVisibility must be called from UI thread.");
            return;
        }
        if (this.replayButton != null) {
            if (this.isReplayButtonEnabled && this.currentState == 6) {
                this.replayButton.setVisibility(0);
            } else {
                this.replayButton.setVisibility(8);
            }
        }
    }

    public void setPlayButtonEnabled(boolean isPlayButtonEnabled) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setPlayButtonEnabled must be called from UI thread.");
            return;
        }
        this.isPlayButtonEnabled = isPlayButtonEnabled;
        this.updatePlayVisibility();
    }

    private void updatePlayVisibility() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("updatePlayVisibility must be called from UI thread.");
            return;
        }
        if (this.playButton != null) {
            if (this.isPlayButtonEnabled && this.currentState != 4 && this.currentState != 6) {
                this.playButton.setVisibility(0);
            } else {
                this.playButton.setVisibility(8);
            }
        }
    }

    void setAudioFocus() {
        AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
        if (audioManager != null) {
            if (this.volume > 0.0f) {
                audioManager.requestAudioFocus(null, 3, 3);
            } else {
                audioManager.abandonAudioFocus(null);
            }
        }
    }

    void releaseAudioFocus() {
        AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
        if (audioManager != null) {
            audioManager.abandonAudioFocus(null);
        }
    }

    boolean isInPlaybackState() {
        return this.currentState != 0 && this.currentState != 1 && this.currentState != 2 && this.currentState != 7;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setAudioFocus();
    }

    protected void onDetachedFromWindow() {
        this.releaseAudioFocus();
        super.onDetachedFromWindow();
    }

    void postToCallbackExecutor(Runnable r) {
        if (this.callbackExecutor != null && !this.callbackExecutor.isShutdown()) {
            this.callbackExecutor.submit(r);
        }
    }

    void onSurfaceCreated(SurfaceHolder holder) {
        this.surfaceHolder = holder;
        if (!this.surfaceHolder.getSurface().isValid()) {
            this.currentState = 7;
            this.targetState = 7;
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onError((VideoPlayer)this);
                }
            });
            return;
        }
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setDisplay(this.surfaceHolder);
        }
        if (this.currentState == 2) {
            this.setAudioFocus();
            this.currentState = 3;
            if (this.videoWidth != 0 && this.videoHeight != 0) {
                this.surfaceHolder.setFixedSize(this.videoWidth, this.videoHeight);
            }
            this.postToCallbackExecutor(() -> {
                for (VideoPlayer.VideoPlayerListener listener : this.listeners) {
                    listener.onReady((VideoPlayer)this);
                }
            });
            if (this.targetState == 4) {
                this.play();
            }
        }
    }

    public void release() {
        this.unload();
    }

    private class VideoSurfaceView
    extends SurfaceView {
        VideoSurfaceView(Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int width = VideoSurfaceView.getDefaultSize((int)VerizonVideoPlayerView.this.videoWidth, (int)widthMeasureSpec);
            int height = VideoSurfaceView.getDefaultSize((int)VerizonVideoPlayerView.this.videoHeight, (int)heightMeasureSpec);
            if (VerizonVideoPlayerView.this.videoWidth > 0 && VerizonVideoPlayerView.this.videoHeight > 0) {
                int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                    width = widthSpecSize;
                    height = heightSpecSize;
                    if (VerizonVideoPlayerView.this.videoWidth * height < width * VerizonVideoPlayerView.this.videoHeight) {
                        width = height * VerizonVideoPlayerView.this.videoWidth / VerizonVideoPlayerView.this.videoHeight;
                    } else if (VerizonVideoPlayerView.this.videoWidth * height > width * VerizonVideoPlayerView.this.videoHeight) {
                        height = width * VerizonVideoPlayerView.this.videoHeight / VerizonVideoPlayerView.this.videoWidth;
                    }
                } else if (widthSpecMode == 0x40000000) {
                    width = widthSpecSize;
                    height = width * VerizonVideoPlayerView.this.videoHeight / VerizonVideoPlayerView.this.videoWidth;
                    if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                        height = heightSpecSize;
                    }
                } else if (heightSpecMode == 0x40000000) {
                    height = heightSpecSize;
                    width = height * VerizonVideoPlayerView.this.videoWidth / VerizonVideoPlayerView.this.videoHeight;
                    if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                        width = widthSpecSize;
                    }
                } else {
                    width = VerizonVideoPlayerView.this.videoWidth;
                    height = VerizonVideoPlayerView.this.videoHeight;
                    if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                        height = heightSpecSize;
                        width = height * VerizonVideoPlayerView.this.videoWidth / VerizonVideoPlayerView.this.videoHeight;
                    }
                    if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                        width = widthSpecSize;
                        height = width * VerizonVideoPlayerView.this.videoHeight / VerizonVideoPlayerView.this.videoWidth;
                    }
                }
            }
            this.setMeasuredDimension(width, height);
        }
    }

    static class ProgressHandler
    extends Handler {
        private static final int START = 1;
        private static final int STOP = 2;
        private static final int UPDATE = 3;
        private static final int SET_INTERVAL = 4;
        private boolean started = false;
        private WeakReference<VerizonVideoPlayerView> verizonVideoPlayerViewRef;
        private int interval;

        ProgressHandler(VerizonVideoPlayerView verizonVideoPlayerView, Looper looper, int interval) {
            super(looper);
            this.verizonVideoPlayerViewRef = new WeakReference<VerizonVideoPlayerView>(verizonVideoPlayerView);
            this.interval = interval;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.doStart(false);
                    break;
                }
                case 2: {
                    this.doStop();
                    break;
                }
                case 3: {
                    this.doUpdate();
                    break;
                }
                case 4: {
                    this.doSetInterval(msg.arg1);
                    break;
                }
                default: {
                    logger.e(String.format("Invalid what %d sent to ProgressHandler.", msg.what));
                }
            }
        }

        void sendStartMessage() {
            this.sendEmptyMessage(1);
        }

        void sendStopMessage() {
            this.sendEmptyMessage(2);
        }

        void setInterval(int interval) {
            this.sendMessage(this.obtainMessage(4, interval, 0));
        }

        private void doStart(boolean intervalChanged) {
            if (this.interval == -1) {
                return;
            }
            if (this.started) {
                return;
            }
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Starting progress handler with interval %d ms.", this.interval));
            }
            this.started = true;
            if (intervalChanged) {
                this.sendEmptyMessageDelayed(3, this.interval);
            } else {
                this.sendEmptyMessage(3);
            }
        }

        private void doStop() {
            if (!this.started) {
                return;
            }
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("Stopping progress handler.");
            }
            this.started = false;
            this.removeMessages(3);
        }

        private void doUpdate() {
            VerizonVideoPlayerView verizonVideoPlayerView = (VerizonVideoPlayerView)((Object)this.verizonVideoPlayerViewRef.get());
            if (verizonVideoPlayerView != null) {
                int currentPosition = verizonVideoPlayerView.mediaPlayer.getCurrentPosition();
                verizonVideoPlayerView.postToCallbackExecutor(() -> {
                    for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayerView.listeners) {
                        listener.onProgress((VideoPlayer)verizonVideoPlayerView, currentPosition);
                    }
                });
                this.sendEmptyMessageDelayed(3, this.interval);
            }
        }

        private void doSetInterval(int interval) {
            this.interval = interval;
            if (!this.started) {
                return;
            }
            this.doStop();
            if (this.interval != -1) {
                this.doStart(true);
            }
        }
    }

    static class Factory
    implements ComponentFactory {
        Factory() {
        }

        public Component newInstance(Context context, JSONObject jsonObject, Object ... objects) {
            return new VerizonVideoPlayerView(context);
        }
    }

    static class VideoViewInfo
    extends View.BaseSavedState {
        public static final Parcelable.Creator<VideoViewInfo> CREATOR = new Parcelable.Creator<VideoViewInfo>(){

            public VideoViewInfo createFromParcel(Parcel source) {
                return new VideoViewInfo(source);
            }

            public VideoViewInfo[] newArray(int size) {
                return new VideoViewInfo[size];
            }
        };
        int currentState;
        int targetState;
        int currentPosition;
        float volume;
        String uri;

        VideoViewInfo(Parcelable superState) {
            super(superState);
        }

        private VideoViewInfo(Parcel source) {
            super(source);
            this.currentState = source.readInt();
            this.targetState = source.readInt();
            this.currentPosition = source.readInt();
            this.volume = source.readFloat();
            this.uri = source.readString();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.currentState);
            dest.writeInt(this.targetState);
            dest.writeInt(this.currentPosition);
            dest.writeFloat(this.volume);
            dest.writeString(this.uri);
        }
    }

    static class MediaPlayerListener
    implements MediaPlayer.OnCompletionListener,
    MediaPlayer.OnErrorListener,
    MediaPlayer.OnPreparedListener,
    MediaPlayer.OnVideoSizeChangedListener,
    MediaPlayer.OnSeekCompleteListener {
        private WeakReference<VerizonVideoPlayerView> verizonVideoPlayerViewRef;

        MediaPlayerListener(VerizonVideoPlayerView verizonVideoPlayerView) {
            this.verizonVideoPlayerViewRef = new WeakReference<VerizonVideoPlayerView>(verizonVideoPlayerView);
        }

        public void onCompletion(MediaPlayer mediaPlayer) {
            VerizonVideoPlayerView verizonVideoPlayerView = (VerizonVideoPlayerView)((Object)this.verizonVideoPlayerViewRef.get());
            if (verizonVideoPlayerView != null) {
                verizonVideoPlayerView.currentState = 6;
                verizonVideoPlayerView.targetState = 6;
                verizonVideoPlayerView.progressHandler.sendStopMessage();
                int duration = verizonVideoPlayerView.getDuration();
                ThreadUtils.postOnUiThread(() -> verizonVideoPlayerView.updateReplayVisibility());
                verizonVideoPlayerView.postToCallbackExecutor(() -> {
                    for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayerView.listeners) {
                        listener.onProgress((VideoPlayer)verizonVideoPlayerView, duration);
                        listener.onComplete((VideoPlayer)verizonVideoPlayerView);
                    }
                });
            }
        }

        public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
            VerizonVideoPlayerView verizonVideoPlayerView = (VerizonVideoPlayerView)((Object)this.verizonVideoPlayerViewRef.get());
            if (verizonVideoPlayerView != null) {
                if (what == 1 && extra == -19 || what == -38) {
                    if (Logger.isLogLevelEnabled((int)3)) {
                        logger.d(String.format("Ignoring acceptable media error: (%d, %d)", what, extra));
                    }
                    return true;
                }
                verizonVideoPlayerView.currentState = 7;
                verizonVideoPlayerView.postToCallbackExecutor(() -> {
                    for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayerView.listeners) {
                        listener.onError((VideoPlayer)verizonVideoPlayerView);
                    }
                });
            }
            return true;
        }

        public void onPrepared(MediaPlayer mediaPlayer) {
            VerizonVideoPlayerView verizonVideoPlayerView = (VerizonVideoPlayerView)((Object)this.verizonVideoPlayerViewRef.get());
            if (verizonVideoPlayerView != null) {
                if (verizonVideoPlayerView.surfaceHolder != null) {
                    verizonVideoPlayerView.setAudioFocus();
                    verizonVideoPlayerView.currentState = 3;
                    verizonVideoPlayerView.postToCallbackExecutor(() -> {
                        for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayerView.listeners) {
                            listener.onLoaded((VideoPlayer)verizonVideoPlayerView);
                            listener.onReady((VideoPlayer)verizonVideoPlayerView);
                        }
                    });
                    if (verizonVideoPlayerView.targetState == 4) {
                        verizonVideoPlayerView.play();
                    }
                } else {
                    verizonVideoPlayerView.currentState = 2;
                    verizonVideoPlayerView.postToCallbackExecutor(() -> {
                        for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayerView.listeners) {
                            listener.onLoaded((VideoPlayer)verizonVideoPlayerView);
                        }
                    });
                }
            }
        }

        public void onSeekComplete(MediaPlayer mp) {
            VerizonVideoPlayerView verizonVideoPlayerView = (VerizonVideoPlayerView)((Object)this.verizonVideoPlayerViewRef.get());
            if (verizonVideoPlayerView != null) {
                verizonVideoPlayerView.postToCallbackExecutor(() -> {
                    for (VideoPlayer.VideoPlayerListener listener : verizonVideoPlayerView.listeners) {
                        listener.onSeekCompleted((VideoPlayer)verizonVideoPlayerView);
                    }
                });
            }
        }

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            VerizonVideoPlayerView verizonVideoPlayerView = (VerizonVideoPlayerView)((Object)this.verizonVideoPlayerViewRef.get());
            if (verizonVideoPlayerView != null && height != 0 && width != 0) {
                verizonVideoPlayerView.videoWidth = width;
                verizonVideoPlayerView.videoHeight = height;
                if (verizonVideoPlayerView.surfaceHolder != null) {
                    verizonVideoPlayerView.surfaceHolder.setFixedSize(width, height);
                    verizonVideoPlayerView.requestLayout();
                }
            }
        }
    }
}

