/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.videoplayer;

import android.content.Context;
import android.content.MutableContextWrapper;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.verizon.ads.Logger;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class VideoView
extends RelativeLayout {
    private static final Logger logger = Logger.getInstance(VideoView.class);
    private static final int PROGRESS_POLLING_INTERVAL = 1000;
    private static final int MEDIA_ERROR_EXTRA_AUDIO_NO_INIT = -19;
    private static final int MEDIA_ERROR_STATE_EXCEPTION = -38;
    private final ExecutorService callbackExecutor = Executors.newSingleThreadExecutor();
    private final Set<VideoViewListener> listeners = new HashSet<VideoViewListener>();
    private Uri uri;
    private int videoWidth;
    private int videoHeight;
    private MediaPlayer mediaPlayer;
    private SurfaceHolder surfaceHolder;
    private float volume = 1.0f;
    private ProgressHandler progressHandler;
    private HandlerThread progressHandlerThread;
    private int progressInterval = 1000;
    private int seekToMilliseconds = 0;
    private volatile int targetState;
    private volatile int currentState = 0;
    public static final int IDLE = 0;
    public static final int LOADING = 1;
    public static final int LOADED = 2;
    public static final int READY = 3;
    public static final int PLAYING = 4;
    public static final int PAUSED = 5;
    public static final int COMPLETED = 6;
    public static final int ERROR = 7;

    public VideoView(Context context) {
        this(context, null, 0);
    }

    public VideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super((Context)new MutableContextWrapper(context), attrs, defStyleAttr);
        this.setBackgroundColor(this.getResources().getColor(17170444));
        MutableContextWrapper mutableContext = (MutableContextWrapper)this.getContext();
        VideoSurfaceView surfaceView = new VideoSurfaceView((Context)mutableContext);
        surfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                VideoView.this.onSurfaceCreated(holder);
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                if (VideoView.this.mediaPlayer != null && VideoView.this.targetState == 4) {
                    VideoView.this.play();
                }
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                VideoView.this.surfaceHolder = null;
                if (VideoView.this.mediaPlayer != null) {
                    VideoView.this.mediaPlayer.setDisplay(null);
                }
            }
        });
        surfaceView.getHolder().setType(3);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(13);
        this.addView((View)surfaceView, (ViewGroup.LayoutParams)layoutParams);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        VideoViewInfo videoViewInfo = (VideoViewInfo)state;
        super.onRestoreInstanceState(videoViewInfo.getSuperState());
        this.restoreFromVideoViewInfo(videoViewInfo);
    }

    void restoreFromVideoViewInfo(VideoViewInfo videoViewInfo) {
        this.targetState = videoViewInfo.targetState;
        this.seekToMilliseconds = videoViewInfo.currentPosition;
        this.setVolume(videoViewInfo.volume);
        if (videoViewInfo.currentState == 4 || videoViewInfo.targetState == 4) {
            this.play();
        }
    }

    protected Parcelable onSaveInstanceState() {
        return this.createVideoViewInfo(super.onSaveInstanceState());
    }

    @NonNull
    Parcelable createVideoViewInfo(Parcelable parentState) {
        VideoViewInfo videoViewInfo = new VideoViewInfo(parentState);
        videoViewInfo.currentState = this.currentState;
        videoViewInfo.targetState = this.targetState;
        videoViewInfo.currentPosition = this.getCurrentPosition();
        videoViewInfo.volume = this.getVolume();
        videoViewInfo.uri = this.uri != null ? this.uri.toString() : null;
        return videoViewInfo;
    }

    public void unload() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("unload must be called from UI thread.");
            return;
        }
        if (this.mediaPlayer != null) {
            if (this.progressHandlerThread != null) {
                this.progressHandlerThread.quit();
            }
            this.mediaPlayer.setDisplay(null);
            this.mediaPlayer.reset();
            this.mediaPlayer.release();
            this.mediaPlayer = null;
            this.currentState = 0;
            this.postToCallbackExecutor(new Runnable(){

                @Override
                public void run() {
                    for (VideoViewListener listener : VideoView.this.listeners) {
                        listener.onUnloaded(VideoView.this);
                    }
                }
            });
        }
    }

    public void load(Uri uri) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("load must be called from UI thread.");
            return;
        }
        this.uri = uri;
        if (uri == null) {
            return;
        }
        this.unload();
        this.progressHandlerThread = new HandlerThread("vp-progress-handler");
        this.progressHandlerThread.start();
        this.progressHandler = new ProgressHandler(this, this.progressHandlerThread.getLooper(), this.progressInterval);
        this.mediaPlayer = new MediaPlayer();
        if (this.surfaceHolder != null) {
            this.mediaPlayer.setDisplay(this.surfaceHolder);
        }
        MediaPlayerListener mediaPlayerListener = new MediaPlayerListener(this);
        this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)mediaPlayerListener);
        this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)mediaPlayerListener);
        this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)mediaPlayerListener);
        this.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)mediaPlayerListener);
        this.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)mediaPlayerListener);
        try {
            this.mediaPlayer.setDataSource(this.getContext(), uri, null);
            this.currentState = 1;
            this.mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            logger.e("An error occurred preparing the VideoPlayer.", (Throwable)e);
            this.currentState = 7;
            this.targetState = 7;
            this.postToCallbackExecutor(new Runnable(){

                @Override
                public void run() {
                    for (VideoViewListener listener : VideoView.this.listeners) {
                        listener.onError(VideoView.this);
                    }
                }
            });
        }
    }

    void setAudioFocus() {
        AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
        if (audioManager != null) {
            if (this.volume > 0.0f) {
                audioManager.requestAudioFocus(null, 3, 3);
            } else {
                audioManager.abandonAudioFocus(null);
            }
        }
    }

    void releaseAudioFocus() {
        AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
        if (audioManager != null) {
            audioManager.abandonAudioFocus(null);
        }
    }

    public void load(String path) {
        this.load(Uri.parse((String)path));
    }

    public void replay() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("replay must be called from UI thread.");
            return;
        }
        if (Build.VERSION.SDK_INT <= 21) {
            if (this.uri == null) {
                return;
            }
            this.load(this.uri);
        } else {
            this.seekTo(0);
        }
        this.play();
    }

    public void play() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("play must be called from UI thread.");
            return;
        }
        if (this.isInPlaybackState() && this.currentState != 4) {
            this.setVolume(this.volume);
            if (this.seekToMilliseconds != 0) {
                this.mediaPlayer.seekTo(this.seekToMilliseconds);
                this.seekToMilliseconds = 0;
            }
            this.mediaPlayer.start();
            this.currentState = 4;
            this.targetState = 4;
            this.postToCallbackExecutor(new Runnable(){

                @Override
                public void run() {
                    for (VideoViewListener listener : VideoView.this.listeners) {
                        listener.onPlay(VideoView.this);
                    }
                }
            });
            this.progressHandler.sendStartMessage();
        } else {
            this.targetState = 4;
        }
    }

    public void pause() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("pause must be called from UI thread.");
            return;
        }
        if (this.isInPlaybackState() && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.pause();
            this.postToCallbackExecutor(new Runnable(){

                @Override
                public void run() {
                    for (VideoViewListener listener : VideoView.this.listeners) {
                        listener.onPaused(VideoView.this);
                    }
                }
            });
            this.currentState = 5;
            this.targetState = 5;
        }
    }

    public void seekTo(int milliseconds) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("seekTo must be called from UI thread.");
            return;
        }
        if (this.isInPlaybackState()) {
            this.mediaPlayer.seekTo(milliseconds);
            this.seekToMilliseconds = 0;
        } else {
            this.seekToMilliseconds = milliseconds;
        }
    }

    public void setVolume(final float volume) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setVolume must be called from UI thread.");
            return;
        }
        this.volume = volume;
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setVolume(volume, volume);
            this.postToCallbackExecutor(new Runnable(){

                @Override
                public void run() {
                    for (VideoViewListener listener : VideoView.this.listeners) {
                        listener.onVolumeChanged(VideoView.this, volume);
                    }
                }
            });
        }
        this.setAudioFocus();
    }

    public float getVolume() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("getVolume must be called from UI thread.");
            return -1.0f;
        }
        return this.volume;
    }

    public int getCurrentPosition() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("getCurrentPosition must be called from UI thread.");
            return -1;
        }
        if (this.isInPlaybackState()) {
            return this.mediaPlayer.getCurrentPosition();
        }
        return -1;
    }

    public int getDuration() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("getDuration must be called from UI thread.");
            return -1;
        }
        if (this.isInPlaybackState() || this.currentState == 2) {
            return this.mediaPlayer.getDuration();
        }
        return -1;
    }

    public void registerListener(final VideoViewListener videoViewListener) {
        if (videoViewListener == null) {
            logger.w("Cannot register a null instance.");
            return;
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("registerListener must be called from UI thread.");
            return;
        }
        this.postToCallbackExecutor(new Runnable(){

            @Override
            public void run() {
                VideoView.this.listeners.add(videoViewListener);
            }
        });
    }

    public void unregisterListener(final VideoViewListener videoViewListener) {
        if (videoViewListener == null) {
            logger.w("Cannot unregister a null instance.");
            return;
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("unregisterListener must be called from UI thread.");
            return;
        }
        this.postToCallbackExecutor(new Runnable(){

            @Override
            public void run() {
                VideoView.this.listeners.remove(videoViewListener);
            }
        });
    }

    public int getState() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("unregisterListener must be called from UI thread.");
            return -1;
        }
        return this.currentState;
    }

    public void setProgressInterval(int progressInterval) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setProgressInterval must be called from UI thread.");
            return;
        }
        int n = this.progressInterval = progressInterval < 1000 && progressInterval != -1 ? 1000 : progressInterval;
        if (this.progressHandler != null) {
            this.progressHandler.setInterval(progressInterval);
        }
    }

    boolean isInPlaybackState() {
        return this.currentState != 0 && this.currentState != 1 && this.currentState != 2 && this.currentState != 7;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setAudioFocus();
    }

    protected void onDetachedFromWindow() {
        this.releaseAudioFocus();
        super.onDetachedFromWindow();
    }

    void postToCallbackExecutor(Runnable r) {
        if (this.callbackExecutor != null && !this.callbackExecutor.isShutdown()) {
            this.callbackExecutor.submit(r);
        }
    }

    void onSurfaceCreated(SurfaceHolder holder) {
        this.surfaceHolder = holder;
        if (!this.surfaceHolder.getSurface().isValid()) {
            this.currentState = 7;
            this.targetState = 7;
            this.postToCallbackExecutor(new Runnable(){

                @Override
                public void run() {
                    for (VideoViewListener listener : VideoView.this.listeners) {
                        listener.onError(VideoView.this);
                    }
                }
            });
            return;
        }
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setDisplay(this.surfaceHolder);
        }
        if (this.currentState == 2) {
            this.setAudioFocus();
            this.currentState = 3;
            if (this.videoWidth != 0 && this.videoHeight != 0) {
                this.surfaceHolder.setFixedSize(this.videoWidth, this.videoHeight);
            }
            this.postToCallbackExecutor(new Runnable(){

                @Override
                public void run() {
                    for (VideoViewListener listener : VideoView.this.listeners) {
                        listener.onReady(VideoView.this);
                    }
                }
            });
            if (this.targetState == 4) {
                this.play();
            }
        }
    }

    static class ProgressHandler
    extends Handler {
        private static final int START = 1;
        private static final int STOP = 2;
        private static final int UPDATE = 3;
        private static final int SET_INTERVAL = 4;
        private boolean started = false;
        private WeakReference<VideoView> videoViewRef;
        private int interval;

        ProgressHandler(VideoView videoView, Looper looper, int interval) {
            super(looper);
            this.videoViewRef = new WeakReference<VideoView>(videoView);
            this.interval = interval;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.doStart(false);
                    break;
                }
                case 2: {
                    this.doStop();
                    break;
                }
                case 3: {
                    this.doUpdate();
                    break;
                }
                case 4: {
                    this.doSetInterval(msg.arg1);
                    break;
                }
                default: {
                    logger.e(String.format("Invalid what %d sent to ProgressHandler.", msg.what));
                }
            }
        }

        void sendStartMessage() {
            this.sendEmptyMessage(1);
        }

        void sendStopMessage() {
            this.sendEmptyMessage(2);
        }

        void setInterval(int interval) {
            this.sendMessage(this.obtainMessage(4, interval, 0));
        }

        private void doStart(boolean intervalChanged) {
            if (this.interval == -1) {
                return;
            }
            if (this.started) {
                return;
            }
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Starting progress handler with interval %d ms.", this.interval));
            }
            this.started = true;
            if (intervalChanged) {
                this.sendEmptyMessageDelayed(3, this.interval);
            } else {
                this.sendEmptyMessage(3);
            }
        }

        private void doStop() {
            if (!this.started) {
                return;
            }
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("Stopping progress handler.");
            }
            this.started = false;
            this.removeMessages(3);
        }

        private void doUpdate() {
            final VideoView videoView = (VideoView)((Object)this.videoViewRef.get());
            if (videoView != null) {
                final int currentPosition = videoView.mediaPlayer.getCurrentPosition();
                videoView.postToCallbackExecutor(new Runnable(){

                    @Override
                    public void run() {
                        for (VideoViewListener listener : videoView.listeners) {
                            listener.onProgress(videoView, currentPosition);
                        }
                        ProgressHandler.this.sendEmptyMessageDelayed(3, ProgressHandler.this.interval);
                    }
                });
            }
        }

        private void doSetInterval(int interval) {
            this.interval = interval;
            this.doStop();
            if (this.interval != -1) {
                this.doStart(true);
            }
        }
    }

    private class VideoSurfaceView
    extends SurfaceView {
        VideoSurfaceView(Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int width = VideoSurfaceView.getDefaultSize((int)VideoView.this.videoWidth, (int)widthMeasureSpec);
            int height = VideoSurfaceView.getDefaultSize((int)VideoView.this.videoHeight, (int)heightMeasureSpec);
            if (VideoView.this.videoWidth > 0 && VideoView.this.videoHeight > 0) {
                int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                    width = widthSpecSize;
                    height = heightSpecSize;
                    if (VideoView.this.videoWidth * height < width * VideoView.this.videoHeight) {
                        width = height * VideoView.this.videoWidth / VideoView.this.videoHeight;
                    } else if (VideoView.this.videoWidth * height > width * VideoView.this.videoHeight) {
                        height = width * VideoView.this.videoHeight / VideoView.this.videoWidth;
                    }
                } else if (widthSpecMode == 0x40000000) {
                    width = widthSpecSize;
                    height = width * VideoView.this.videoHeight / VideoView.this.videoWidth;
                    if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                        height = heightSpecSize;
                    }
                } else if (heightSpecMode == 0x40000000) {
                    height = heightSpecSize;
                    width = height * VideoView.this.videoWidth / VideoView.this.videoHeight;
                    if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                        width = widthSpecSize;
                    }
                } else {
                    width = VideoView.this.videoWidth;
                    height = VideoView.this.videoHeight;
                    if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                        height = heightSpecSize;
                        width = height * VideoView.this.videoWidth / VideoView.this.videoHeight;
                    }
                    if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                        width = widthSpecSize;
                        height = width * VideoView.this.videoHeight / VideoView.this.videoWidth;
                    }
                }
            }
            this.setMeasuredDimension(width, height);
        }
    }

    static class VideoViewInfo
    extends View.BaseSavedState {
        int currentState;
        int targetState;
        int currentPosition;
        float volume;
        String uri;
        public static final Parcelable.Creator<VideoViewInfo> CREATOR = new Parcelable.Creator<VideoViewInfo>(){

            public VideoViewInfo createFromParcel(Parcel source) {
                return new VideoViewInfo(source);
            }

            public VideoViewInfo[] newArray(int size) {
                return new VideoViewInfo[size];
            }
        };

        VideoViewInfo(Parcelable superState) {
            super(superState);
        }

        private VideoViewInfo(Parcel source) {
            super(source);
            this.currentState = source.readInt();
            this.targetState = source.readInt();
            this.currentPosition = source.readInt();
            this.volume = source.readFloat();
            this.uri = source.readString();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.currentState);
            dest.writeInt(this.targetState);
            dest.writeInt(this.currentPosition);
            dest.writeFloat(this.volume);
            dest.writeString(this.uri);
        }
    }

    static class MediaPlayerListener
    implements MediaPlayer.OnCompletionListener,
    MediaPlayer.OnErrorListener,
    MediaPlayer.OnPreparedListener,
    MediaPlayer.OnVideoSizeChangedListener,
    MediaPlayer.OnSeekCompleteListener {
        private WeakReference<VideoView> videoViewRef;

        MediaPlayerListener(VideoView videoView) {
            this.videoViewRef = new WeakReference<VideoView>(videoView);
        }

        public void onCompletion(MediaPlayer mediaPlayer) {
            final VideoView videoView = (VideoView)((Object)this.videoViewRef.get());
            if (videoView != null) {
                videoView.currentState = 6;
                videoView.targetState = 6;
                videoView.progressHandler.sendStopMessage();
                final int duration = videoView.getDuration();
                videoView.postToCallbackExecutor(new Runnable(){

                    @Override
                    public void run() {
                        for (VideoViewListener listener : videoView.listeners) {
                            listener.onProgress(videoView, duration);
                            listener.onComplete(videoView);
                        }
                    }
                });
            }
        }

        public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
            final VideoView videoView = (VideoView)((Object)this.videoViewRef.get());
            if (videoView != null) {
                if (what == 1 && extra == -19 || what == -38) {
                    if (Logger.isLogLevelEnabled((int)3)) {
                        logger.d(String.format("Ignoring acceptable media error: (%d, %d)", what, extra));
                    }
                    return true;
                }
                videoView.currentState = 7;
                videoView.postToCallbackExecutor(new Runnable(){

                    @Override
                    public void run() {
                        for (VideoViewListener listener : videoView.listeners) {
                            listener.onError(videoView);
                        }
                    }
                });
            }
            return true;
        }

        public void onPrepared(MediaPlayer mediaPlayer) {
            final VideoView videoView = (VideoView)((Object)this.videoViewRef.get());
            if (videoView != null) {
                if (videoView.surfaceHolder != null) {
                    videoView.setAudioFocus();
                    videoView.currentState = 3;
                    videoView.postToCallbackExecutor(new Runnable(){

                        @Override
                        public void run() {
                            for (VideoViewListener listener : videoView.listeners) {
                                listener.onLoaded(videoView);
                                listener.onReady(videoView);
                            }
                        }
                    });
                    if (videoView.targetState == 4) {
                        videoView.play();
                    }
                } else {
                    videoView.currentState = 2;
                    videoView.postToCallbackExecutor(new Runnable(){

                        @Override
                        public void run() {
                            for (VideoViewListener listener : videoView.listeners) {
                                listener.onLoaded(videoView);
                            }
                        }
                    });
                }
            }
        }

        public void onSeekComplete(MediaPlayer mp) {
            final VideoView videoView = (VideoView)((Object)this.videoViewRef.get());
            if (videoView != null) {
                videoView.postToCallbackExecutor(new Runnable(){

                    @Override
                    public void run() {
                        for (VideoViewListener listener : videoView.listeners) {
                            listener.onSeekCompleted(videoView);
                        }
                    }
                });
            }
        }

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            VideoView videoView = (VideoView)((Object)this.videoViewRef.get());
            if (videoView != null && height != 0 && width != 0) {
                videoView.videoWidth = width;
                videoView.videoHeight = height;
                if (videoView.surfaceHolder != null) {
                    videoView.surfaceHolder.setFixedSize(width, height);
                    videoView.requestLayout();
                }
            }
        }
    }

    public static interface VideoViewListener {
        public void onLoaded(VideoView var1);

        public void onUnloaded(VideoView var1);

        public void onReady(VideoView var1);

        public void onPlay(VideoView var1);

        public void onPaused(VideoView var1);

        public void onComplete(VideoView var1);

        public void onProgress(VideoView var1, int var2);

        public void onSeekCompleted(VideoView var1);

        public void onError(VideoView var1);

        public void onVolumeChanged(VideoView var1, float var2);
    }
}

