/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import com.verizon.ads.Component;
import com.verizon.ads.ComponentFactory;
import com.verizon.ads.Logger;
import com.verizon.ads.RuleComponent;
import com.verizon.ads.support.ViewabilityWatcherRule;
import com.verizon.ads.utils.ThreadUtils;
import java.util.Map;
import org.json.JSONObject;

@SuppressLint(value={"DefaultLocale"})
public class StaticViewabilityRuleComponent
extends ViewabilityWatcherRule
implements RuleComponent {
    private static final Logger logger = Logger.getInstance(StaticViewabilityRuleComponent.class);
    private final Map<String, Object> eventArgs;
    private final String eventId;
    private boolean ruleHasFired;
    private RuleComponent.RuleListener listener;
    private volatile ThreadUtils.ScheduledRunnable scheduledRunnable;

    protected StaticViewabilityRuleComponent(View view, RuleComponent.RuleListener listener, int percentage, int duration, boolean continuous, String eventId, Map<String, Object> eventArgs) {
        super(view, percentage, duration, continuous);
        this.listener = listener;
        this.eventId = eventId;
        this.eventArgs = eventArgs;
        this.ruleHasFired = false;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Map<String, Object> getEventArgs() {
        return this.eventArgs;
    }

    public void fire() {
        if (!StaticViewabilityRuleComponent.isOnUiThread()) {
            logger.e("Must be on the UI thread to fire rule");
            return;
        }
        if (this.ruleHasFired) {
            logger.d("Rule has already fired");
            return;
        }
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Firing rule: %s", this));
        }
        this.ruleHasFired = true;
        this.stopTracking();
        this.stopWatching();
        if (this.listener != null) {
            this.listener.onRuleFired((RuleComponent)this);
        }
    }

    public boolean hasFired() {
        return this.ruleHasFired;
    }

    public void reset() {
    }

    @Override
    public void release() {
        logger.d("Releasing");
        this.stopTracking();
        this.listener = null;
        super.release();
    }

    @Override
    @NonNull
    public String toString() {
        return String.format("StaticViewabilityRuleComponent{eventId: %s, %s}", this.eventId, super.toString());
    }

    @Override
    protected boolean shouldTrack() {
        return true;
    }

    @Override
    protected long getCurrentTrackingTime() {
        return System.currentTimeMillis();
    }

    @Override
    protected void onStartTracking() {
        long delay = Math.max((long)this.getDuration() - this.getTimeInView(), 0L);
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Starting rule timer with delay: %d, %s", delay, this));
        }
        this.scheduledRunnable = StaticViewabilityRuleComponent.runOnUiThreadDelayed(this::fire, delay);
    }

    @Override
    protected void onStopTracking() {
        if (this.scheduledRunnable != null) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Stopping rule timer: %s", this));
            }
            this.scheduledRunnable.cancel();
            this.scheduledRunnable = null;
        }
    }

    static boolean isOnUiThread() {
        return ThreadUtils.isUiThread();
    }

    static ThreadUtils.ScheduledRunnable runOnUiThreadDelayed(Runnable runnable, long delay) {
        return ThreadUtils.runOnUiThreadDelayed((Runnable)runnable, (long)delay);
    }

    public static class Factory
    implements ComponentFactory {
        public Component newInstance(Context context, JSONObject ruleInfo, Object ... args) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Creating StaticViewabilityRuleComponent with ruleInfo: %s", ruleInfo));
            }
            if (ruleInfo == null) {
                logger.e("ruleInfo cannot be null.");
                return null;
            }
            if (args == null || args.length < 2 || !(args[0] instanceof View) || !(args[1] instanceof RuleComponent.RuleListener)) {
                logger.e("Call to newInstance requires View and RuleListener");
                return null;
            }
            View view = (View)args[0];
            RuleComponent.RuleListener listener = (RuleComponent.RuleListener)args[1];
            JSONObject data = ruleInfo.optJSONObject("data");
            if (data == null) {
                logger.e("data in ruleInfo is either missing or not a dictionary");
                return null;
            }
            try {
                String eventId = data.getString("eventId");
                int percentage = data.getInt("percentage");
                int duration = data.getInt("duration");
                boolean continuous = data.getBoolean("continuous");
                if (percentage < 0 || percentage > 100) {
                    throw new Exception("Percentage must be >= 0 and <= 100");
                }
                if (duration < 0 || duration > 15000) {
                    throw new Exception("Duration must be >= 0 and <= 15000");
                }
                Map<String, Object> eventArgs = null;
                if (data.has("eventArgs")) {
                    eventArgs = ViewabilityWatcherRule.convertJSONToMap(data.getJSONObject("eventArgs"));
                }
                return this.createViewabilityRule(view, listener, percentage, duration, continuous, eventId, eventArgs);
            }
            catch (Exception e) {
                logger.e(String.format("Error creating StaticViewabilityRuleComponent with ruleInfo: %s", ruleInfo), (Throwable)e);
                return null;
            }
        }

        @NonNull
        StaticViewabilityRuleComponent createViewabilityRule(View view, RuleComponent.RuleListener listener, int percent, int duration, boolean continuous, String eventId, Map<String, Object> eventArgs) {
            StaticViewabilityRuleComponent viewabilityRule = new StaticViewabilityRuleComponent(view, listener, percent, duration, continuous, eventId, eventArgs);
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Rule created %s", viewabilityRule));
            }
            return viewabilityRule;
        }
    }
}

